// ------------------------------------------------
// File : main.cpp
// Date: 4-apr-2002
// Author: giles
// Desc: 
//		see .cpp for details
//		
// (c) 2002 peercast.org
// ------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------


#include <stdarg.h>
#include "stdio.h"
#include "channel.h"
#include "servent.h"
#include "servmgr.h"
#include "linux/lsys.h"
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>
#include "peercast.h"


// ----------------------------------
String iniFileName;
bool quit=false;


// ---------------------------------
class MyPeercastInst : public PeercastInstance
{
public:
	virtual Sys * APICALL createSys()
	{
		return new LSys();
	}
};
// ---------------------------------
class MyPeercastApp : public PeercastApplication
{
public:
	virtual const char * APICALL getIniFilename()
	{
		return iniFileName;
	}

	virtual const char *APICALL getClientTypeOS() 
	{
		return PCX_DL_LINUXSTA;
	}

	virtual void APICALL printLog(LogBuffer::TYPE t, const char *str)
	{
		if (t != LogBuffer::T_NONE)
			printf("[%s] ",LogBuffer::getTypeStr(t));
		printf("%s\n",str);
	}

};

// ----------------------------------
void setSettingsUI(){}
// ----------------------------------
void showConnections(){}
// ----------------------------------
void PRINTLOG(LogBuffer::TYPE type, const char *fmt,va_list ap)
{
}

// ----------------------------------
void sigProc(int sig)
{
	switch (sig)
	{
		case 2:
			if (!quit)
				LOG_DEBUG("Received QUIT signal");
			quit=true;
			break;
	}
}


// ----------------------------------
int thread1(ThreadInfo *)
{
	while (1)
	{
		printf("thread1 %f\n",10);
		sleep(2);
	}
	return 0;

}

// ----------------------------------
int thread2(ThreadInfo *)
{
	while (1)
	{
		printf("thread2 %f\n",10);
		sleep(2);
	}
	return 0;

}

// ----------------------------------
void *thread1a(void *)
{
	while (1)
	{
		printf("thread1 %f\n",10);
		sleep(2);
	}
	return 0;

}

// ----------------------------------
void *thread2a(void *)
{
	while (1)
	{
		printf("thread2 %f\n",10);
		sleep(2);
	}
	return 0;

}
#if 1
// ----------------------------------
int main2(int argc,char *argv[])
{
	pthread_t mythread;
  
	if ( pthread_create( &mythread, NULL, thread1a, NULL) ) 
	{
		fprintf(stderr,"cant create thread1\n");
		return -1;
	}

	if ( pthread_create( &mythread, NULL, thread2a, NULL) ) 
	{
		fprintf(stderr,"cant create thread2\n");
		return -1;
	}
	while (1)
		sleep(1000);

}
#endif




// ----------------------------------
int main(int argc, char* argv[])
{
#if 0

	ThreadInfo info1,info2;

	info1.func = thread1;
	info2.func = thread2;

	LSys *s = new LSys();


	s->startThread(&info1);
	s->startThread(&info2);
	while (1)
		s->sleep(100);
#endif
	
//	if (fork() != 0)
//		return 0;

	iniFileName.set("peercast.ini");

	if (argc > 2)
		if (strcmp(argv[1],"-inifile")==0)
			iniFileName.setFromString(argv[2]);

	peercastInst = new MyPeercastInst();
	peercastApp = new MyPeercastApp();

	peercastInst->init();


	signal(SIGINT, sigProc); 

	while (!quit)
		sys->sleep(1000);

	peercastInst->saveSettings();

	return 0;
}
