#include "sys.h"
#include "peercast.h"
#include "channel.h"
#include "servmgr.h"



// ---------------------------------
// globals

Sys *sys=NULL;
ChanMgr *chanMgr;
ServMgr *servMgr;

PeercastInstance *peercastInst=NULL;
PeercastApplication *peercastApp=NULL;

// ---------------------------------
void APICALL PeercastInstance::init()
{
	sys = createSys();
	servMgr = new ServMgr();
	chanMgr = new ChanMgr();

	if (peercastApp->getIniFilename())
		servMgr->loadSettings(peercastApp->getIniFilename());

	servMgr->start();
}
// --------------------------------------------------
void	APICALL PeercastInstance::setNotifyMask(int mask)
{
	servMgr->notifyMask = mask;
}
// --------------------------------------------------
int		APICALL PeercastInstance::getNotifyMask()
{
	return servMgr->notifyMask;
}

// --------------------------------------------------
void	APICALL PeercastInstance::setAutoConnect(bool on)
{
	servMgr->autoConnect = on;
}
// --------------------------------------------------
bool	APICALL PeercastInstance::getAutoConnect()
{
	return servMgr->autoConnect;
}
// --------------------------------------------------
void	APICALL PeercastInstance::setMaxOutput(int kbps)
{
	servMgr->maxBitrate = kbps;
}
// --------------------------------------------------
int		APICALL PeercastInstance::getMaxOutput()
{
	return servMgr->maxBitrate;
}
// --------------------------------------------------
void	APICALL PeercastInstance::setActive(bool on)
{
	servMgr->autoConnect = on;
	servMgr->autoServe = on;
}
// --------------------------------------------------
bool	APICALL PeercastInstance::getActive()
{
	return servMgr->autoConnect&&servMgr->autoServe;
}
// --------------------------------------------------
void	APICALL PeercastInstance::saveSettings()
{
	servMgr->saveSettings(peercastApp->getIniFilename());
}

// --------------------------------------------------
void	APICALL	PeercastInstance::setServerPort(int port)
{
	servMgr->serverHost.port = port;
	servMgr->restartServer = true;
}
// --------------------------------------------------
int		APICALL	PeercastInstance::getServerPort()
{
	return servMgr->serverHost.port;
}
// --------------------------------------------------
void	APICALL	PeercastInstance::setServerPassword(const char *pwd)
{
	strcpy(servMgr->password,pwd);
}
// --------------------------------------------------
const char *APICALL	PeercastInstance::getServerPassword()
{
	return servMgr->password;
}
// --------------------------------------------------
void	APICALL PeercastInstance::callLocalURL(const char *url)
{
	sys->callLocalURL(url,servMgr->serverHost.port);
}


// --------------------------------------------------
void ADDLOG2(const char *fmt,va_list ap,LogBuffer::TYPE type)
{
	char str[4096];
	vsprintf(str,fmt,ap);

	if (type != LogBuffer::T_NONE)
		sys->logBuf->write(str,type);

	peercastApp->printLog(type,str);
}
// --------------------------------------------------
void LOG(const char *fmt,...)
{
	va_list ap;
  	va_start(ap, fmt);
	ADDLOG2(fmt,ap,LogBuffer::T_DEBUG);
   	va_end(ap);	
}

// --------------------------------------------------
void LOG_ERROR(const char *fmt,...)
{
	if ((servMgr->showLog & (1<<LogBuffer::T_ERROR)) && (!servMgr->pauseLog))
	{
		va_list ap;
  		va_start(ap, fmt);
		ADDLOG2(fmt,ap,LogBuffer::T_ERROR);
   		va_end(ap);	
	}
}
// --------------------------------------------------
void LOG_DEBUG(const char *fmt,...)
{
	if ((servMgr->showLog & (1<<LogBuffer::T_DEBUG)) && (!servMgr->pauseLog))
	{
		va_list ap;
  		va_start(ap, fmt);
		ADDLOG2(fmt,ap,LogBuffer::T_DEBUG);
   		va_end(ap);	
	}
}
// --------------------------------------------------
void LOG_NETWORK(const char *fmt,...)
{
	if ((servMgr->showLog & (1<<LogBuffer::T_NETWORK)) && (!servMgr->pauseLog))
	{
		va_list ap;
  		va_start(ap, fmt);
		ADDLOG2(fmt,ap,LogBuffer::T_NETWORK);
   		va_end(ap);	
	}
}
// --------------------------------------------------
void LOG_CHANNEL(const char *fmt,...)
{
	if ((servMgr->showLog & (1<<LogBuffer::T_CHANNEL)) && (!servMgr->pauseLog))
	{
		va_list ap;
  		va_start(ap, fmt);
		ADDLOG2(fmt,ap,LogBuffer::T_CHANNEL);
   		va_end(ap);	
	}
}
