/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.select;

import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import tsukuba_bunko.peko.ActionControler;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.canvas.select.SelectItem;
import tsukuba_bunko.peko.canvas.select.SelectItemButton;

public class SelectCanvas
extends JComponent
implements KeyListener {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int VALIGN_TOP = 0;
    public static final int VALIGN_MIDDLE = 1;
    public static final int VALIGN_BOTTOM = 2;
    private boolean _active = false;
    private List _buttons = null;
    private String _id = null;
    private SelectItemButton _selected = null;
    private int _selectedIndex = -1;
    private int _lastKeyCode = -1;
    private int _align = 1;
    private int _verticalAlign = 0;
    private int _columns = 1;
    private int _columnSpan = 20;
    private int _rowSpan = 20;
    private int _boundSpan = 20;
    private Map _buttonStyle = null;
    private Dimension _dimensionCache = null;

    public void setAlignment(int n) {
        if (n != 1 && n != 0 && n != 2) {
            throw new IllegalArgumentException("invalid alignment type is specified.");
        }
        this._align = n;
    }

    public int getAlignment() {
        return this._align;
    }

    public void setVerticalAlignment(int n) {
        if (n != 1 && n != 0 && n != 2) {
            throw new IllegalArgumentException("invalid vertical alignment type is specified.");
        }
        this._verticalAlign = n;
    }

    public int getVericalAlignment() {
        return this._verticalAlign;
    }

    public void setColumns(int n) {
        this._columns = n;
    }

    public int getColumns() {
        return this._columns;
    }

    public void setColumnSpan(int n) {
        this._columnSpan = n;
    }

    public int getColumnSpan() {
        return this._columnSpan;
    }

    public void setRowSpan(int n) {
        this._rowSpan = n;
    }

    public int getRowSpan() {
        return this._rowSpan;
    }

    public void setBoundSpan(int n) {
        this._boundSpan = n;
    }

    public int getBoundSpan() {
        return this._boundSpan;
    }

    public void setButtonStyle(Map map) {
        this._buttonStyle = map;
    }

    public Map getButtonStyle() {
        return this._buttonStyle;
    }

    public String select(List list) {
        return this.select(list, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String select(List list, long l) {
        int n;
        int n2;
        Serializable serializable;
        if (this._buttonStyle == null) {
            throw new IllegalStateException("button styles is not specified.");
        }
        if (this._active) {
            Logger.debug("[canvas.select] already show selection.");
            return null;
        }
        KeyListener keyListener = this;
        synchronized (keyListener) {
            int n3;
            this._id = null;
            serializable = this.getSize(this._dimensionCache);
            n2 = list.size();
            n = 320;
            Integer n4 = (Integer)this._buttonStyle.get("select.button.witdth");
            if (n4 != null) {
                n = n4;
            }
            this.setVisible(false);
            SelectItem selectItem = null;
            SelectItemButton selectItemButton = null;
            ArrayList<SelectItemButton> arrayList = new ArrayList<SelectItemButton>(n2);
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            Dimension dimension = new Dimension(0, 0);
            for (n3 = 0; n3 < n2; ++n3) {
                if (n3 % this._columns == 0) {
                    n6 += n7;
                    if (selectItem != null) {
                        n6 += this._rowSpan;
                    }
                    n5 = 0;
                    n7 = 0;
                } else {
                    n5 += dimension.width + this._columnSpan;
                }
                selectItem = (SelectItem)list.get(n3);
                selectItemButton = new SelectItemButton(this);
                selectItemButton.setSelectItem(selectItem);
                selectItemButton.prepare(this._buttonStyle);
                arrayList.add(selectItemButton);
                this.add(selectItemButton);
                selectItemButton.setLocation(n5, n6);
                dimension = selectItemButton.getSize(dimension);
                if (dimension.height <= n7) continue;
                n7 = dimension.height;
            }
            n3 = n * this._columns + this._columnSpan * (this._columns - 1);
            int n8 = 0;
            if (n3 > serializable.width) {
                n8 = 0;
            } else if (n3 + this._boundSpan > serializable.width) {
                n8 = (serializable.width - n3) / 2;
            } else if (this._align == 1) {
                n8 = (serializable.width - n3) / 2;
            } else if (this._align == 0) {
                n8 = this._boundSpan;
            } else if (this._align == 2) {
                n8 = serializable.width - n3 - this._boundSpan;
            }
            int n9 = n6 + n7;
            int n10 = 0;
            if (n9 > serializable.height) {
                n10 = 0;
            } else if (n9 + this._boundSpan > serializable.height) {
                n10 = (serializable.height - n9) / 2;
            } else if (this._verticalAlign == 0) {
                n10 = this._boundSpan;
            } else if (this._verticalAlign == 1) {
                n10 = (serializable.height - n9) / 2;
            } else if (this._verticalAlign == 2) {
                n10 = serializable.height - n9 - this._boundSpan;
            }
            this.setLocation(n8, n10);
            this._buttons = arrayList;
            this._active = true;
            this.setVisible(true);
        }
        Logger.debug("[canvas.select] wait for selecting.");
        keyListener = PekoSystem.getInstance().getActionControler();
        if (l > 0L) {
            ((ActionControler)keyListener).stop(l);
        } else {
            ((ActionControler)keyListener).stop();
        }
        serializable = this;
        synchronized (serializable) {
            n2 = this._buttons.size();
            for (n = 0; n < n2; ++n) {
                this.remove((SelectItemButton)this._buttons.get(n));
            }
            this._buttons.clear();
            this._buttons = null;
        }
        Logger.debug("[canvas.select] id: " + this._id);
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this._active = false;
        SelectCanvas selectCanvas = this;
        synchronized (selectCanvas) {
            if (this._buttons != null) {
                this._id = null;
                ActionControler actionControler = PekoSystem.getInstance().getActionControler();
                actionControler.start();
                Logger.debug("[cenvas.select] canceled.");
            }
        }
    }

    public void itemSelecting(SelectItemButton selectItemButton) {
        SelectItemButton selectItemButton2 = this._selected;
        this._selected = selectItemButton;
        if (selectItemButton2 != null && selectItemButton2 != selectItemButton) {
            selectItemButton2.setSelected(false);
        }
        this._selectedIndex = this._buttons.indexOf(selectItemButton);
    }

    public void itemDeselected(SelectItemButton selectItemButton) {
        if (this._selected == selectItemButton) {
            this._selected = null;
            this._selectedIndex = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemSelected(SelectItemButton selectItemButton) {
        if (this._active) {
            SelectCanvas selectCanvas = this;
            synchronized (selectCanvas) {
                if (this._active) {
                    this._selected = null;
                    this._selectedIndex = -1;
                    this._id = selectItemButton.getSelectItem().getID();
                    this._active = false;
                    Logger.debug("[canvas.select] selected: " + this._id);
                    ActionControler actionControler = PekoSystem.getInstance().getActionControler();
                    actionControler.start();
                }
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this._active) {
            int n = keyEvent.getKeyCode();
            if (this._lastKeyCode == -1) {
                this._lastKeyCode = n;
            } else if (this._lastKeyCode != n) {
                this._lastKeyCode = -1;
            }
            int n2 = this._selectedIndex;
            int n3 = this._buttons.size();
            if (n == 40) {
                n2 = (n2 + 1) % n3;
            } else if (n == 39 && this._columns > 1) {
                n2 = (n2 + 1) % n3;
            } else if (n == 38) {
                if (--n2 < 0) {
                    n2 = this._buttons.size() - 1;
                }
            } else if (n == 37 && this._columns > 1) {
                if (--n2 < 0) {
                    n2 = this._buttons.size() - 1;
                }
            } else {
                return;
            }
            SelectItemButton selectItemButton = (SelectItemButton)this._buttons.get(n2);
            selectItemButton.setSelected(true);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!this._active || this._buttons == null) {
            return;
        }
        int n = keyEvent.getKeyCode();
        if (n != this._lastKeyCode) {
            this._lastKeyCode = -1;
            return;
        }
        if (n == 10 && this._selected != null) {
            this.itemSelected(this._selected);
        }
        this._lastKeyCode = -1;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

