/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.stage;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.canvas.stage.Actor;
import tsukuba_bunko.peko.canvas.stage.Effect;
import tsukuba_bunko.peko.canvas.stage.Stage;
import tsukuba_bunko.peko.canvas.stage.effect.ImmediateEffect;
import tsukuba_bunko.peko.canvas.stage.effect.MofingEffect;
import tsukuba_bunko.peko.canvas.stage.effect.PataPataEffect;
import tsukuba_bunko.peko.resource.ResourceManager;

public class StageCanvas
extends JComponent {
    private Stage _stage = null;
    private boolean _usingEffect = false;
    private Map _effects = null;
    private BufferedImage _screen = null;
    private BufferedImage _working = null;
    private Dimension _size = new Dimension();

    public StageCanvas() {
        this.initialize();
    }

    public void setStage(Stage stage) {
        if (this._stage != null) {
            this._stage.dispose();
        }
        this._stage = stage;
        this._stage.setStageCanvas(this);
    }

    public Stage getStage() {
        return this._stage;
    }

    public void setUsingEffect(boolean bl) {
        this._usingEffect = bl;
    }

    public boolean isUsingEffect() {
        return this._usingEffect;
    }

    private void initialize() {
        ResourceManager resourceManager = ResourceManager.getInstance();
        Dimension dimension = (Dimension)resourceManager.getResource("peko.canvas.canvas-size");
        super.setPreferredSize(dimension);
        super.setSize(dimension);
        this._screen = new BufferedImage(dimension.width, dimension.height, 1);
        this._working = new BufferedImage(dimension.width, dimension.height, 1);
        super.setLayout(null);
        this._effects = new HashMap(89);
        Effect effect = new MofingEffect();
        this._effects.put(effect.getName(), effect);
        effect = new PataPataEffect();
        this._effects.put(effect.getName(), effect);
        effect = (Effect)this._effects.get("immediate");
        if (effect == null) {
            effect = new ImmediateEffect();
            this._effects.put("immediate", effect);
        }
        this._effects.put(null, effect);
    }

    public void updateCanvas() {
        this.updateCanvas(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCanvas(String string) {
        Object object;
        Object object2;
        if (!this.isEnabled()) {
            return;
        }
        Graphics2D graphics2D = this._working.createGraphics();
        Dimension dimension = this.getSize(this._size);
        if (this._stage.getSlide() == null) {
            object2 = this._stage.getBackgroundImage();
            if (object2 != null) {
                graphics2D.drawImage((Image)object2, 0, 0, this);
            } else {
                graphics2D.setColor(this._stage.getBackgroundColor());
                graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            }
            object = this._stage.getActors();
            if (object != null) {
                Iterator iterator = object.values().iterator();
                Actor actor = null;
                Image image = null;
                int n = 0;
                int n2 = 0;
                while (iterator.hasNext()) {
                    actor = (Actor)iterator.next();
                    image = actor.getLooksImage();
                    if (image == null) continue;
                    n = this.computePosition(actor);
                    n2 = dimension.height - image.getHeight(this);
                    graphics2D.drawImage(image, n, n2, this);
                }
            }
        } else {
            object2 = this._stage.getSlideImage();
            if (object2 != null) {
                graphics2D.drawImage((Image)object2, 0, 0, this);
            } else {
                graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            }
        }
        if (this._usingEffect) {
            object2 = (Effect)this._effects.get(string);
            if (object2 != null) {
                ((Effect)object2).process(this, this._screen, this._working);
            } else {
                Logger.error("[canvas.stage] unsuported effect name. :" + object2);
                this._screen.setData(this._working.getRaster());
                this.repaint();
            }
            object = this;
            synchronized (object) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    Logger.debug("[canvas.stage] interrupted after effect.", interruptedException);
                }
            }
        }
        this._screen.setData(this._working.getRaster());
        this.repaint();
    }

    public void paintPageBackground(boolean bl) {
        Graphics2D graphics2D = this._screen.createGraphics();
        graphics2D.drawImage((Image)this._working, 0, 0, this);
        if (bl) {
            PekoSystem.getInstance().getCanvasManager().getTextCanvas().paintPageBackground(graphics2D);
        }
        graphics2D.dispose();
        this.repaint();
    }

    private int computePosition(Actor actor) {
        int n = actor.getLooksImage().getWidth(this) / 2;
        Dimension dimension = this.getSize(this._size);
        switch (actor.getPosition()) {
            case 0: {
                return (int)((float)dimension.width / 2.0f) - n;
            }
            case 1: {
                return (int)((float)dimension.width / 4.0f) - n;
            }
            case 2: {
                return (int)((float)dimension.width / 4.0f * 3.0f) - n;
            }
        }
        return (int)actor.getAbsolutePosition() - n;
    }

    protected void paintComponent(Graphics graphics) {
        graphics.drawImage(this._screen, 0, 0, this);
    }
}

