/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.text;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.text.Line;
import tsukuba_bunko.peko.canvas.text.TextCanvas;

public class Page
implements Cloneable,
Serializable {
    private transient TextCanvas _canvas = null;
    private List _committedLines = null;
    private float _commitedPageHeight = 0.0f;
    private transient List _lines = null;
    private transient float _pageHeight = 0.0f;
    private transient boolean _dirty = false;
    private transient Font _defaultFont = null;
    private Dimension _size = new Dimension();
    private Point _location = new Point(0, 0);
    private Insets _padding = new Insets(10, 10, 10, 10);
    private Color _foreground = Color.white;
    private Color _shadow = Color.black;
    private Color _background = Color.black;
    private float _transparency = 0.5f;

    void setTextCanvas(TextCanvas textCanvas) {
        this._canvas = textCanvas;
    }

    public TextCanvas getTextCanvas() {
        return this._canvas;
    }

    public void setDefaultFont(Font font) {
        this._defaultFont = font;
    }

    public Font getDefaultFont() {
        return this._defaultFont;
    }

    public FontRenderContext getFontRenderContext() {
        if (this._canvas == null) {
            return null;
        }
        return this._canvas.getFontRenderContext();
    }

    public void setSize(Dimension dimension) {
        this._size.setSize(dimension);
    }

    public Dimension getSize() {
        return this.getSize(new Dimension());
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        dimension.setSize(this._size);
        return dimension;
    }

    public void setLocation(int n, int n2) {
        this._location.x = n;
        this._location.y = n2;
    }

    public Point getMargin() {
        return this.getLocation(null);
    }

    public Point getLocation(Point point) {
        if (point == null) {
            point = (Point)this._location.clone();
        } else {
            point.x = this._location.x;
            point.y = this._location.y;
        }
        return point;
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        this._padding.top = n;
        this._padding.left = n2;
        this._padding.bottom = n3;
        this._padding.right = n4;
    }

    public Insets getPadding() {
        return this.getPadding(null);
    }

    public Insets getPadding(Insets insets) {
        if (insets == null) {
            insets = (Insets)this._padding.clone();
        } else {
            insets.top = this._padding.top;
            insets.left = this._padding.left;
            insets.bottom = this._padding.bottom;
            insets.right = this._padding.right;
        }
        return insets;
    }

    public void setForeground(Color color) {
        this._foreground = color;
    }

    public Color getForeground() {
        return this._foreground;
    }

    public void setShadow(Color color) {
        this._shadow = color;
    }

    public Color getShadow() {
        return this._shadow;
    }

    public void setBackground(Color color) {
        this._background = color;
    }

    public Color getBackground() {
        return this._background;
    }

    public void setTransparency(float f) {
        this._transparency = f;
    }

    public float getTransparency() {
        return this._transparency;
    }

    public float getMaxLineWidth() {
        int n = this._size.width;
        n -= this._padding.left;
        return n -= this._padding.right;
    }

    public synchronized void addLine(Line line) {
        if (this._lines == null) {
            this._lines = new ArrayList();
        }
        this._lines.add(line);
        this._pageHeight += line.getAscent();
        this._pageHeight += line.getDescent();
        this._dirty = true;
    }

    public int getLineCount() {
        if (this._lines != null) {
            return this._lines.size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setLine(int n, Line line) {
        try {
            if (this._lines == null || n < 0 || n >= this._lines.size()) {
                Logger.debug("[canvas.text] invalid length! index:" + n + " size:" + (this._lines != null ? this._lines.size() : 0));
            }
            Page page = this;
            synchronized (page) {
                Line line2 = (Line)this._lines.get(n);
                this._pageHeight -= line2.getAscent() + line2.getDescent();
                this._lines.set(n, line);
                this._pageHeight += line.getAscent() + line.getDescent();
                this._dirty = true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Logger.error("[canvas] invalid line number.", (Throwable)indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLine(int n) {
        try {
            if (this._lines == null) {
                throw new IndexOutOfBoundsException("there is still no line.");
            }
            Page page = this;
            synchronized (page) {
                Line line = (Line)this._lines.remove(n);
                this._pageHeight -= line.getAscent() + line.getDescent();
                this._dirty = true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Logger.error("[canvas] invalid line number.", (Throwable)indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
    }

    public List getLines() {
        if (this._lines != null) {
            return (List)((ArrayList)this._lines).clone();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLines() {
        Page page = this;
        synchronized (page) {
            if (this._lines != null) {
                this._lines.clear();
                this._dirty = true;
                this._pageHeight = 0.0f;
            }
        }
    }

    public boolean isAdaptive(Line line) {
        if (line == null) {
            throw new NullPointerException("\u3066\u3081\u3047\u3001\u306a\u3081\u3066\u3093\u3058\u3083\u306d\u3047\u305e\u3050\u3089\u3041\uff01");
        }
        float f = this._pageHeight + (float)this._padding.top + (float)this._padding.bottom;
        return f + line.getAscent() + line.getDescent() < (float)this._size.height;
    }

    public void updateCanvas() {
        if (this._canvas != null) {
            this._canvas.updateCanvas();
        }
    }

    public void updateContents() {
        if (this._canvas != null) {
            this._canvas.updateText();
        }
    }

    public void commit() {
        Logger.debug("[canvas.text] commit.");
        if (this._lines != null) {
            if (this._committedLines != null) {
                this._committedLines.clear();
                this._committedLines.addAll(this._lines);
            } else {
                this._committedLines = (List)((ArrayList)this._lines).clone();
            }
            Logger.debug("[canvas.text] committed lines :" + this._committedLines.size());
        }
        this._commitedPageHeight = this._pageHeight;
    }

    public void rollback() {
        Logger.debug("[canvas.text] rollback.");
        if (this._lines != null) {
            this._lines.clear();
        }
        this._lines = this._committedLines;
        this._committedLines = null;
        this._pageHeight = this._commitedPageHeight;
    }

    public Object clone() {
        return this.clone(new Page());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone(Page page) {
        Page page2 = this;
        synchronized (page2) {
            if (this._lines != null) {
                page._lines = (List)((ArrayList)this._lines).clone();
            }
        }
        page._dirty = false;
        page._defaultFont = this._defaultFont;
        page._size = (Dimension)this._size.clone();
        page._location = (Point)this._location.clone();
        page._padding = (Insets)this._padding.clone();
        page._foreground = this._foreground;
        page._background = this._background;
        page._transparency = this._transparency;
        return page;
    }
}

