/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario;

import java.util.ArrayList;
import tsukuba_bunko.peko.ActionControler;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.scenario.MessageIDs;
import tsukuba_bunko.peko.scenario.SceneContext;
import tsukuba_bunko.peko.scenario.SceneProcessor;
import tsukuba_bunko.peko.scenario.select.SelectCoordinator;
import tsukuba_bunko.peko.scenario.stage.StageCoordinator;
import tsukuba_bunko.peko.scenario.text.TextCoordinator;
import tsukuba_bunko.peko.session.Session;

public class ScenarioProcessor {
    protected ArrayList _queue = new ArrayList(5);
    protected int _maxQueueSize = 4;
    protected int _processorCount = 0;
    protected SceneProcessor _currentSceneProcessor = null;
    protected Session _session = null;
    protected TextCoordinator _textCooridnator = null;
    protected StageCoordinator _stageCoordinator = null;
    protected SelectCoordinator _selectCoordinator = null;

    public ScenarioProcessor() {
        this._queue.add(new SceneProcessor(this));
        this._queue.add(new SceneProcessor(this));
        this._textCooridnator = new TextCoordinator();
        this._stageCoordinator = new StageCoordinator();
        this._selectCoordinator = new SelectCoordinator();
    }

    public synchronized void playScenario(String string, Session session) {
        if (this._currentSceneProcessor != null) {
            Logger.error("[scene] BUG! current scene processor is still alive!");
            this.exit();
        }
        SceneProcessor sceneProcessor = this.getSceneProcessor();
        sceneProcessor.setTextCoordinator(this._textCooridnator);
        sceneProcessor.setStageCoordinator(this._stageCoordinator);
        sceneProcessor.setSelectCoordinator(this._selectCoordinator);
        this._currentSceneProcessor = sceneProcessor;
        this._session = session;
        ActionControler actionControler = PekoSystem.getInstance().getActionControler();
        actionControler.setActive(true);
        sceneProcessor.process(string, session);
    }

    public synchronized void exit() {
        if (this._currentSceneProcessor != null) {
            Logger.debug("[scenario] exit ScenarioProcessor");
            this._currentSceneProcessor.abort();
            this._currentSceneProcessor = null;
            this._session = null;
            ActionControler actionControler = PekoSystem.getInstance().getActionControler();
            actionControler.start();
        }
    }

    protected synchronized SceneProcessor getSceneProcessor() {
        try {
            if (this._queue.isEmpty()) {
                if (this._processorCount < this._maxQueueSize) {
                    SceneProcessor sceneProcessor = new SceneProcessor(this);
                    ++this._processorCount;
                    return sceneProcessor;
                }
                while (this._queue.isEmpty()) {
                    this.wait(50L);
                }
            }
            return (SceneProcessor)this._queue.remove(0);
        }
        catch (InterruptedException interruptedException) {
            Logger.debug("[scene] interrupted", interruptedException);
            return null;
        }
    }

    protected synchronized void pushSceneProcessor(SceneProcessor sceneProcessor) {
        this._queue.add(sceneProcessor);
    }

    protected synchronized void sceneEnded(SceneProcessor sceneProcessor) {
        if (this._currentSceneProcessor == sceneProcessor) {
            SceneContext sceneContext = sceneProcessor.getSceneContext();
            String string = sceneContext.getNextSceneName();
            if (string != null) {
                if ("peko:end".equals(string)) {
                    this.exit();
                    ActionControler actionControler = PekoSystem.getInstance().getActionControler();
                    actionControler.returnTitle(true);
                } else {
                    this._currentSceneProcessor.abort();
                    this._session.setSceneContext(null);
                    PekoSystem.getInstance().getCanvasManager().advancesNewPage();
                    PekoSystem.getInstance().getCanvasManager().getCurrentPage().commit();
                    this._currentSceneProcessor = this.getSceneProcessor();
                    this._currentSceneProcessor.setTextCoordinator(this._textCooridnator);
                    this._currentSceneProcessor.setStageCoordinator(this._stageCoordinator);
                    this._currentSceneProcessor.setSelectCoordinator(this._selectCoordinator);
                    this._currentSceneProcessor.process(sceneContext.getNextSceneName(), this._session);
                }
            } else {
                Logger.error(MessageIDs.SCN0012E);
                this.exit();
                ActionControler actionControler = PekoSystem.getInstance().getActionControler();
                actionControler.returnTitle(true);
            }
        }
    }
}

