/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario.text;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.text.Page;
import tsukuba_bunko.peko.resource.ColorManager;
import tsukuba_bunko.peko.resource.DimensionDeserializer;
import tsukuba_bunko.peko.resource.FontManager;
import tsukuba_bunko.peko.resource.InsetsDeserializer;
import tsukuba_bunko.peko.resource.PointDeserializer;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.scenario.SceneContext;
import tsukuba_bunko.peko.scenario.text.MessageIDs;

public class PageConfigurator {
    protected PageConfigurator() {
    }

    public static void configure(Page page, SceneContext sceneContext) {
        Color color;
        Cloneable cloneable;
        Object object;
        ResourceManager resourceManager = ResourceManager.getInstance();
        FontManager fontManager = FontManager.getInstance();
        ColorManager colorManager = ColorManager.getInstance();
        boolean bl = false;
        String string = sceneContext.getProperty("canvas.text.background.transparency");
        if (string != null) {
            try {
                page.setTransparency(Float.parseFloat(string));
                bl = true;
            }
            catch (Exception exception) {
                Logger.warn(MessageIDs.SCN2006W);
            }
        }
        if (!bl) {
            object = (Float)resourceManager.getResource("peko.canvas.text.background.transparency");
            if (object == null) {
                Logger.warn(MessageIDs.SCN2005W, new Object[]{"0.5"});
                page.setTransparency(0.5f);
            } else {
                page.setTransparency(((Float)object).floatValue());
            }
        }
        bl = false;
        string = sceneContext.getProperty("canvas.text.background.color");
        if (string == null) {
            object = (Color)resourceManager.getResource("peko.canvas.text.background.color");
            if (object == null) {
                Logger.warn(MessageIDs.SCN2003W, new Object[]{"black"});
                object = Color.black;
            }
            page.setBackground((Color)object);
        } else {
            page.setBackground(colorManager.getColor(string));
        }
        object = sceneContext.getProperty("canvas.text.view-type");
        if (object != null && !"window".equals(object) && !"full".equals(object)) {
            Logger.warn(MessageIDs.SCN2014W);
            object = null;
        }
        if (object == null && ((object = (String)resourceManager.getResource("peko.canvas.text.view-type")) == null || !"window".equals(object) && !"full".equals(object))) {
            Logger.warn(MessageIDs.SCN2013W, new Object[]{"full"});
            object = "full";
        }
        Dimension dimension = null;
        if (((String)object).equals("window")) {
            string = sceneContext.getProperty("canvas.text.size");
            if (string != null) {
                try {
                    dimension = DimensionDeserializer.parseDimension(string);
                }
                catch (Exception exception) {
                    Logger.warn(MessageIDs.SCN2016W);
                }
            }
            if (dimension == null && (dimension = (Dimension)resourceManager.getResource("peko.canvas.text.size")) == null) {
                Logger.warn(MessageIDs.SCN2015W, new Object[]{"600, 180"});
                dimension = new Dimension(600, 180);
            }
            cloneable = null;
            string = sceneContext.getProperty("canvas.text.location");
            if (string != null) {
                try {
                    cloneable = PointDeserializer.parsePoint(string);
                }
                catch (Exception exception) {
                    Logger.warn(MessageIDs.SCN2018W, (Throwable)exception);
                }
            }
            if (cloneable == null && (cloneable = (Point)resourceManager.getResource("peko.canvas.text.location")) == null) {
                Logger.warn(MessageIDs.SCN2017W, new Object[]{"0, 0"});
                cloneable = new Point(0, 0);
            }
            page.setLocation(cloneable.x, cloneable.y);
        } else {
            page.setLocation(0, 0);
            dimension = page.getTextCanvas().getSize();
        }
        page.setSize(dimension);
        cloneable = null;
        string = sceneContext.getProperty("canvas.text.padding");
        if (string != null) {
            try {
                cloneable = InsetsDeserializer.parseInsets(string);
            }
            catch (Exception exception) {
                Logger.warn(MessageIDs.SCN2020W);
            }
        }
        if (cloneable == null && (cloneable = (Insets)resourceManager.getResource("peko.canvas.text.padding")) == null) {
            Logger.warn(MessageIDs.SCN2019W, new Object[]{"10,40,10,10"});
            cloneable = new Insets(10, 40, 10, 10);
        }
        page.setPadding(((Insets)cloneable).top, ((Insets)cloneable).left, ((Insets)cloneable).bottom, ((Insets)cloneable).right);
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>(17);
        Font font = (Font)resourceManager.getResource("peko.canvas.text.font");
        if (font == null) {
            Logger.warn(MessageIDs.SCN2011W, new Object[]{"Serif, 20"});
            hashMap = new HashMap(17);
            hashMap.put(TextAttribute.FAMILY, "Serif");
            hashMap.put(TextAttribute.SIZE, new Float(20.0f));
            hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        } else {
            hashMap.putAll(font.getAttributes());
        }
        string = sceneContext.getProperty("canvas.text.font.family");
        if (string != null) {
            hashMap.put(TextAttribute.FAMILY, string);
        }
        if ((string = sceneContext.getProperty("canvas.text.font.size")) != null) {
            try {
                hashMap.put(TextAttribute.SIZE, Float.valueOf(string));
            }
            catch (Exception exception) {
                Logger.warn(MessageIDs.SCN2012W, new Object[]{"size"});
            }
        }
        if ((string = sceneContext.getProperty("canvas.text.font.style")) != null) {
            if ("italic".equals(string)) {
                hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            } else if ("normal".equals(string)) {
                hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
            } else {
                Logger.warn(MessageIDs.SCN2012W, new Object[]{"style"});
            }
        }
        if ((string = sceneContext.getProperty("canvas.text.font.weight")) != null) {
            if ("bold".equals(string)) {
                hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            } else if ("normal".equals(string)) {
                hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
            }
        }
        page.setDefaultFont(fontManager.getFont(hashMap));
        string = sceneContext.getProperty("canvas.text.foreground.color");
        if (string == null) {
            color = (Color)resourceManager.getResource("peko.canvas.text.foreground.color");
            if (color == null) {
                Logger.warn(MessageIDs.SCN2007W, new Object[]{"white"});
                color = Color.white;
            }
            page.setForeground(color);
        } else {
            page.setForeground(colorManager.getColor(string));
        }
        string = sceneContext.getProperty("canvas.text.foreground.shadow");
        if (string == null) {
            color = (Color)resourceManager.getResource("peko.canvas.text.foreground.shadow");
            if (color == null) {
                Logger.warn(MessageIDs.SCN2007W, new Object[]{"black"});
                color = Color.black;
            }
            page.setShadow(color);
        } else {
            page.setShadow(colorManager.getColor(string));
        }
        page.updateCanvas();
    }
}

