/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.session;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.resource.ColorManager;
import tsukuba_bunko.peko.resource.FontManager;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.session.MessageIDs;
import tsukuba_bunko.peko.session.SaveDataInfo;

public class SaveDataInfoRenderer
extends JComponent
implements ListCellRenderer {
    private SaveDataInfo _info = null;
    private boolean _selected = false;
    private int _index = -1;
    private Dimension _cellSize = null;
    private Color _selectedBackground = null;
    private Color _unselectedBackground = null;
    private Font _titleFont = null;
    private Color _titleColor = null;
    private Font _timestampFont = null;
    private Color _timestampColor = null;
    private Font _commentFont = null;
    private Color _commentColor;
    private MessageFormat _titleFormat = null;
    private SimpleDateFormat _timestampFormat = null;
    private String _nodataTitle = null;

    public SaveDataInfoRenderer() {
        Object object;
        ResourceManager resourceManager = ResourceManager.getInstance();
        ColorManager colorManager = ColorManager.getInstance();
        FontManager fontManager = FontManager.getInstance();
        Dimension dimension = (Dimension)resourceManager.getResource("peko.savedata-chooser.cell.size");
        if (dimension == null) {
            Logger.warn(MessageIDs.SAV0009W, new Object[]{"380,65"});
            dimension = new Dimension(380, 65);
        }
        this.setPreferredSize(dimension);
        this.setSize(dimension);
        this._cellSize = dimension;
        this._selectedBackground = (Color)resourceManager.getResource("peko.savedata-chooser.cell.background.selected");
        if (this._selectedBackground == null) {
            this._selectedBackground = colorManager.getColor("#FF88FF");
            Logger.warn(MessageIDs.SAV0024W, new Object[]{"cell.background.selected", "#FF88FF"});
        }
        this._unselectedBackground = (Color)resourceManager.getResource("peko.savedata-chooser.cell.background.unselected");
        if (this._unselectedBackground == null) {
            this._unselectedBackground = colorManager.getColor("white");
            Logger.warn(MessageIDs.SAV0024W, new Object[]{"cell.background.unselected", "white"});
        }
        this._titleColor = (Color)resourceManager.getResource("peko.savedata-chooser.cell.title.color");
        if (this._titleColor == null) {
            this._titleColor = colorManager.getColor("black");
            Logger.warn(MessageIDs.SAV0023W, new Object[]{"cell.title", "black"});
        }
        this._timestampColor = (Color)resourceManager.getResource("peko.savedata-chooser.cell.timestamp.color");
        if (this._timestampColor == null) {
            this._timestampColor = colorManager.getColor("black");
            Logger.warn(MessageIDs.SAV0023W, new Object[]{"cell.timestamp", "black"});
        }
        this._commentColor = (Color)resourceManager.getResource("peko.savedata-chooser.cell.comment.color");
        if (this._commentColor == null) {
            this._commentColor = colorManager.getColor("black");
            Logger.warn(MessageIDs.SAV0023W, new Object[]{"cell.comment", "black"});
        }
        this._titleFont = (Font)resourceManager.getResource("peko.savedata-chooser.cell.title.font");
        if (this._titleFont == null) {
            Logger.warn(MessageIDs.SAV0010W, new Object[]{"cell.title", "family:SansSerif; size:16.0; style:normal; weight:bold"});
            object = new HashMap<TextAttribute, Object>();
            object.put(TextAttribute.FAMILY, "SansSerif");
            object.put(TextAttribute.SIZE, new Float(16.0f));
            object.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
            object.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            this._titleFont = fontManager.getFont((Map)object);
        }
        this._timestampFont = (Font)resourceManager.getResource("peko.savedata-chooser.cell.timestamp.font");
        if (this._timestampFont == null) {
            Logger.warn(MessageIDs.SAV0010W, new Object[]{"cell.timestamp", "family:SansSerif; size:11.0; style:normal; weight:normarl"});
            object = new HashMap();
            object.put(TextAttribute.FAMILY, "SansSerif");
            object.put(TextAttribute.SIZE, new Float(11.0f));
            object.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
            object.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            this._timestampFont = fontManager.getFont((Map)object);
        }
        this._commentFont = (Font)resourceManager.getResource("peko.savedata-chooser.cell.comment.font");
        if (this._timestampFont == null) {
            Logger.warn(MessageIDs.SAV0010W, new Object[]{"cell.comment", "family:SansSerif; size:16.0; style:normal; weight:normarl"});
            object = new HashMap<TextAttribute, Object>();
            object.put(TextAttribute.FAMILY, "SansSerif");
            object.put(TextAttribute.SIZE, new Float(11.0f));
            object.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
            object.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            this._commentFont = fontManager.getFont((Map)object);
        }
        this._titleFormat = (MessageFormat)resourceManager.getResource("peko.savedata-chooser.cell.title-format");
        if (this._titleFormat == null) {
            this._titleFormat = new MessageFormat("No.{0}  {1}");
            Logger.warn(MessageIDs.SAV0011W, new Object[]{"\"No.{0}  {1}\""});
        }
        if ((object = (String)resourceManager.getResource("peko.savedata-chooser.cell.timestamp-format")) == null) {
            object = "yyyy/MM/dd hh:mm";
            Logger.warn(MessageIDs.SAV0017W, new Object[]{"\"" + (String)object + "\""});
        }
        this._timestampFormat = new SimpleDateFormat((String)object);
        this._nodataTitle = (String)resourceManager.getResource("peko.savedata-chooser.cell.no-data-title");
        if (this._nodataTitle == null) {
            this._nodataTitle = "-NO DATA-";
            Logger.warn(MessageIDs.SAV0018W, new Object[]{"\"" + this._nodataTitle + "\""});
        }
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this._selected) {
            graphics.setColor(this._selectedBackground);
        } else {
            graphics.setColor(this._unselectedBackground);
        }
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(Color.black);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        float f = 3.0f;
        AttributedString attributedString = null;
        TextLayout textLayout = null;
        if (this._info == null) {
            attributedString = new AttributedString(this._titleFormat.format(new Object[]{String.valueOf(this._index + 1), this._nodataTitle}));
            attributedString.addAttribute(TextAttribute.FONT, this._titleFont);
            attributedString.addAttribute(TextAttribute.FOREGROUND, this._titleColor);
            textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
            textLayout.draw(graphics2D, 5.0f, textLayout.getAscent() + f);
            f += textLayout.getAscent() + textLayout.getDescent() + 5.0f;
        } else {
            attributedString = new AttributedString(this._titleFormat.format(new Object[]{String.valueOf(this._index + 1), this._info.getTitle()}));
            attributedString.addAttribute(TextAttribute.FONT, this._titleFont);
            attributedString.addAttribute(TextAttribute.FOREGROUND, this._titleColor);
            textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
            textLayout.draw(graphics2D, 5.0f, textLayout.getAscent() + f);
            f += textLayout.getAscent() + textLayout.getDescent() + 5.0f;
            attributedString = new AttributedString(this._timestampFormat.format(this._info.getTimestamp()));
            attributedString.addAttribute(TextAttribute.FONT, this._timestampFont);
            attributedString.addAttribute(TextAttribute.FOREGROUND, this._timestampColor);
            textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
            textLayout.draw(graphics2D, 5.0f, textLayout.getAscent() + f);
            f += textLayout.getAscent() + textLayout.getDescent() + 5.0f;
            if (this._info.getComment() != null) {
                attributedString = new AttributedString(this._info.getComment());
                attributedString.addAttribute(TextAttribute.FONT, this._commentFont);
                attributedString.addAttribute(TextAttribute.FOREGROUND, this._commentColor);
                textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
                textLayout.draw(graphics2D, 5.0f, textLayout.getAscent() + f);
            }
        }
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this._info = (SaveDataInfo)object;
        this._selected = bl;
        this._index = n;
        this.setBorder(BorderFactory.createEtchedBorder(1));
        return this;
    }
}

