/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.resource;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import tsukuba_bunko.resource.DeserializerMapping;
import tsukuba_bunko.resource.IllegalResourceException;
import tsukuba_bunko.resource.ResourceDeserializer;
import tsukuba_bunko.resource.Resources;

public class ResourceLoader
implements ContentHandler {
    private XMLReader _parser = null;
    private DeserializerMapping _mapping = DeserializerMapping.newInstance();
    private ResourceDeserializer _currentDeserializer = null;
    private int _level = 0;
    private List _stack = null;
    private StringBuffer _text = null;
    private Resources _resources = null;

    public ResourceLoader() throws ParserConfigurationException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        this._parser = sAXParserFactory.newSAXParser().getXMLReader();
        this._parser.setContentHandler(this);
    }

    public void setDeserializerMapping(DeserializerMapping deserializerMapping) {
        this._mapping = deserializerMapping;
    }

    public DeserializerMapping getDeserializerMapping() {
        return this._mapping;
    }

    public void loadResource(URL uRL, Resources resources) throws IOException, IllegalResourceException {
        try {
            this._resources = resources;
            this._parser.parse(uRL.toString());
            this._resources = null;
        }
        catch (SAXException sAXException) {
            throw new IllegalResourceException(sAXException);
        }
    }

    protected ResourceDeserializer getResourceDeserializer(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this._mapping == null) {
            return null;
        }
        String string4 = attributes.getValue("type");
        if (string4 != null) {
            ResourceDeserializer resourceDeserializer = this._mapping.getResourceDeserializer(string4);
            if (resourceDeserializer == null) {
                throw new SAXException("no deserializer for \"" + string4 + "\"");
            }
            return resourceDeserializer;
        }
        return null;
    }

    protected String getCurrentPath() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this._stack.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        if (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuffer.append(".");
            stringBuffer.append(iterator.next());
        }
        return new String(stringBuffer);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this._currentDeserializer != null) {
            this._currentDeserializer.startPrefixMapping(string, string2);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (this._currentDeserializer != null) {
            this._currentDeserializer.endPrefixMapping(string);
        }
    }

    public void startDocument() {
        this._stack = new ArrayList();
        if (this._mapping == null) {
            this._mapping = DeserializerMapping.newInstance();
        }
    }

    public void endDocument() {
        this._stack = null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this._currentDeserializer != null) {
            ++this._level;
            this._currentDeserializer.startElement(string, string2, string3, attributes);
        } else {
            this._stack.add(string3);
            ResourceDeserializer resourceDeserializer = this.getResourceDeserializer(string, string2, string3, attributes);
            if (resourceDeserializer != null) {
                this._currentDeserializer = resourceDeserializer;
                resourceDeserializer.setDeserializerMapping(this._mapping);
                ++this._level;
                resourceDeserializer.startDocument();
                resourceDeserializer.startElement(string, string2, string3, attributes);
            } else {
                this._text = new StringBuffer();
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this._currentDeserializer != null) {
            --this._level;
            this._currentDeserializer.endElement(string, string2, string3);
            if (this._level == 0) {
                this._currentDeserializer.endDocument();
                this._resources.setResource(this.getCurrentPath(), this._currentDeserializer.getValue());
                this._stack.remove(this._stack.size() - 1);
                this._currentDeserializer = null;
                this._currentDeserializer = null;
            }
        } else if (this._text != null) {
            this._resources.setResource(this.getCurrentPath(), new String(this._text));
            this._stack.remove(this._stack.size() - 1);
        } else {
            this._stack.remove(this._stack.size() - 1);
        }
        this._text = null;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this._currentDeserializer != null) {
            this._currentDeserializer.processingInstruction(string, string2);
        }
    }

    public void skippedEntity(String string) throws SAXException {
        if (this._currentDeserializer != null) {
            this._currentDeserializer.skippedEntity(string);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this._currentDeserializer != null) {
            this._currentDeserializer.characters(cArray, n, n2);
        } else if (this._text != null) {
            this._text.append(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this._currentDeserializer != null) {
            this._currentDeserializer.ignorableWhitespace(cArray, n, n2);
        }
    }
}

