/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: Logger.java,v 1.1.2.3 2003/12/17 09:28:50 ppoi Exp $
 */
package tsukuba_bunko.peko;

import	java.io.File;

import	java.util.Properties;

import	javax.swing.JOptionPane;

import	org.apache.log4j.BasicConfigurator;
import	org.apache.log4j.PropertyConfigurator;
import	org.apache.log4j.LogManager;
import	org.apache.log4j.Priority;

import	tsukuba_bunko.util.ResourceLocator;


/**
 * "Peko" ̊eW[ɑ΂MŐ@\񋟂܂B
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.3 $
 */
public class Logger	{

	/**
	 * O
	 */
	private static	org.apache.log4j.Logger	_logger = null;


	/**
	 * <code>Logger</code> ̃CX^X쐬܂B
	 */
	public Logger()
	{
		super();
	}


	/**
	 * OVXe܂B̃\bh́APekoSystem ɈxĂяo܂B
	 * ȊÕNXAԂł̃\bhĂяo͋֎~܂B
	 */
	public static void prepare()
	{
		LogManager.resetConfiguration();
		try	{
			Properties	props = new Properties();
			props.load( Logger.class.getResourceAsStream("log4j.properties") );

			ResourceLocator	locator = ResourceLocator.newInstance();
			File	base = locator.findLocation( "tsukuba_bunko/peko/PekoSystem.class" );
			if( base.isFile() )	{
				base = base.getParentFile();
			}

			props.setProperty( "log4j.appender.file.File", base.getAbsolutePath() + File.separator + "pvns.log" );
			String	debug = System.getProperty( "pvns.debug", "off" ).toLowerCase();
			if( "on".equals(debug) || "yes".equals(debug) || "true".equals(debug) )	{
				props.setProperty( "log4j.rootLogger", "DEBUG, file" );
			}
			else	{
				props.setProperty( "log4j.rootLogger", "INFO, file" );
			}

			PropertyConfigurator.configure( props );
		}
		catch( Exception e )	{
			BasicConfigurator.configure();
		}
		_logger = LogManager.getLogger( "peko" );
		_logger.info( "[logging] start logging." );
	}


	/**
	 */
	public static final void debug( String message )
	{
		_logger.debug( message );
	}

	/**
	 */
	public static final void debug( String message, Throwable e )
	{
		_logger.debug( message, e );
	}

	/**
	 */
	public static final void info( String message )
	{
		_logger.info( message );
	}

	public static final void info( String message, Throwable e )
	{
		_logger.info( message, e );
	}

	public static final void warn( String message )
	{
		if( _logger.isEnabledFor(Priority.WARN) )	{
			_logger.warn( message );
			JOptionPane.showMessageDialog( null, message, "WARNING", JOptionPane.WARNING_MESSAGE );
		}
	}

	public static final void warn( String message, Throwable e )
	{
		if( _logger.isEnabledFor(Priority.WARN) )	{
			_logger.warn( message, e );
			JOptionPane.showMessageDialog( null, message, "WARNING", JOptionPane.WARNING_MESSAGE );
		}
	}

	public static final void warn( MessageID messageID )
	{
		String	message = messageID.getMessage();
		if( _logger.isEnabledFor(Priority.WARN) )	{
			_logger.warn( message );
			JOptionPane.showMessageDialog( null, message, "WARNING", JOptionPane.WARNING_MESSAGE );
		}
	}

	public static final void warn( MessageID messageID, Object[] params )
	{
		String	message = messageID.getMessage( params );
		if( _logger.isEnabledFor(Priority.WARN) )	{
			_logger.warn( message );
			JOptionPane.showMessageDialog( null, message, "WARNING", JOptionPane.WARNING_MESSAGE );
		}
	}

	public static final void warn( MessageID messageID, Throwable e )
	{
		String	message = messageID.getMessage();
		if( _logger.isEnabledFor(Priority.WARN) )	{
			_logger.warn( message, e );
			JOptionPane.showMessageDialog( null, message, "WARNING", JOptionPane.WARNING_MESSAGE );
		}
	}

	public static final void warn( MessageID messageID, Object[] params, Throwable e )
	{
		String	message = messageID.getMessage( params );
		if( _logger.isEnabledFor(Priority.WARN) )	{
			_logger.warn( message, e );
			JOptionPane.showMessageDialog( null, message, "WARNING", JOptionPane.WARNING_MESSAGE );
		}
	}

	public static final void error( String message )
	{
		if( _logger.isEnabledFor(Priority.ERROR) )	{
			_logger.error( message );
			JOptionPane.showMessageDialog( null, message, "ERROR", JOptionPane.ERROR_MESSAGE );
		}
	}

	public static final void error( String message, Throwable e )
	{
		if( _logger.isEnabledFor(Priority.ERROR) )	{
			_logger.error( message, e );
			JOptionPane.showMessageDialog( null, message, "ERROR", JOptionPane.ERROR_MESSAGE );
		}
	}

	public static final void error( MessageID messageID )
	{
		String	message = messageID.getMessage();
		if( _logger.isEnabledFor(Priority.ERROR) )	{
			_logger.error( message );
			JOptionPane.showMessageDialog( null, message, "ERROR", JOptionPane.ERROR_MESSAGE );
		}
	}

	public static final void error( MessageID messageID, Object[] params )
	{
		String	message = messageID.getMessage( params );
		if( _logger.isEnabledFor(Priority.ERROR) )	{
			_logger.error( message );
			JOptionPane.showMessageDialog( null, message, "ERROR", JOptionPane.ERROR_MESSAGE );
		}
	}

	public static final void error( MessageID messageID, Throwable e )
	{
		String	message = messageID.getMessage();
		if( _logger.isEnabledFor(Priority.ERROR) )	{
			_logger.error( message, e );
			JOptionPane.showMessageDialog( null, message, "ERROR", JOptionPane.ERROR_MESSAGE );
		}
	}

	public static final void error( MessageID messageID, Object[] params, Throwable e )
	{
		String	message = messageID.getMessage( params );
		if( _logger.isEnabledFor(Priority.ERROR) )	{
			_logger.error( message, e );
			JOptionPane.showMessageDialog( null, message, "ERROR", JOptionPane.ERROR_MESSAGE );
		}
	}

	public static final void fatal( String message )
	{
		_logger.fatal( message );
	}

	public static final void fatal( String message, Throwable e )
	{
		_logger.fatal( message, e );
	}

	public static final void fatal( MessageID messageID )
	{
		_logger.fatal( messageID.getMessage() );
	}

	public static final void fatal( MessageID messageID, Object[] params )
	{
		_logger.fatal( messageID.getMessage(params) );
	}

	public static final void fatal( MessageID messageID, Throwable e )
	{
		_logger.fatal( messageID.getMessage(), e );
	}

	public static final void fatal( MessageID messageID, Object[] params, Throwable e )
	{
		_logger.fatal( messageID.getMessage(params), e );
	}
}