/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: StageCanvas.java,v 1.1.2.2 2003/12/14 20:19:20 ppoi Exp $
 */
package tsukuba_bunko.peko.canvas.stage;

import	java.awt.Dimension;
import	java.awt.Graphics;
import	java.awt.Graphics2D;
import	java.awt.Image;

import	java.awt.image.BufferedImage;

import	java.util.Iterator;
import	java.util.Map;

import	javax.swing.JComponent;

import	tsukuba_bunko.peko.Logger;

import	tsukuba_bunko.peko.resource.ResourceManager;


/**
 * iXe[Wj`悷LoXłB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.2 $
 */
public class StageCanvas	extends JComponent	{

	/**
	 * Xe[W
	 */
	private Stage	_stage = null;

	/**
	 * GtFNggp邩ǂ
	 */
	private boolean	_usingEffect = false;

	/**
	 * GtFNg}bv
	 */
	private Map	_effects = null;

	/**
	 * `pItXN[obt@
	 */
	private BufferedImage	_screen = null;

	/**
	 * ƗpItXN[obt@
	 */
	private BufferedImage	_working = null;

	/**
	 * size cache
	 */
	private Dimension	_size = new Dimension();


	/**
	 * <code>StageCanvas</code> ̃CX^X쐬܂B
	 */
	public StageCanvas()
	{
		super();
		initialize();
	}


	/**
	 * ̃LoXŕ`悷Xe[Wݒ肵܂B
	 * @param	stage	Xe[W
	 */
	public void setStage( Stage stage )
	{
		if( _stage != null )	{
			_stage.dispose();
		}

		_stage = stage;
		_stage.setStageCanvas( this );
	}

	/**
	 * ̃LoXݕ`悵ĂXe[W擾܂B
	 * @return	Xe[W
	 */
	public Stage getStage()
	{
		return _stage;
	}

	/**
	 * GtFNggp邩ǂݒ肵܂B
	 * @param	useEffect	GtFNggpꍇ <code>true</code>AȊȌꍇ <code>false</code>
	 */
	public void setUsingEffect( boolean useEffect )
	{
		_usingEffect = useEffect;
	}

	/**
	 * GtFNggp邩ǂ擾܂B
	 * @return	GtFNggpꍇ <code>true</code>AȊȌꍇ <code>false</code>
	 */
	public boolean isUsingEffect()
	{
		return _usingEffect;
	}

	/**
	 * Xe[WLoX܂B
	 */
	private void initialize()
	{
		ResourceManager	resources = ResourceManager.getInstance();
		Dimension	canvasSize = (Dimension)resources.getResource( "peko.canvas.canvas-size" );

		super.setPreferredSize( canvasSize );
		super.setSize( canvasSize );
		_screen = new BufferedImage( canvasSize.width, canvasSize.height, BufferedImage.TYPE_INT_RGB );
		_working = new BufferedImage( canvasSize.width, canvasSize.height, BufferedImage.TYPE_INT_RGB );

		super.setLayout( null );

		_effects = new java.util.HashMap( 89 );

		Effect	effect = new tsukuba_bunko.peko.canvas.stage.effect.MofingEffect();
		_effects.put( effect.getName(), effect );

		effect = new tsukuba_bunko.peko.canvas.stage.effect.PataPataEffect();
		_effects.put( effect.getName(), effect );

		effect = (Effect)_effects.get( "immediate" );
		if( effect == null )	{
			effect = new tsukuba_bunko.peko.canvas.stage.effect.ImmediateEffect();
			_effects.put( "immediate", effect );
		}
		_effects.put( null, effect );
	}


	/**
	 * LoX̕`eXV܂B
	 */
	public void updateCanvas()
	{
		updateCanvas( null );
	}

	/**
	 * w肳ꂽGtFNgpāALoX̕`eXV܂B
	 * @param	effectName	XVɎgpGtFNg
	 */
	public void updateCanvas( String effectName )
	{
		if( !isEnabled() )	{
			return;
		}

		Graphics2D	g2 = _working.createGraphics();
		Dimension	size = getSize( _size );

		if( _stage.getSlide() == null )	{
			Image	image = _stage.getBackgroundImage();
			if( image != null )	{
				g2.drawImage( image, 0, 0, this );
			}
			else	{
				g2.setColor( _stage.getBackgroundColor() );
				g2.fillRect( 0, 0, size.width, size.height );
			}

			Map	actors = _stage.getActors();
			if( actors != null )	{
				Iterator	itr = actors.values().iterator();
				Actor	actor = null;
				Image	looks = null;
				int	x = 0;
				int	y = 0;
				while( itr.hasNext() )	{
					actor = (Actor)itr.next();
					looks = actor.getLooksImage();
					if( looks != null )	{
						x = computePosition( actor );
						y = size.height - looks.getHeight( this );
						g2.drawImage( looks, x, y, this );
					}
				}
			}
		}
		else	{
			Image	image = _stage.getSlideImage();
			if( image != null )	{
				g2.drawImage( image, 0, 0, this );
			}
			else	{
				g2.fillRect( 0, 0, size.width, size.height );
			}
		}

		if( _usingEffect )	{
			Effect	effect = (Effect)_effects.get( effectName );
			if( effect != null )	{
				effect.process( this, _screen, _working );
			}
			else	{
				Logger.error( "[canvas.stage] unsuported effect name. :" + effect );
				_screen.setData( _working.getRaster() );
				repaint();
			}
			synchronized( this )	{
				try	{
					wait( 100 );
				}
				catch( InterruptedException ie )	{
					Logger.debug( "[canvas.stage] interrupted after effect.", ie );
				}
			}
		}
		else	{
			_screen.setData( _working.getRaster() );
			repaint();
		}
	}

	public void paintPageBackground( boolean visiblePage )
	{
		Graphics2D	g2 = _screen.createGraphics();
		g2.drawImage( _working, 0, 0, this );
		if( visiblePage )	{
			tsukuba_bunko.peko.PekoSystem.getInstance().getCanvasManager().getTextCanvas().paintPageBackground( g2 );
		}
		g2.dispose();
		repaint();
	}


	/**
	 * ʒuvZ܂B
	 * @param	position	ʒu̕\
	 */
	private int computePosition( Actor actor )
	{
		int	halfWidth = actor.getLooksImage().getWidth( this ) / 2;
		Dimension	size = getSize( _size );
		switch( actor.getPosition() )	{
		case Actor.POSITION_CENTER:
			return ((int)((float)size.width / 2f)) - halfWidth;
		case Actor.POSITION_LEFT:
			return ((int)((float)size.width / 4f)) - halfWidth;
		case Actor.POSITION_RIGHT:
			return ((int)((size.width / 4f) * 3f)) - halfWidth;
		default:
			return (int)actor.getAbsolutePosition() - halfWidth;
		}
	}

//
//	JComponent ̎
//
	protected void paintComponent( Graphics g )
	{
		g.drawImage( _screen, 0, 0, this );
	}
}
