/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: Marker.java,v 1.1.2.1 2003/12/11 10:22:54 ppoi Exp $
 */
package tsukuba_bunko.peko.canvas.text;

import	java.awt.Dimension;
import	java.awt.Graphics;
import	java.awt.Graphics2D;

import	java.awt.font.TextLayout;

import	javax.swing.JComponent;

import	tsukuba_bunko.peko.Logger;


/**
 * eLXg̖ɕ\҂}[J[łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class Marker	extends JComponent	implements Runnable	{

	/**
	 * }[J[
	 */
	private Line	_text = null;

	/**
	 * _ŃtO
	 */
	private boolean	_light = false;

	/**
	 * _ŃXbh
	 */
	private Thread	_blinker = null;

	/**
	 * _ŏ
	 */
	private boolean	_blinking = false;


	/**
	 * <code>Marker</code> ̃CX^X쐬܂B
	 */
	public Marker()
	{
		super();
	}


	/**
	 * }[J[ݒ肵܂B
	 * @param	text	}[J[
	 */
	public void setText( Line text )
	{
		_text = text;
		int	height = (int)(text.getAscent() + text.getDescent());
		int	width = (int)text.getTextLayout().getAdvance();
		Dimension	size = new Dimension( width, height );
		setPreferredSize( size );
		setSize( size );
	}

	/**
	 * }[J[ݒ肵܂B
	 * @param	text	}[J[
	 * @param	page	y[W
	 */
	public void setText( String text, Page page )
	{
		setForeground( page.getForeground() );
		TextLayout	layout = new TextLayout( text, page.getDefaultFont(), page.getFontRenderContext() );
		Line	line = new Line();
		line.setLineSpan( 0f );
		line.setTextLayout( layout );
		line.setForeground( page.getForeground() );
		line.setShadowColor( page.getShadow() );
		setText( line );
	}

	/**
	 * }[J[擾܂B
	 * @return	}[J[
	 */
	public Line getText()
	{
		return _text;
	}

	/**
	 * _łJn܂B
	 */
	public void start()
	{
		if( _blinker == null )	{
			synchronized( this )	{
				if( _blinker == null )	{
					_blinker = new Thread( this );
					_blinking = true;
					_blinker.start();
				}
			}
		}
	}

	/**
	 * _łI܂B
	 */
	public void stop()
	{
		synchronized( this )	{
			_blinking = false;
			notify();
		}
	}

	/**
	 * }[J[̍̈ʒuݒ肵܂B
	 * @param	x	X Wl
	 * @param	y	Y Wl
	 */
	public void setPosition( int x, int y )
	{
		if( _text != null )	{
			setLocation( x, (y - (int)(_text.getAscent() + _text.getDescent())) );
		}
		else	{
			setLocation( x, y );
		}
	}


//
//	Runnable ̎
//
	public void run()
	{
		Logger.debug( "[canvas.text] blinking start." );
		while( _blinking )	{
			synchronized( this )	{
				try	{
					wait( 520 );
				}
				catch( InterruptedException ie )	{
				}
			}
			_light = !_light;
			if( isVisible() )	{
				repaint();
			}
		}
		Logger.debug( "[canvas.text] blinking stop." );
	}


//
//	JComponent ̎
//
	protected void paintComponent( Graphics g )
	{
		if( !_light || (_text == null) || !isVisible() )	{
			return;
		}

		_text.draw( (Graphics2D)g, 0, _text.getAscent() );
	}
}
