/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: SelectHandler.java,v 1.1.2.1 2003/12/11 10:15:10 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario.select;

import	java.util.Map;

import	org.xml.sax.Attributes;
import	org.xml.sax.SAXException;

import	tsukuba_bunko.peko.Logger;

import	tsukuba_bunko.peko.scenario.ElementHandler;
import	tsukuba_bunko.peko.scenario.FlagScope;
import	tsukuba_bunko.peko.scenario.PSMLUtil;


/**
 * <samp>select</samp> vf <code>ElementHandler</code> łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class SelectHandler	extends ElementHandler	{

	/**
	 * id - lXg
	 */
	private Map	_attributes = new java.util.HashMap( 89 );

	/**
	 * ݃p[X̑I ID
	 */
	private String	_id = null;

	/**
	 * eLXgobt@
	 */
	private StringBuffer	_text = null;

	/**
	 * I
	 */
	private String	_name = null;

	/**
	 * XR[v
	 */
	private FlagScope	_scope = null;


	/**
	 * <code>SelectHandler</code> ̃CX^X쐬܂B
	 */
	public SelectHandler()
	{
		super();
	}


	/**
	 * SelectCanvas R[fBl[^擾܂B
	 * @return	SelectCanvas R[fBl[^
	 */
	protected SelectCoordinator getSelectCoordinator()
	{
		return getSceneContext().getSceneProcessor().getSelectCoordinator();
	}


//
//	ContentHandler ̎
//
	public void startDocument()
	{
		_attributes.clear();
		setEndOfScene( false );
	}

	public void endDocument()
	{
		SelectCoordinator	coordinator = getSelectCoordinator();
		
		String	id = coordinator.select();
		if( id == null )	{
			//	LZꂽ
			return;
		}
		else	{
			getSceneContext().declareFlag( _name + ":" + id, _scope );
		}

		coordinator.end();
	}

	public void startElement( String namespaceURI, String localName, String qName, Attributes attrs )
		throws SAXException
	{
		if( localName.equals("item") )	{
			if( _id != null )	{
				Logger.error( "[scenario.select] BUG! Invalid PSML Structure. location: " + getSceneContext().getCurrentPath() );
				throw new SAXException( "Invalid PSML Structure." );
			}

			String	id = PSMLUtil.getAttributeValue( attrs, "id" );
			if( (id == null) || (id.length() == 0) )	{
				Logger.warn( MessageIDs.SCN4002W, new Object[]{getSceneContext().getCurrentPath()} );
				_id = null;
			}
			else	{
				_id = id;
				_text = new StringBuffer();
			}
		}
		else if( "select".equals(localName) )	{
			String	name = PSMLUtil.getAttributeValue( attrs, "name" );
			if( (name == null) || (name.length() == 0) )	{
				Logger.error( MessageIDs.SCN4001E, new Object[]{getSceneContext().getCurrentPath()} );
				throw new SAXException( "invalid select element appeared." );
			}
			_name = PSMLUtil.getAttributeValue( attrs, "name" );

			String	flagScope = PSMLUtil.getAttributeValue( attrs, "scope" );
			if( (flagScope == null) || flagScope.equals("session") )	{
				_scope = FlagScope.SESSION;
			}
			else if( flagScope.equals("scene") )	{
				_scope = FlagScope.SCENE;
			}
			else if( flagScope.equals("system") )	{
				_scope = FlagScope.SYSTEM;
			}
			else	{
				//TODO: O
				_scope = FlagScope.SESSION;
			}

			getSelectCoordinator().begin();
		}
	}

	public void endElement( String namespaceURI, String localName, String qName )
	{
		if( (_id != null) && localName.equals("item") )	{
			if( _text.length() == 0 )	{
				Logger.warn( MessageIDs.SCN4003W, new Object[]{getSceneContext().getCurrentPath()} );
			}
			else	{
				SelectCoordinator	coordinator = getSceneContext().getSceneProcessor().getSelectCoordinator();
				coordinator.addSelectItem( _id, new String(_text) );
			}
			_id = null;
			_text = null;
		}
	}

	public void characters( char[] ch, int begin, int length )
	{
		if( _text != null )	{
			_text.append( ch, begin, length );
		}
	}
}