/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: BackgroundHandler.java,v 1.1.2.1 2003/12/11 10:15:10 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario.stage;

import	org.xml.sax.Attributes;

import	tsukuba_bunko.peko.resource.ResourceManager;

import	tsukuba_bunko.peko.scenario.PSMLUtil;


/**
 * <samp>background</samp>  <code>ElementHandler</code> łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class BackgroundHandler	extends StageElementHandler	{

	/**
	 * <code>BackgroundHandler</code> ̃CX^X쐬܂B
	 */
	public BackgroundHandler()
	{
		super();
	}


//
//	ContentHandler ̎
//
	public void startElement( String namespaceURI, String localName, String qName, Attributes attrs )
	{
		StageCoordinator	coodinator = getStageCoordinator();
		String	background = PSMLUtil.getAttributeValue( attrs, "image" );
		if( background != null )	{
			coodinator.setBackgroundImage( background );
		}
		else	{
			background = PSMLUtil.getAttributeValue( attrs, "color" );
			coodinator.setBackgroundColor( background );
		}

		String	effect = PSMLUtil.getAttributeValue( attrs, "effect" );
		if( effect == null )	{
			ResourceManager	resources = ResourceManager.getInstance();
			effect = (String)resources.getResource( ResourceIDs.DEFAULT_EFFECT_BACKGROUND, true );
		}
		coodinator.updateStage( effect );
	}
}
