/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: Session.java,v 1.1.2.1 2003/12/11 10:12:19 ppoi Exp $
 */
package tsukuba_bunko.peko.session;

import	java.io.Serializable;

import	java.util.Date;
import	java.util.HashMap;
import	java.util.HashSet;

import	tsukuba_bunko.peko.Logger;

import	tsukuba_bunko.peko.scenario.SceneContext;


/**
 * ݂̃ZbV̏i[܂B
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class Session	implements Serializable	{

	/**
	 * ZbVtO
	 */
	protected HashSet	_sessionFlags = null;

	/**
	 * VXetO
	 */
	protected HashSet	_systemFlags = null;

	/**
	 * VXetÕ[h^CX^v
	 */
	protected Date	_timestamp = null;


	/**
	 * ݐis̃V[̃ReNXg
	 */
	protected SceneContext	_sceneContext = null;

	/**
	 * ̑̑
	 */
	protected HashMap	_attributes = new HashMap( 17 );


	/**
	 * ݃V[ĂXbh
	 */
	protected transient Thread	_activeThread = null;


	/**
	 * <code>Session</code> ̃CX^X𐶐܂B
	 */
	public Session()
	{
		super();
	}


	/**
	 * ݐis̃V[̃ReNXgݒ肵܂B
	 * @param	context	V[ReNXg
	 * @param	processThread	V[Xbh
	 */
	public synchronized void setSceneContext( SceneContext context, Thread processThread )
	{
		_sceneContext = context;
		_activeThread = processThread;
	}

	/**
	 * ݂̃XbhŐis̃V[̃ReNXgݒ肵܂B
	 * @param	context	V[ReNXg
	 */
	public void setSceneContext( SceneContext context )
	{
		setSceneContext( context, Thread.currentThread() );
	}

	/**
	 * ZbVŌݐis̃V[̃ReNXg擾܂B
	 * @return	V[
	 */
	public SceneContext getSceneContext()
	{
		return _sceneContext;
	}


	/**
	 * ZbVtO𗧂Ă܂B
	 * @param	flagID	ĂtÕtO ID
	 */
	public void declareSessionFlag( String flagID )
	{
		Logger.debug( "[session] declare session flag: " + flagID );
		if( isActiveThread() )	{
			_sessionFlags.add( flagID );
		}
		else	{
			Logger.debug( "[session] canceled declaring session flag: " + flagID );
		}
	}

	/**
	 * ZbVtO~낵܂B
	 * @param	flagID	~낷tÕtO ID
	 */
	public void undeclareSessionFlag( String flagID )
	{
		Logger.debug( "[session] undeclare session flag: " + flagID );
		if( isActiveThread() )	{
			_sessionFlags.remove( flagID );
		}
		else	{
			Logger.debug( "[session] canceled undeclaring session flag: " + flagID );
		}
	}

	/**
	 * w肳ꂽtOZbVtOƂėĂĂ邩ǂ𔻒肵܂B
	 * @param	flagID	肷tO ID
	 * @return	tOĂꍇ <code>true</code>AȊO <code>false</code>
	 */
	public boolean isDeclaredSessionFlag( String flagID )
	{
		return _sessionFlags.contains( flagID );
	}

	/**
	 * VXetO𗧂Ă܂B
	 * @param	flagID	ĂtÕtO ID
	 */
	public void declareSystemFlag( String flagID )
	{
		Logger.debug( "[session] declare system flag: " + flagID );
		if( isActiveThread() )	{
			_systemFlags.add( flagID );
		}
		else	{
			Logger.debug( "[session] canceled declaring system flag: " + flagID );
		}
	}

	/**
	 * VXetO~낵܂B
	 * @param	flagID	~낷tÕtO ID
	 */
	public void undeclareSystemFlag( String flagID )
	{
		Logger.debug( "[session] undeclare system flag: " + flagID );
		if( isActiveThread() )	{
			_systemFlags.remove( flagID );
		}
		else	{
			Logger.debug( "[session] canceled undeclaring system flag: " + flagID );
		}
	}

	/**
	 * w肳ꂽtOVXetOƂėĂĂ邩ǂ𔻒肵܂B
	 * @param	flagID	肷tO ID
	 * @return	tOĂꍇ <code>true</code>AȊO <code>false</code>
	 */
	public boolean isDeclaredSystemFlag( String flagID )
	{
		return _systemFlags.contains( flagID );
	}


	/**
	 * ZbVtOWݒ肵܂B
	 * @param	flagSet	tOW
	 */
	public void setSessionFlagSet( HashSet flagSet )
	{
		_sessionFlags = flagSet;
	}

	/**
	 * ZbVtOW擾܂B
	 * @return	tOW
	 */
	public HashSet getSessionFlagSet()
	{
		return _sessionFlags;
	}

	/**
	 * VXetOWݒ肵擾܂B
	 * @return	VXetOWݒ肵
	 */
	public Date getTimestamp()
	{
		return _timestamp;
	}

	/**
	 * VXetOWݒ肵܂B<code>timestamp</code> Ã݂ReNXgɐݒ肳Ă鎞Âꍇ͐ݒ͔f܂B
	 * @param	flagSet	tOW
	 * @param	timestamp	tOW̃^CX^v
	 */
	public void setSystemFlagSet( HashSet flagSet, Date timestamp )
	{
		if( (_timestamp == null) || _timestamp.before(timestamp) )	{
			_systemFlags = flagSet;
			_timestamp = timestamp;
		}
	}

	/**
	 * VXetOW擾܂B
	 * @return	tOW
	 */
	public HashSet getSystemFlagSet()
	{
		return _systemFlags;
	}


	/**
	 * ZbVɑݒ肵܂B
	 * @param	name	
	 * @param	value	l
	 */
	public void setSessionAttribute( String name, Serializable value )
	{
		_attributes.put( name, value );
	}

	/**
	 * ZbV̑擾܂B
	 * @param	name	
	 * @return	l
	 */
	public Object getSessionAttribute( String name )
	{
		return _attributes.get( name );
	}


	/**
	 * ݂̃XbhV[̃Xbhǂ𔻒肵܂B
	 * @return	݂̃XbhV[̃Xbh̏ꍇ <code>true</code>AȊȌꍇ <code>false</code>
	 */
	protected boolean isActiveThread()
	{
		return (_activeThread == Thread.currentThread());
	}
}
