/*
 * Common Library for TBAS Softwares
 * Language: Java
 *
 * All Rights Reserved.
 * (c) Copyright 2002 by Tsukuba Bunko.
 *
 * $Id: SimpleDeserializer.java,v 1.1 2003/08/31 08:20:49 ppoi Exp $
 */
package tsukuba_bunko.resource;

import	org.xml.sax.Attributes;
import	org.xml.sax.SAXException;


/**
 * Kw\ȂCVvȒl̃fVACYs <code>ResourceDeserializer</code> ł.
 * @author	$Author
 */
public abstract class SimpleDeserializer extends BasicDeserializer	{

	/**
	 * eLXgobt@
	 */
	protected StringBuffer	_text = null;


	/**
	 * <code>SimpleDeserializer</code> ̃CX^X쐬܂.
	 */
	protected SimpleDeserializer()
	{
		super();
	}

	/**
	 * 񂩂K؂Ȍ^̃IuWFNg֕ϊ܂.
	 * @param	source	ϊ̕
	 * @return	ϊ
	 * @exception	SAXException	ϊɎsꍇ
	 */
	protected abstract Object convertValue( String source )
		throws SAXException;


//
//	ContentHandler ̎
//
	public void startElement( String namespaceURI, String localName, String qName, Attributes attrs )
		throws SAXException
	{
		if( _text == null )	{
			_text = new StringBuffer();
		}
		else	{
			throw new SAXException( "illegal structure.(nested element was illegal structure)" );
		}
	}

	public void endElement( String namespaceURI, String localName, String qName )
		throws SAXException
	{
		setValue( convertValue(new String(_text)) );
		_text = null;
	}

	public void characters( char[] ch, int begin, int length )
	{
		if( _text != null )	{
			_text.append( ch, begin, length );
		}
	}
}
