/*
 * Common Library for TBAS Softwares
 * Language: Java
 *
 * All Rights Reserved.
 * (c) Copyright 2003 by Tsukuba Bunko.
 *
 * $Id: ResourceLocator.java,v 1.1 2003/08/31 08:20:49 ppoi Exp $
 */
package tsukuba_bunko.util;

import	java.io.File;


/**
 * \[X̃t@CVXeł̈ʒu(t@CpX)擾@\񋟂܂B
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1 $
 */
public abstract class ResourceLocator	{

	/**
	 * CX^X <code>ResourceLocator</code> NXw肷VXevpeBF"tsukuba_bunko.util.ResourceLocator.impl"
	 */
	public static final String	IMPL_CLASS_PROPERTY = "tsukuba_bunko.util.ResourceLocator.impl";


	/**
	 * <code>ResourceLocator</code> ̃CX^X𐶐܂B
	 */
	protected ResourceLocator()
	{
		super();
	}


	/**
	 * <code>resourceName</code> Ŏw肳郊\[X݂̃Xbh̃ReNXgŌÃt@CVXeł̈ʒu擾܂B
	 * @param	resourceName	t@CpX擾郊\[X̃\[X
	 * @return	\[X̃t@CpXBos\ȏꍇ <code>null</code>
	 * @throws	ResourceDetectionException	\[X̌oɎsꍇ
	 */
	public File findLocation( String resourceName )
		throws ResourceDetectionException
	{
		return findLocation( resourceName, Thread.currentThread().getContextClassLoader() );
	}

	/**
	 * <code>resourceName</code> Ŏw肳郊\[Xw肳ꂽNX[_ŌÃt@CVXeł̈ʒu擾܂B
	 * @param	resourceName	t@CpX擾郊\[X̃\[X
	 * @param	classLoader	\[XNX[_
	 * @return	\[X̃t@CpX
	 * @throws	ResourceDetectionException	\[X̌oɎsꍇ
	 */
	public abstract File findLocation( String resourceName, ClassLoader classLoader )
		throws ResourceDetectionException;


//
//	t@Ng
//
	/**
	 * <code>ResourceLocator</code> CX^X𐶐܂B
	 *  <code>ResourceLocator</code> CX^X̃NX̓VXevpeBɌ肳܂BvpeB {@link #IMPL_CLASS_PROPERTY} QƂĂB
	 * VXevpeBݒ肳ĂȂꍇAftHg <code>ResourceLocator</code> NXgp܂B
	 * @return	ꂽ <code>ResourceLocator</code> CX^X
	 * @throws	ClassNotFoundException	w肳ꂽNX݂̃Xbh̃ReNXgŌȂꍇ
	 * @throws	InstantiationException	NX̃CX^XɎsꍇ
	 * @throws	IllegalAccessException	NXA܂͂̃RXgN^̃ANZX public łȂꍇ
	 */
	public static ResourceLocator newInstance()
		throws ClassNotFoundException, InstantiationException, IllegalAccessException
	{
		String	className = System.getProperty( ResourceLocator.IMPL_CLASS_PROPERTY, "tsukuba_bunko.util.locator.ResourceLocatorImpl" );
		return newInstance( Thread.currentThread().getContextClassLoader().loadClass(className) );
	}

	/**
	 * <code>ResourceLocator</code> CX^X𐶐܂B
	 * @param	implClass	<code>ResourceLocator</code> NX
	 * @return	ꂽ <code>ResourceLocator</code> CX^X
	 * @throws	InstantiationException	NX̃CX^XɎsꍇ
	 * @throws	IllegalAccessException	NXA܂͂̃RXgN^̃ANZX public łȂꍇ
	 */
	public static ResourceLocator newInstance( Class implClass )
		throws InstantiationException, IllegalAccessException
	{
		if( implClass == null )	{
			throw new IllegalArgumentException( "implement class is not specified." );
		}
		else if( !ResourceLocator.class.isAssignableFrom(implClass) )	{
			throw new IllegalArgumentException( implClass.getName() + " is not extends from ResourceLocator." );
		}

		return (ResourceLocator)implClass.newInstance();
	}
}