/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.bijutsukan;

import java.awt.Color;
import java.awt.Graphics;
import pencilbox.bijutsukan.Board;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandler;

public class Panel
extends PanelEventHandler {
    private Board board;
    boolean warnWrongIllumination = false;
    private Color wallColor = Color.BLACK;
    private Color illuminationColor = Color.BLUE;
    private Color illuminatedColor = new Color(0xAAFFFF);
    private Color noilluminationColor = Color.MAGENTA;
    private Color wallNumberColor = Color.WHITE;
    private Color errorColor = Color.RED;
    private int currentState = -1;

    public Panel() {
        this.setMaxInputNumber(5);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public boolean isWarnWrongIllumination() {
        return this.warnWrongIllumination;
    }

    public void setWarnWrongIllumination(boolean warnWrongIllumination) {
        this.warnWrongIllumination = warnWrongIllumination;
    }

    public Color getIlluminatedColor() {
        return this.illuminatedColor;
    }

    public void setIlluminatedColor(Color illuminatedColor) {
        this.illuminatedColor = illuminatedColor;
    }

    public Color getIlluminationColor() {
        return this.illuminationColor;
    }

    public void setIlluminationColor(Color illuminationColor) {
        this.illuminationColor = illuminationColor;
    }

    public Color getNoilluminationColor() {
        return this.noilluminationColor;
    }

    public void setNoilluminationColor(Color noilluminationColor) {
        this.noilluminationColor = noilluminationColor;
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        if (this.getCellCursor() != null) {
            this.drawCursor(g);
        }
    }

    void drawBoard(Graphics g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int state = this.board.getState(r, c);
                int l = this.board.getHorizIlluminated(r, c);
                int m = this.board.getVertIlluminated(r, c);
                if (l > 0 || m > 0) {
                    g.setColor(this.illuminatedColor);
                    this.paintCell(g, r, c);
                }
                g.setColor(this.illuminationColor);
                if (l > 0) {
                    if (this.warnWrongIllumination && l > 1) {
                        g.setColor(this.errorColor);
                    }
                    this.placeMidline(g, r, c, 1);
                }
                g.setColor(this.illuminationColor);
                if (m > 0) {
                    if (this.warnWrongIllumination && m > 1) {
                        g.setColor(this.errorColor);
                    }
                    this.placeMidline(g, r, c, 0);
                }
                if (state >= 0 && state <= 5) {
                    g.setColor(this.wallColor);
                    this.paintCell(g, r, c);
                    if (state >= 0 && state <= 4) {
                        int st;
                        g.setColor(this.wallNumberColor);
                        if (this.warnWrongIllumination && (st = this.board.checkAdjacentIllumination(r, c)) == -1) {
                            g.setColor(this.errorColor);
                        }
                        this.placeNumber(g, r, c, state);
                    }
                } else if (state == -2) {
                    g.setColor(this.illuminationColor);
                    if (this.warnWrongIllumination && this.board.isMultiIlluminated(r, c)) {
                        g.setColor(this.errorColor);
                    }
                    this.placeFilledCircle(g, r, c);
                } else if (state == -3) {
                    g.setColor(this.noilluminationColor);
                    this.placeCross(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    protected void leftPressed(Address pos) {
        this.board.toggleState(pos.r, pos.c, -2);
    }

    protected void rightPressed(Address pos) {
        this.board.toggleState(pos.r, pos.c, -3);
        this.currentState = this.board.isWall(pos.r, pos.c) ? -1 : this.board.getState(pos.r, pos.c);
    }

    protected void leftDragged(Address pos) {
    }

    protected void rightDragged(Address pos) {
        if (this.board.isWall(pos.r, pos.c)) {
            return;
        }
        if (this.board.getState(pos.r, pos.c) == this.currentState) {
            return;
        }
        this.board.changeStateA(pos.r, pos.c, this.currentState);
    }

    protected void numberEntered(Address pos, int num) {
        if (!this.isProblemEditMode()) {
            return;
        }
        this.board.changeState(pos.r, pos.c, num);
    }

    protected void spaceEntered(Address pos) {
        if (!this.isProblemEditMode()) {
            return;
        }
        this.board.changeState(pos.r, pos.c, -1);
    }

    protected void minusEntered(Address pos) {
        if (!this.isProblemEditMode()) {
            return;
        }
        this.board.changeState(pos.r, pos.c, 5);
    }
}

