/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import pencilbox.common.core.Address;
import pencilbox.common.core.SideAddress;
import pencilbox.common.core.Size;

public class Rotation {
    private int rotation = 0;
    private int ROWS;
    private int COLS;
    private int rows;
    private int cols;

    public void setSize(Size size) {
        this.ROWS = size.getRows();
        this.COLS = size.getCols();
        this.setRotation(this.rotation);
    }

    public void setRotation(int i) {
        this.rotation = i;
        if (this.isTransposed()) {
            this.rows = this.COLS;
            this.cols = this.ROWS;
        } else {
            this.rows = this.ROWS;
            this.cols = this.COLS;
        }
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean isTransposed() {
        switch (this.rotation) {
            case 0: 
            case 2: 
            case 5: 
            case 7: {
                return false;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public void p2b(Address pos) {
        switch (this.rotation) {
            case 0: {
                pos.set(pos.r, pos.c);
                break;
            }
            case 1: {
                pos.set(pos.c, this.rows - 1 - pos.r);
                break;
            }
            case 2: {
                pos.set(this.rows - 1 - pos.r, this.cols - 1 - pos.c);
                break;
            }
            case 3: {
                pos.set(this.cols - 1 - pos.c, pos.r);
                break;
            }
            case 4: {
                pos.set(pos.c, pos.r);
                break;
            }
            case 5: {
                pos.set(pos.r, this.cols - 1 - pos.c);
                break;
            }
            case 6: {
                pos.set(this.cols - 1 - pos.c, this.rows - 1 - pos.r);
                break;
            }
            case 7: {
                pos.set(this.rows - 1 - pos.r, pos.c);
            }
        }
    }

    public void p2b(Address pos, int adjustRow, int adjustCol) {
        switch (this.rotation) {
            case 0: {
                pos.set(pos.r, pos.c);
                break;
            }
            case 1: {
                pos.set(pos.c, this.rows + adjustRow - 1 - pos.r);
                break;
            }
            case 2: {
                pos.set(this.rows + adjustRow - 1 - pos.r, this.cols + adjustCol - 1 - pos.c);
                break;
            }
            case 3: {
                pos.set(this.cols + adjustCol - 1 - pos.c, pos.r);
                break;
            }
            case 4: {
                pos.set(pos.c, pos.r);
                break;
            }
            case 5: {
                pos.set(pos.r, this.cols + adjustCol - 1 - pos.c);
                break;
            }
            case 6: {
                pos.set(this.cols + adjustCol - 1 - pos.c, this.rows + adjustRow - 1 - pos.r);
                break;
            }
            case 7: {
                pos.set(this.rows + adjustRow - 1 - pos.r, pos.c);
            }
        }
    }

    public void p2bSide(SideAddress pos) {
        switch (this.rotation) {
            case 0: {
                pos.set(pos.d, pos.r, pos.c);
                break;
            }
            case 1: {
                pos.set(pos.d ^ 1, pos.c, this.rows - 1 - pos.d - pos.r);
                break;
            }
            case 2: {
                pos.set(pos.d, this.rows - 1 - pos.d - pos.r, this.cols - 1 - (pos.d ^ 1) - pos.c);
                break;
            }
            case 3: {
                pos.set(pos.d ^ 1, this.cols - 1 - (pos.d ^ 1) - pos.c, pos.r);
                break;
            }
            case 4: {
                pos.set(pos.d ^ 1, pos.c, pos.r);
                break;
            }
            case 5: {
                pos.set(pos.d, pos.r, this.cols - 1 - (pos.d ^ 1) - pos.c);
                break;
            }
            case 6: {
                pos.set(pos.d ^ 1, this.cols - 1 - (pos.d ^ 1) - pos.c, this.rows - 1 - pos.d - pos.r);
                break;
            }
            case 7: {
                pos.set(pos.d, this.rows - 1 - pos.d - pos.r, pos.c);
            }
        }
    }

    public void b2p(Address pos, int adjustRow, int adjustCol) {
        switch (this.rotation) {
            case 0: {
                pos.set(pos.r, pos.c);
                break;
            }
            case 1: {
                pos.set(this.COLS + adjustCol - 1 - pos.c, pos.r);
                break;
            }
            case 2: {
                pos.set(this.ROWS + adjustRow - 1 - pos.r, this.COLS + adjustCol - 1 - pos.c);
                break;
            }
            case 3: {
                pos.set(pos.c, this.ROWS + adjustRow - 1 - pos.r);
                break;
            }
            case 4: {
                pos.set(pos.c, pos.r);
                break;
            }
            case 5: {
                pos.set(pos.r, this.COLS + adjustCol - 1 - pos.c);
                break;
            }
            case 6: {
                pos.set(this.COLS + adjustCol - 1 - pos.c, this.ROWS + adjustRow - 1 - pos.r);
                break;
            }
            case 7: {
                pos.set(this.ROWS + adjustRow - 1 - pos.r, pos.c);
            }
        }
    }

    public void b2p(Address pos) {
        switch (this.rotation) {
            case 0: {
                pos.set(pos.r, pos.c);
                break;
            }
            case 1: {
                pos.set(this.COLS - 1 - pos.c, pos.r);
                break;
            }
            case 2: {
                pos.set(this.ROWS - 1 - pos.r, this.COLS - 1 - pos.c);
                break;
            }
            case 3: {
                pos.set(pos.c, this.ROWS - 1 - pos.r);
                break;
            }
            case 4: {
                pos.set(pos.c, pos.r);
                break;
            }
            case 5: {
                pos.set(pos.r, this.COLS - 1 - pos.c);
                break;
            }
            case 6: {
                pos.set(this.COLS - 1 - pos.c, this.ROWS - 1 - pos.r);
                break;
            }
            case 7: {
                pos.set(this.ROWS - 1 - pos.r, pos.c);
            }
        }
    }

    public void b2pSide(SideAddress pos) {
        switch (this.rotation) {
            case 0: {
                pos.set(pos.d, pos.r, pos.c);
                break;
            }
            case 1: {
                pos.set(pos.d ^ 1, this.COLS - 1 - (pos.d ^ 1) - pos.c, pos.r);
                break;
            }
            case 2: {
                pos.set(pos.d, this.ROWS - 1 - pos.d - pos.r, this.COLS - 1 - (pos.d ^ 1) - pos.c);
                break;
            }
            case 3: {
                pos.set(pos.d ^ 1, pos.c, this.ROWS - 1 - pos.d - pos.r);
                break;
            }
            case 4: {
                pos.set(pos.d ^ 1, pos.c, pos.r);
                break;
            }
            case 5: {
                pos.set(pos.d, pos.r, this.COLS - 1 - (pos.d ^ 1) - pos.c);
                break;
            }
            case 6: {
                pos.set(pos.d ^ 1, this.COLS - 1 - (pos.d ^ 1) - pos.c, this.ROWS - 1 - pos.d - pos.r);
                break;
            }
            case 7: {
                pos.set(pos.d, this.ROWS - 1 - pos.d - pos.r, pos.c);
            }
        }
    }

    public int rotateDirection(int direction) {
        switch (this.rotation) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                direction = (direction + this.rotation) % 4;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                direction = (direction + this.rotation) % 4;
                direction ^= 1;
            }
        }
        return direction;
    }
}

