/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Rotation;
import pencilbox.common.core.SideAddress;
import pencilbox.common.core.Size;
import pencilbox.common.gui.CellCursor;

public class PanelBase
extends JPanel
implements Printable {
    private Size size;
    protected BufferedImage backgroundImage;
    protected BufferedImage originalImage;
    protected AffineTransform backgroundImageTransform = AffineTransform.getRotateInstance(Math.toRadians(0.0));
    protected boolean useBackgroundImage = false;
    private int cellSize = 26;
    private int halfCellSize = this.cellSize / 2;
    private int circleSize = 18;
    private int crossSize = 8;
    private int smallCrossSize = 3;
    private int offsetx = 26;
    private int offsety = 26;
    private Color backgroundColor = Color.WHITE;
    private Color borderColor = Color.BLACK;
    private Color gridColor = Color.BLACK;
    private Color numberColor = Color.BLACK;
    private Color cursorColor = new Color(0xFF0000);
    private Color cursorColor2 = new Color(255);
    private Font indexFont = new Font("SansSerif", 2, 13);
    private Font numberFont = new Font("SansSerif", 0, 20);
    private Rotation rotator = new Rotation();
    private int displayStyle = 0;
    private boolean cursorOn = false;
    private CellCursor cellCursor;
    private boolean problemEditMode = false;
    private Address pos0 = new Address();
    private Address pos1 = new Address();
    private SideAddress sidePos = new SideAddress();

    public PanelBase() {
        this.setFocusable(true);
    }

    public void setup(BoardBase board) {
        this.size = board.getSize();
        this.rotator.setSize(this.size);
        this.updatePreferredSize();
        this.setBoard(board);
    }

    protected void setBoard(BoardBase board) {
    }

    public void setImage(BufferedImage image) {
        this.backgroundImage = image;
        this.originalImage = image;
        this.repaint();
    }

    protected int getRotation() {
        return this.rotator.getRotation();
    }

    protected void setRotation(int rotation) {
        this.rotator.setRotation(rotation);
        this.updatePreferredSize();
        this.repaint();
    }

    protected void setDisplaySize(int cellSize) {
        this.cellSize = cellSize;
        this.offsetx = cellSize;
        this.offsety = cellSize;
        this.setHalfCellSize(cellSize / 2);
        this.circleSize = (int)((double)cellSize * 0.7);
        this.crossSize = (int)((double)cellSize * 0.3);
        this.smallCrossSize = (int)((double)cellSize * 0.15);
        this.numberFont = new Font("SansSerif", 0, cellSize * 4 / 5);
        this.indexFont = new Font("SansSerif", 2, cellSize / 2);
        this.updatePreferredSize();
        this.repaint();
    }

    protected int getDisplayStyle() {
        return this.displayStyle;
    }

    protected void setDisplayStyle(int i) {
        this.displayStyle = i;
    }

    protected void updatePreferredSize() {
        this.setPreferredSize(new Dimension(this.offsetx * 2 + this.cellSize * this.cols(), this.offsety * 2 + this.cellSize * this.rows()));
        this.revalidate();
    }

    public void setProblemEditMode(boolean problemEditMode) {
        this.problemEditMode = problemEditMode;
        if (problemEditMode) {
            this.setRotation(0);
        }
    }

    public boolean isProblemEditMode() {
        return this.problemEditMode;
    }

    public int rows() {
        return this.isTransposed() ? this.size.getCols() : this.size.getRows();
    }

    public int cols() {
        return this.isTransposed() ? this.size.getRows() : this.size.getCols();
    }

    protected boolean isOn(int r, int c) {
        return r >= 0 && r < this.rows() && c >= 0 && c < this.cols();
    }

    protected boolean isOn(Address address) {
        return this.isOn(address.r, address.c);
    }

    protected boolean isSideOn(SideAddress address) {
        if (address.d == 0) {
            return address.r >= 0 && address.r < this.rows() && address.c >= 0 && address.c < this.cols() - 1;
        }
        if (address.d == 1) {
            return address.r >= 0 && address.r < this.rows() - 1 && address.c >= 0 && address.c < this.cols();
        }
        return false;
    }

    protected boolean isOn(int r, int c, int adjustRow, int adjustCol) {
        return r >= 0 && r < this.rows() + adjustRow && c >= 0 && c < this.cols() + adjustCol;
    }

    protected boolean isOn(Address address, int adjustRow, int adjustCol) {
        return this.isOn(address.r, address.c, adjustRow, adjustCol);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawPanel(g);
    }

    public void drawPanel(Graphics g) {
    }

    public final int toX(int c) {
        return this.offsetx + this.cellSize * c;
    }

    public final int toY(int r) {
        return this.offsety + this.cellSize * r;
    }

    public boolean isTransposed() {
        return this.rotator.isTransposed();
    }

    public void p2b(Address pos) {
        this.rotator.p2b(pos);
    }

    public void p2b(Address pos, int adjustRow, int adjustCol) {
        this.rotator.p2b(pos, adjustRow, adjustCol);
    }

    public void p2bSide(SideAddress pos) {
        this.rotator.p2bSide(pos);
    }

    public void b2p(Address pos, int adjustRow, int adjustCol) {
        this.rotator.b2p(pos, adjustRow, adjustCol);
    }

    public void b2p(Address pos) {
        this.rotator.b2p(pos);
    }

    public void b2pSide(SideAddress pos) {
        this.rotator.b2pSide(pos);
    }

    public int rotateDirection(int direction) {
        return this.rotator.rotateDirection(direction);
    }

    public void paintBackground(Graphics g) {
        if (this.useBackgroundImage && this.backgroundImage != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage(this.backgroundImage, this.backgroundImageTransform, null);
        } else {
            g.setColor(this.backgroundColor);
            g.fillRect(this.offsetx, this.offsety, this.cellSize * this.cols(), this.cellSize * this.rows());
        }
    }

    public void drawBorder(Graphics g) {
        g.setColor(this.borderColor);
        g.drawRect(this.offsetx - 1, this.offsety - 1, this.cellSize * this.cols() + 2, this.cellSize * this.rows() + 2);
        g.drawRect(this.offsetx, this.offsety, this.cellSize * this.cols(), this.cellSize * this.rows());
    }

    public void drawGrid(Graphics g) {
        g.setColor(this.gridColor);
        int r = 1;
        while (r < this.rows()) {
            g.drawLine(this.toX(0), this.toY(r), this.toX(this.cols()), this.toY(r));
            ++r;
        }
        int c = 1;
        while (c < this.cols()) {
            g.drawLine(this.toX(c), this.toY(0), this.toX(c), this.toY(this.rows()));
            ++c;
        }
    }

    public void drawIndex(Graphics g) {
        int offset = 1;
        g.setFont(this.indexFont);
        g.setColor(this.numberColor);
        int r = 0;
        while (r < this.rows()) {
            this.placeIndexNumber(g, r, -1, r + offset);
            ++r;
        }
        int c = 0;
        while (c < this.cols()) {
            this.placeIndexNumber(g, -1, c, c + offset);
            ++c;
        }
    }

    public void drawCursor(Graphics g) {
        if (!this.isProblemEditMode() && !this.cursorOn) {
            return;
        }
        if (this.isProblemEditMode()) {
            g.setColor(this.cursorColor);
        } else if (this.cursorOn) {
            g.setColor(this.cursorColor2);
        }
        g.drawRect(this.toX(this.cellCursor.c()), this.toY(this.cellCursor.r()), this.cellSize, this.cellSize);
        g.drawRect(this.toX(this.cellCursor.c()) + 1, this.toY(this.cellCursor.r()) + 1, this.cellSize - 2, this.cellSize - 2);
        g.drawRect(this.toX(this.cellCursor.c()) + 2, this.toY(this.cellCursor.r()) + 2, this.cellSize - 4, this.cellSize - 4);
    }

    public void drawLineSegment(Graphics g, int x, int y, int direction) {
        if (direction == 1) {
            g.fillRect(x, y - 1, this.cellSize + 1, 3);
        } else if (direction == 0) {
            g.fillRect(x - 1, y, 3, this.cellSize + 1);
        }
    }

    public void drawCross(Graphics g, int x, int y, int halfSize) {
        g.drawLine(x - halfSize, y - halfSize, x + halfSize, y + halfSize);
        g.drawLine(x - halfSize, y + halfSize, x + halfSize, y - halfSize);
    }

    public void drawMidline(Graphics g, int x, int y, int direction) {
        int length = this.getHalfCellSize();
        if (direction == 1) {
            g.drawLine(x - length, y, x + length, y);
        } else if (direction == 0) {
            g.drawLine(x, y - length, x, y + length);
        }
    }

    public void drawMidline3(Graphics g, int x, int y, int direction) {
        int length = this.getHalfCellSize();
        if (direction == 1) {
            g.drawLine(x - length, y - 1, x + length, y - 1);
            g.drawLine(x - length, y, x + length, y);
            g.drawLine(x - length, y + 1, x + length, y + 1);
        } else if (direction == 0) {
            g.drawLine(x - 1, y - length, x - 1, y + length);
            g.drawLine(x, y - length, x, y + length);
            g.drawLine(x + 1, y - length, x + 1, y + length);
        }
    }

    public void placeLetter(Graphics g, int r, int c, char letter) {
        this.pos0.set(r, c);
        this.b2p(this.pos0);
        FontMetrics metrics = g.getFontMetrics();
        try {
            String string = Character.toString(letter);
            g.drawString(string, this.toX(this.pos0.c) + (this.cellSize - 1 - metrics.stringWidth(string)) / 2 + 1, this.toY(this.pos0.r) + (this.cellSize - 1 - metrics.getHeight()) / 2 + metrics.getAscent() + 1);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void placeNumber(Graphics g, int r, int c, int number) {
        this.pos0.set(r, c);
        this.b2p(this.pos0);
        FontMetrics metrics = g.getFontMetrics();
        try {
            String numS = Integer.toString(number);
            g.drawString(numS, this.toX(this.pos0.c) + (this.cellSize - 1 - metrics.stringWidth(numS)) / 2 + 1, this.toY(this.pos0.r) + (this.cellSize - 1 - metrics.getHeight()) / 2 + metrics.getAscent() + 1);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void placeIndexNumber(Graphics g, int r, int c, int number) {
        this.pos0.set(r, c);
        FontMetrics metrics = g.getFontMetrics();
        try {
            String numS = Integer.toString(number);
            g.drawString(numS, this.toX(this.pos0.c) + (this.cellSize - 1 - metrics.stringWidth(numS)) / 2 + 1, this.toY(this.pos0.r) + (this.cellSize - 1 - metrics.getHeight()) / 2 + metrics.getAscent() + 1);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void paintCell(Graphics g, int r, int c) {
        this.pos0.set(r, c);
        this.b2p(this.pos0);
        g.fillRect(this.toX(this.pos0.c) + 1, this.toY(this.pos0.r) + 1, this.cellSize - 1, this.cellSize - 1);
    }

    public void placeCircle(Graphics g, int r, int c) {
        this.pos0.set(r, c);
        this.b2p(this.pos0);
        g.drawOval(this.toX(this.pos0.c) + (this.cellSize - this.circleSize) / 2, this.toY(this.pos0.r) + (this.cellSize - this.circleSize) / 2, this.circleSize, this.circleSize);
    }

    public void placeCircle(Graphics g, int r, int c, int circleSize) {
        this.pos0.set(r, c);
        this.b2p(this.pos0);
        g.drawOval(this.toX(this.pos0.c) + (this.cellSize - circleSize) / 2, this.toY(this.pos0.r) + (this.cellSize - circleSize) / 2, circleSize, circleSize);
    }

    public void placeLargeCircle(Graphics g, int r, int c) {
        this.placeCircle(g, r, c, this.cellSize - 2);
    }

    public void placeBoldCircle(Graphics g, int r, int c) {
        this.pos0.set(r, c);
        this.b2p(this.pos0);
        int x = this.toX(this.pos0.c) + (this.cellSize - this.circleSize) / 2;
        int y = this.toY(this.pos0.r) + (this.cellSize - this.circleSize) / 2;
        g.drawOval(x, y, this.circleSize, this.circleSize);
        g.drawOval(x + 1, y + 1, this.circleSize - 2, this.circleSize - 2);
    }

    public void placeBoldCircle(Graphics g, int r, int c, int circleSize) {
        this.pos0.set(r, c);
        this.b2p(this.pos0);
        int x = this.toX(this.pos0.c) + (this.cellSize - circleSize) / 2;
        int y = this.toY(this.pos0.r) + (this.cellSize - circleSize) / 2;
        g.drawOval(x, y, circleSize, circleSize);
        g.drawOval(x + 1, y + 1, circleSize - 2, circleSize - 2);
    }

    public void placeFilledCircle(Graphics g, int r, int c) {
        this.pos0.set(r, c);
        this.b2p(this.pos0);
        g.fillOval(this.toX(this.pos0.c) + (this.cellSize - this.circleSize) / 2, this.toY(this.pos0.r) + (this.cellSize - this.circleSize) / 2, this.circleSize + 1, this.circleSize + 1);
    }

    public void placeLargeFilledCircle(Graphics g, int r, int c) {
        this.placeFilledCircle(g, r, c, this.cellSize - 2);
    }

    public void placeFilledCircle(Graphics g, int r, int c, int circleSize) {
        this.pos0.set(r, c);
        this.b2p(this.pos0);
        g.fillOval(this.toX(this.pos0.c) + (this.cellSize - circleSize) / 2, this.toY(this.pos0.r) + (this.cellSize - circleSize) / 2, circleSize + 1, circleSize + 1);
    }

    public void placeCross(Graphics g, int r, int c) {
        this.pos0.set(r, c);
        this.b2p(this.pos0);
        this.drawCross(g, this.toX(this.pos0.c) + this.getHalfCellSize(), this.toY(this.pos0.r) + this.getHalfCellSize(), this.crossSize);
    }

    public void placeSideLine(Graphics g, int dir, int r, int c) {
        this.sidePos.set(dir, r, c);
        this.b2pSide(this.sidePos);
        this.drawLineSegment(g, this.toX(this.sidePos.c + (this.sidePos.d ^ 1)), this.toY(this.sidePos.r + this.sidePos.d), this.sidePos.d);
    }

    public void placeTraversalLine(Graphics g, int dir, int r, int c) {
        this.sidePos.set(dir, r, c);
        this.b2pSide(this.sidePos);
        this.drawLineSegment(g, this.toX(this.sidePos.c) + this.getHalfCellSize(), this.toY(this.sidePos.r) + this.getHalfCellSize(), this.sidePos.d ^ 1);
    }

    public void placeSideCross(Graphics g, int dir, int r, int c) {
        this.sidePos.set(dir, r, c);
        this.b2pSide(this.sidePos);
        if (this.sidePos.d == 0) {
            this.drawCross(g, this.toX(this.sidePos.c + 1), this.toY(this.sidePos.r) + this.getHalfCellSize(), this.smallCrossSize);
        } else if (this.sidePos.d == 1) {
            this.drawCross(g, this.toX(this.sidePos.c) + this.getHalfCellSize(), this.toY(this.sidePos.r + 1), this.smallCrossSize);
        }
    }

    public void placeMidline(Graphics g, int r, int c, int dir) {
        this.pos0.set(r, c);
        this.b2p(this.pos0);
        int direction = dir == 1 ^ this.isTransposed() ? 1 : 0;
        this.drawMidline(g, this.toX(this.pos0.c) + this.getHalfCellSize(), this.toY(this.pos0.r) + this.getHalfCellSize(), direction);
    }

    public void placeSquare(Graphics g, int r0, int c0, int r1, int c1) {
        this.pos0.set(r0, c0);
        this.pos1.set(r1, c1);
        this.b2p(this.pos0);
        this.b2p(this.pos1);
        g.drawRect(this.toX(this.pos0.c < this.pos1.c ? this.pos0.c : this.pos1.c) + 1, this.toY(this.pos0.r < this.pos1.r ? this.pos0.r : this.pos1.r) + 1, this.cellSize * ((this.pos0.c < this.pos1.c ? this.pos1.c - this.pos0.c : this.pos0.c - this.pos1.c) + 1) - 2, this.cellSize * ((this.pos0.r < this.pos1.r ? this.pos1.r - this.pos0.r : this.pos0.r - this.pos1.r) + 1) - 2);
    }

    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page >= 1) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(pf.getImageableX(), pf.getImageableY());
        g2.scale(0.7, 0.7);
        this.drawPanel(g2);
        return 0;
    }

    public void setCellSize(int cellSize) {
        this.cellSize = cellSize;
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public void setHalfCellSize(int halfCellSize) {
        this.halfCellSize = halfCellSize;
    }

    public int getHalfCellSize() {
        return this.halfCellSize;
    }

    public void setCircleSize(int circleSize) {
        this.circleSize = circleSize;
    }

    public int getCircleSize() {
        return this.circleSize;
    }

    public void setCrossSize(int crossSize) {
        this.crossSize = crossSize;
    }

    public int getCrossSize() {
        return this.crossSize;
    }

    public void setSmallCrossSize(int smallCrossSize) {
        this.smallCrossSize = smallCrossSize;
    }

    public int getSmallCrossSize() {
        return this.smallCrossSize;
    }

    public void setOffsetx(int offsetx) {
        this.offsetx = offsetx;
    }

    public int getOffsetx() {
        return this.offsetx;
    }

    public void setOffsety(int offsety) {
        this.offsety = offsety;
    }

    public int getOffsety() {
        return this.offsety;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setNumberColor(Color numberColor) {
        this.numberColor = numberColor;
    }

    public Color getNumberColor() {
        return this.numberColor;
    }

    public void setCursorColor(Color cursorColor) {
        this.cursorColor = cursorColor;
    }

    public Color getCursorColor() {
        return this.cursorColor;
    }

    public void setCursorOn(boolean cursorOn) {
        this.cursorOn = cursorOn;
    }

    public boolean isCursorOn() {
        return this.cursorOn;
    }

    protected void setNumberFont(Font numberFont) {
        this.numberFont = numberFont;
    }

    protected Font getNumberFont() {
        return this.numberFont;
    }

    protected void setCellCursor(CellCursor cellCursor) {
        this.cellCursor = cellCursor;
    }

    protected CellCursor getCellCursor() {
        return this.cellCursor;
    }
}

