/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.fillomino;

import java.awt.Color;
import java.awt.Graphics;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandler;
import pencilbox.fillomino.Board;

public class Panel
extends PanelEventHandler {
    private Board board;
    private boolean showAreaBorder = true;
    private boolean showAreaHint = false;
    private Color inputColor = Color.BLUE;
    private Color areaBorderColor = Color.BLUE;
    private Color errorColor = Color.RED;
    private Color successColor = new Color(0x80FFFF);
    private int state;

    public Panel() {
        this.setGridColor(Color.GRAY);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setInputColor(Color inputColor) {
        this.inputColor = inputColor;
    }

    public boolean isShowAreaBorder() {
        return this.showAreaBorder;
    }

    public void setShowAreaBorder(boolean showAreaBorder) {
        this.showAreaBorder = showAreaBorder;
    }

    public boolean isShowAreaHint() {
        return this.showAreaHint;
    }

    public void setShowAreaHint(boolean showAreaHint) {
        this.showAreaHint = showAreaHint;
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        if (this.getCellCursor() != null) {
            this.drawCursor(g);
        }
    }

    void drawBoard(Graphics g) {
        this.drawNumbers(g);
        if (this.showAreaBorder) {
            this.drawBorders(g);
        }
    }

    private void drawNumbers(Graphics g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int number = this.board.getNumber(r, c);
                if (number > 0 && this.showAreaHint) {
                    int status = this.board.getArea(r, c).getStatus();
                    if (status == -1) {
                        g.setColor(this.errorColor);
                        this.paintCell(g, r, c);
                    } else if (status == 1) {
                        g.setColor(this.successColor);
                        this.paintCell(g, r, c);
                    }
                }
                if (number > 0) {
                    if (this.board.isStable(r, c)) {
                        g.setColor(this.getNumberColor());
                    } else {
                        g.setColor(this.inputColor);
                    }
                    this.placeNumber(g, r, c, this.board.getNumber(r, c));
                } else if (number == 0 && this.board.isStable(r, c)) {
                    g.setColor(this.getNumberColor());
                    this.placeBoldCircle(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawBorders(Graphics g) {
        g.setColor(this.areaBorderColor);
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols() - 1) {
                if (this.board.getNumber(r, c) != this.board.getNumber(r, c + 1)) {
                    this.placeSideLine(g, 0, r, c);
                }
                ++c;
            }
            if (this.board.getArea(r, 0) != null) {
                this.placeSideLine(g, 0, r, -1);
            }
            if (this.board.getArea(r, this.board.cols() - 1) != null) {
                this.placeSideLine(g, 0, r, this.board.cols() - 1);
            }
            ++r;
        }
        int c = 0;
        while (c < this.board.cols()) {
            int r2 = 0;
            while (r2 < this.board.rows() - 1) {
                if (this.board.getNumber(r2, c) != this.board.getNumber(r2 + 1, c)) {
                    this.placeSideLine(g, 1, r2, c);
                }
                ++r2;
            }
            if (this.board.getArea(0, c) != null) {
                this.placeSideLine(g, 1, -1, c);
            }
            if (this.board.getArea(this.board.rows() - 1, c) != null) {
                this.placeSideLine(g, 1, this.board.rows() - 1, c);
            }
            ++c;
        }
    }

    protected void leftPressed(Address pos) {
        this.state = this.board.getNumber(pos.r, pos.c);
    }

    protected void rightPressed(Address pos) {
        if (!this.board.isStable(pos.r, pos.c)) {
            this.board.enterNumberA(pos.r, pos.c, 0);
        }
    }

    protected void leftClicked(Address pos) {
        if (!this.board.isStable(pos.r, pos.c)) {
            this.board.increaseNumber(pos.r, pos.c);
        }
    }

    protected void rightClicked(Address pos) {
        if (!this.board.isStable(pos.r, pos.c)) {
            this.board.decreaseNumber(pos.r, pos.c);
        }
    }

    protected void leftDragged(Address oldPos, Address newPos) {
        if (!this.board.isStable(newPos.r, newPos.c)) {
            this.board.enterNumberA(newPos.r, newPos.c, this.state);
        }
    }

    protected void rightDragged(Address oldPos, Address newPos) {
        if (!this.board.isStable(newPos.r, newPos.c)) {
            this.board.enterNumberA(newPos.r, newPos.c, 0);
        }
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            if (num > 0) {
                this.board.changeNumber(pos.r, pos.c, num);
                this.board.setState(pos.r, pos.c, 1);
            }
        } else if (num > 0 && !this.board.isStable(pos.r, pos.c)) {
            this.board.enterNumberA(pos.r, pos.c, num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.changeNumber(pos.r, pos.c, 0);
            this.board.setState(pos.r, pos.c, 0);
        } else if (!this.board.isStable(pos.r, pos.c)) {
            this.board.enterNumberA(pos.r, pos.c, 0);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.changeNumber(pos.r, pos.c, 0);
            this.board.setState(pos.r, pos.c, 1);
        }
    }
}

