/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hakyukoka;

import java.awt.Color;
import java.awt.Graphics;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.HintDot;
import pencilbox.common.gui.PanelEventHandler;
import pencilbox.hakyukoka.Area;
import pencilbox.hakyukoka.Board;

public class Panel
extends PanelEventHandler {
    private Board board;
    private int maxNumber = 9;
    private boolean warnWrongNumber = false;
    private boolean highlightSelectedNumber = false;
    private Color inputColor = Color.BLUE;
    private Color areaBorderColor = Color.BLACK;
    private Color errorColor = Color.RED;
    private Color noAreaColor = new Color(0xCCCCCC);
    private int selectedNumber = 0;
    private Color selectedNumberColor = new Color(0xAAFFAA);
    private Color emissionColor = new Color(0x800000);
    private boolean showAllowedNumberDot = false;
    private HintDot hintDot = new HintDot();
    private Area draggingArea;

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setCursorOn(true);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.setMaxInputNumber(this.maxNumber);
        this.hintDot.setDot(this, 3, this.getCellSize());
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setInputColor(Color inputColor) {
        this.inputColor = inputColor;
    }

    public void setHighlightSelectedNumber(boolean highlightSelectedNumber) {
        this.highlightSelectedNumber = highlightSelectedNumber;
    }

    public void setShowAllowedNumberDot(boolean showAllowedNumberDot) {
        this.showAllowedNumberDot = showAllowedNumberDot;
    }

    public void setWarnWrongNumber(boolean warnWrongNumber) {
        this.warnWrongNumber = warnWrongNumber;
    }

    protected void setDisplaySize(int cellSize) {
        super.setDisplaySize(cellSize);
        this.hintDot.setDotSize(cellSize);
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        if (this.getCellCursor() != null) {
            this.drawCursor(g);
        }
    }

    void drawBoard(Graphics g) {
        this.paintCells(g);
        this.drawEmission(g);
        this.drawNumbers(g);
        if (this.showAllowedNumberDot) {
            this.drawDots(g);
        }
        this.drawBorders(g);
    }

    private void drawEmission(Graphics g) {
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int n = this.board.getNumber(r, c);
                if (this.highlightSelectedNumber && n > 0 && n == this.selectedNumber) {
                    int cc = c - n;
                    while (cc <= c + n) {
                        if (cc != c && this.board.isOn(r, cc)) {
                            g.setColor(this.emissionColor);
                            this.placeMidline(g, r, cc, 1);
                        }
                        ++cc;
                    }
                    int rr = r - n;
                    while (rr <= r + n) {
                        if (rr != r && this.board.isOn(rr, c)) {
                            g.setColor(this.emissionColor);
                            this.placeMidline(g, rr, c, 0);
                        }
                        ++rr;
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    private void paintCells(Graphics g) {
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                if (this.board.getArea(r, c) == null) {
                    g.setColor(this.noAreaColor);
                    this.paintCell(g, r, c);
                }
                if (this.highlightSelectedNumber && this.selectedNumber > 0 && this.board.getNumber(r, c) == this.selectedNumber) {
                    g.setColor(this.selectedNumberColor);
                    this.paintCell(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawNumbers(Graphics g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int n = this.board.getNumber(r, c);
                if (this.board.getNumber(r, c) > 0) {
                    if (this.board.isStable(r, c)) {
                        g.setColor(this.getNumberColor());
                    } else if (this.warnWrongNumber && this.board.isError(r, c)) {
                        g.setColor(this.errorColor);
                    } else {
                        g.setColor(this.inputColor);
                    }
                    this.placeNumber(g, r, c, this.board.getNumber(r, c));
                } else if (n == 0 && this.board.isStable(r, c)) {
                    g.setColor(this.getNumberColor());
                    this.placeBoldCircle(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawBorders(Graphics g) {
        g.setColor(this.areaBorderColor);
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols() - 1) {
                if (this.board.getArea(r, c) != this.board.getArea(r, c + 1)) {
                    this.placeSideLine(g, 0, r, c);
                }
                ++c;
            }
            if (this.board.getArea(r, 0) != null) {
                this.placeSideLine(g, 0, r, -1);
            }
            if (this.board.getArea(r, this.board.cols() - 1) != null) {
                this.placeSideLine(g, 0, r, this.board.cols() - 1);
            }
            ++r;
        }
        int c = 0;
        while (c < this.board.cols()) {
            int r2 = 0;
            while (r2 < this.board.rows() - 1) {
                if (this.board.getArea(r2, c) != this.board.getArea(r2 + 1, c)) {
                    this.placeSideLine(g, 1, r2, c);
                }
                ++r2;
            }
            if (this.board.getArea(0, c) != null) {
                this.placeSideLine(g, 1, -1, c);
            }
            if (this.board.getArea(this.board.rows() - 1, c) != null) {
                this.placeSideLine(g, 1, this.board.rows() - 1, c);
            }
            ++c;
        }
    }

    private void drawDots(Graphics g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int num = this.board.getNumber(r, c);
                if (num == 0) {
                    int pat = this.board.getPattern(r, c);
                    if (pat == 0) {
                        this.hintDot.placeHintCross(g, r, c);
                    } else {
                        this.hintDot.placeHintDot(g, r, c, pat);
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    protected void leftPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Area oldArea = this.board.getArea(pos.r, pos.c);
            if (this.draggingArea == null) {
                this.draggingArea = new Area();
            }
            if (oldArea != null && oldArea != this.draggingArea) {
                this.board.removeArea(oldArea);
            }
            this.board.setArea(pos.r, pos.c, this.draggingArea);
            this.draggingArea.add(pos);
        } else {
            if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isStable(pos.r, pos.c))) {
                this.board.increaseNumber(pos.r, pos.c);
            }
            this.selectedNumber = this.board.getNumber(pos.r, pos.c);
        }
    }

    protected void rightPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Area oldArea = this.board.getArea(pos.r, pos.c);
            if (oldArea != null) {
                this.board.removeArea(oldArea);
            }
        } else {
            if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isStable(pos.r, pos.c))) {
                this.board.decreaseNumber(pos.r, pos.c);
            }
            this.selectedNumber = this.board.getNumber(pos.r, pos.c);
        }
    }

    protected void leftDragged(Address pos) {
        if (this.isProblemEditMode()) {
            this.getCellCursor().setPosition(pos);
            this.leftPressed(pos);
        }
    }

    protected void rightDragged(Address pos) {
        if (this.isProblemEditMode()) {
            this.rightPressed(pos);
        }
    }

    protected void leftDragFixed(Address dragEnd) {
        if (this.draggingArea == null) {
            return;
        }
        this.board.addArea(this.draggingArea);
        this.draggingArea = null;
    }

    protected void rightDragFixed(Address dragStart, Address dragEnd) {
        this.draggingArea = null;
    }

    protected void dragFailed() {
        if (this.draggingArea == null) {
            return;
        }
        this.board.addArea(this.draggingArea);
        this.draggingArea = null;
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            if (num > 0) {
                this.board.changeNumber(pos.r, pos.c, num);
                this.board.setState(pos.r, pos.c, 1);
            }
        } else if (num > 0 && !this.board.isStable(pos.r, pos.c)) {
            this.board.enterNumberA(pos.r, pos.c, num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.setNumber(pos.r, pos.c, 0);
            this.board.setState(pos.r, pos.c, 0);
        } else if (!this.board.isStable(pos.r, pos.c)) {
            this.board.enterNumberA(pos.r, pos.c, 0);
        }
        if (this.isProblemEditMode()) {
            this.board.setNumber(pos.r, pos.c, 0);
            this.board.setState(pos.r, pos.c, 0);
        } else if (!this.board.isStable(pos.r, pos.c)) {
            this.board.enterNumberA(pos.r, pos.c, 0);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.setNumber(pos.r, pos.c, 0);
            this.board.setState(pos.r, pos.c, 1);
        }
    }
}

