/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.nurikabe;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandler;
import pencilbox.nurikabe.Area;
import pencilbox.nurikabe.Board;
import pencilbox.util.Colors;

public class Panel
extends PanelEventHandler {
    private Board board;
    private Color paintColor = Color.BLUE;
    private Color circleColor = Color.MAGENTA;
    private Color errorColor = Color.RED;
    private int currentState = 0;
    private Font countFont = new Font("SansSerif", 2, 13);
    private boolean colorForEachWall = false;
    private boolean showWrongWall = false;
    private boolean showShimaSize = false;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public void setShowShimaSize(boolean showShimaSize) {
        this.showShimaSize = showShimaSize;
    }

    public void setShowWrongWall(boolean showWrongWall) {
        this.showWrongWall = showWrongWall;
    }

    public void setColorForEachWall(boolean colorForEachWall) {
        this.colorForEachWall = colorForEachWall;
    }

    public void setPaintColor(Color paintColor) {
        this.paintColor = paintColor;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    protected void setDisplaySize(int size) {
        super.setDisplaySize(size);
        this.countFont = new Font("SansSerif", 2, this.getCellSize() / 2);
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        if (this.getCellCursor() != null) {
            this.drawCursor(g);
        }
    }

    void drawBoard(Graphics g) {
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int st = this.board.getState(r, c);
                if (st == -2) {
                    this.paintWall(g, r, c);
                } else if (st == -1) {
                    this.paintSpace(g, r, c);
                } else if (st > 0) {
                    g.setFont(this.getNumberFont());
                    g.setColor(this.getNumberColor());
                    this.placeNumber(g, r, c, st);
                } else if (st == -3) {
                    g.setColor(this.getNumberColor());
                    this.placeBoldCircle(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    void paintSpace(Graphics g, int r, int c) {
        g.setFont(this.countFont);
        Area area = this.board.getArea(r, c);
        int number = area.getNumber();
        if (this.showShimaSize) {
            if (number == 0 || number > 0 && area.size() < number || number == -3) {
                g.setColor(this.circleColor);
                this.placeCircle(g, r, c);
                this.placeNumber(g, r, c, area.size());
            } else if (number == Area.MULTIPLE_NUMBER || number > 0 && area.size() > number) {
                g.setColor(Color.RED);
                this.placeBoldCircle(g, r, c);
                this.placeNumber(g, r, c, area.size());
            } else {
                g.setColor(this.circleColor);
                this.placeFilledCircle(g, r, c);
            }
            return;
        }
        g.setColor(this.circleColor);
        this.placeFilledCircle(g, r, c);
    }

    void paintWall(Graphics g, int r, int c) {
        g.setColor(this.paintColor);
        if (this.colorForEachWall) {
            g.setColor(Colors.get(this.board.getArea(r, c).getID()));
        }
        if (this.showWrongWall && this.board.is2x2Block(r, c)) {
            g.setColor(this.errorColor);
        }
        this.paintCell(g, r, c);
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode() && num > 0) {
            this.board.changeState(pos.r, pos.c, num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.changeState(pos.r, pos.c, 0);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.changeState(pos.r, pos.c, -3);
        }
    }

    protected void leftPressed(Address pos) {
        if (this.isProblemEditMode()) {
            return;
        }
        this.board.toggleState(pos.r, pos.c, -2);
        this.currentState = this.board.isNumber(pos.r, pos.c) ? 0 : this.board.getState(pos.r, pos.c);
    }

    protected void rightPressed(Address pos) {
        if (this.isProblemEditMode()) {
            return;
        }
        this.board.toggleState(pos.r, pos.c, -1);
        this.currentState = this.board.isNumber(pos.r, pos.c) ? -1 : this.board.getState(pos.r, pos.c);
    }

    protected void leftDragged(Address dragStart, Address pos) {
        if (this.isProblemEditMode()) {
            int number;
            this.getCellCursor().setPosition(pos);
            if (this.isOn(dragStart) && ((number = this.board.getState(dragStart.r, dragStart.c)) > 0 || number == -3)) {
                this.board.changeState(dragStart.r, dragStart.c, 0);
                this.board.changeState(pos.r, pos.c, number);
            }
        } else {
            int st = this.board.getState(pos.r, pos.c);
            if (st > 0 || st == -3) {
                return;
            }
            if (st == this.currentState) {
                return;
            }
            this.board.changeStateA(pos.r, pos.c, this.currentState);
        }
    }

    protected void rightDragged(Address dragStart, Address pos) {
        if (this.isProblemEditMode()) {
            return;
        }
        int st = this.board.getState(pos.r, pos.c);
        if (st > 0 || st == -3) {
            return;
        }
        if (st == this.currentState) {
            return;
        }
        this.board.changeStateA(pos.r, pos.c, this.currentState);
    }
}

