/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shikaku;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Iterator;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandler;
import pencilbox.shikaku.Board;
import pencilbox.shikaku.Square;
import pencilbox.util.Colors;

public class Panel
extends PanelEventHandler {
    private Board board;
    private Color areaBorderColor = Color.BLUE;
    private Color errorColor = new Color(0xFF0000);
    private Color smallSizeColor = new Color(0xFFFF80);
    private Color areaPaintColor = new Color(0x80FFFF);
    private Square draggingArea;
    private boolean colorfulMode = false;
    private boolean showAreaHint = false;
    private Address dragStart = new Address(Address.NOWEHER);

    public Panel() {
        this.setGridColor(Color.GRAY);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getAreaPaintColor() {
        return this.areaPaintColor;
    }

    public void setAreaPaintColor(Color areaPaintColor) {
        this.areaPaintColor = areaPaintColor;
    }

    public void setColorfulMode(boolean colorfulMode) {
        this.colorfulMode = colorfulMode;
    }

    public void setShowAreaHint(boolean showAreaHint) {
        this.showAreaHint = showAreaHint;
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawDragging(g);
        this.drawGrid(g);
        this.drawBorder(g);
        if (this.getCellCursor() != null) {
            this.drawCursor(g);
        }
    }

    void drawBoard(Graphics g) {
        g.setColor(this.smallSizeColor);
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                Square domain = this.board.getSquare(r, c);
                if (domain != null) {
                    if (this.showAreaHint) {
                        int number = domain.getNumber();
                        if (number == -2) {
                            g.setColor(this.errorColor);
                        } else if (number == 0) {
                            g.setColor(this.smallSizeColor);
                        } else if (number == -1) {
                            g.setColor(this.areaPaintColor);
                        } else if (number < domain.getSquareSize()) {
                            g.setColor(this.errorColor);
                        } else if (number == domain.getSquareSize()) {
                            g.setColor(this.areaPaintColor);
                        } else if (number > domain.getSquareSize()) {
                            g.setColor(this.smallSizeColor);
                        }
                    } else if (this.colorfulMode) {
                        g.setColor(Colors.getBrightColor(this.board.getSquare(r, c).getId()));
                    } else {
                        g.setColor(this.areaPaintColor);
                    }
                    this.paintCell(g, r, c);
                }
                ++c;
            }
            ++r;
        }
        g.setFont(this.getNumberFont());
        g.setColor(this.getNumberColor());
        int r2 = 0;
        while (r2 < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int num = this.board.getNumber(r2, c);
                if (num > 0) {
                    this.placeNumber(g, r2, c, num);
                } else if (num == -1) {
                    this.placeNumber(g, r2, c, num);
                }
                ++c;
            }
            ++r2;
        }
        g.setColor(this.areaBorderColor);
        Iterator itr = this.board.getSquareListIterator();
        while (itr.hasNext()) {
            Square area = (Square)itr.next();
            this.placeSquare(g, area.r0, area.c0, area.r1, area.c1);
        }
    }

    public void placeNumber(Graphics g, int r, int c, int num) {
        g.setColor(Color.BLACK);
        super.placeFilledCircle(g, r, c, (int)((double)this.getCellSize() * 0.85));
        g.setColor(Color.WHITE);
        if (num > 0) {
            super.placeNumber(g, r, c, num);
        }
    }

    private void drawDragging(Graphics g) {
        Square area = this.draggingArea;
        if (area == null) {
            return;
        }
        this.placeSquare(g, area.r0, area.c0, area.r1, area.c1);
    }

    protected void leftPressed(Address pos) {
        this.dragStart.set(pos);
        this.draggingArea = new Square(this.dragStart.r, this.dragStart.c, pos.r, pos.c);
    }

    protected void rightPressed(Address dragEnd) {
        this.board.removeSquareIncluding(dragEnd);
    }

    protected void leftDragged(Address dragEnd) {
        if (this.draggingArea == null) {
            return;
        }
        this.draggingArea.set(this.dragStart.r, this.dragStart.c, dragEnd.r, dragEnd.c);
    }

    protected void leftDragFixed(Address dragEnd) {
        if (this.draggingArea == null) {
            return;
        }
        this.draggingArea = null;
        this.board.addSquareSpanning(this.dragStart, dragEnd);
        this.dragStart.setNowhere();
    }

    protected void dragFailed() {
        this.draggingArea = null;
        this.dragStart.setNowhere();
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode() && num > 0) {
            this.board.setNumber(pos.r, pos.c, num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.setNumber(pos.r, pos.c, 0);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.setNumber(pos.r, pos.c, -1);
        }
    }
}

