/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.tentaisho;

import java.awt.Color;
import java.awt.Graphics;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.CellCursor;
import pencilbox.common.gui.PanelEventHandler;
import pencilbox.tentaisho.Area;
import pencilbox.tentaisho.Board;
import pencilbox.tentaisho.TentaishoCursor;

public class Panel
extends PanelEventHandler {
    private Board board;
    private boolean showStar = true;
    private boolean showAreaBorder = true;
    private boolean showAreaHint = false;
    private Color areaBorderColor = Color.BLUE;
    private Color noStarAreaColor = new Color(0xFFFF80);
    private Color whiteAreaColor = new Color(0x80FFFF);
    private Color blackAreaColor = new Color(0xFF80FF);
    private Color starColor = Color.BLACK;
    private Color errorColor = Color.RED;
    private int halfStarSize = 4;
    private Address pos = new Address();
    private Area draggingArea;

    public Panel() {
        this.setGridColor(Color.GRAY);
        this.setMaxInputNumber(2);
        this.removeMouseHandlerCursor();
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getBlackAreaColor() {
        return this.blackAreaColor;
    }

    public void setBlackAreaColor(Color blackAreaColor) {
        this.blackAreaColor = blackAreaColor;
    }

    public Color getWhiteAreaColor() {
        return this.whiteAreaColor;
    }

    public void setWhiteAreaColor(Color whiteAreaColor) {
        this.whiteAreaColor = whiteAreaColor;
    }

    public void setShowAreaBorder(boolean showAreaBorder) {
        this.showAreaBorder = showAreaBorder;
    }

    public void setShowStar(boolean showStar) {
        this.showStar = showStar;
    }

    public void setShowAreaHint(boolean useDifferentColor) {
        this.showAreaHint = useDifferentColor;
    }

    public CellCursor createCursor() {
        return new TentaishoCursor(this);
    }

    protected void setDisplaySize(int size) {
        this.halfStarSize = size / 7 + 1;
        super.setDisplaySize(size);
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        if (this.getCellCursor() != null && this.isProblemEditMode()) {
            this.drawCursor(g);
        }
    }

    void drawBoard(Graphics g) {
        this.paintAreas(g);
        if (this.showStar) {
            this.drawStars(g);
        }
        if (this.showAreaBorder) {
            this.drawAreaBorders(g);
        }
    }

    private void paintAreas(Graphics g) {
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                if (this.board.isCovered(r, c) && this.board.getArea(r, c) != this.draggingArea) {
                    int starType = this.board.getArea(r, c).getStarType();
                    if (this.showAreaHint) {
                        if (starType == -1) {
                            g.setColor(this.errorColor);
                        } else if (starType == 1) {
                            g.setColor(this.whiteAreaColor);
                        } else if (starType == 2) {
                            g.setColor(this.blackAreaColor);
                        } else {
                            g.setColor(this.noStarAreaColor);
                        }
                    } else {
                        g.setColor(this.whiteAreaColor);
                    }
                    this.paintCell(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawStars(Graphics g) {
        g.setColor(this.starColor);
        int r = 0;
        while (r < this.board.rows() * 2 - 1) {
            int c = 0;
            while (c < this.board.cols() * 2 - 1) {
                if (this.board.hasStar(r, c)) {
                    this.placeStar(g, r, c, this.board.getStar(r, c));
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawAreaBorders(Graphics g) {
        int c;
        g.setColor(this.areaBorderColor);
        int r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols() - 1) {
                if (this.board.getArea(r, c) != this.board.getArea(r, c + 1)) {
                    this.placeSideLine(g, 0, r, c);
                }
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.board.rows() - 1) {
            c = 0;
            while (c < this.board.cols()) {
                if (this.board.getArea(r, c) != this.board.getArea(r + 1, c)) {
                    this.placeSideLine(g, 1, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    public void placeStar(Graphics g, int r, int c, int star) {
        this.pos.set(r, c);
        this.b2p(this.pos, this.board.rows() - 1, this.board.cols() - 1);
        if (star == 1) {
            g.drawOval(this.getOffsetx() + this.getHalfCellSize() * (this.pos.c + 1) - this.halfStarSize, this.getOffsety() + this.getHalfCellSize() * (this.pos.r + 1) - this.halfStarSize, this.halfStarSize * 2, this.halfStarSize * 2);
        } else if (star == 2) {
            g.fillOval(this.getOffsetx() + this.getHalfCellSize() * (this.pos.c + 1) - this.halfStarSize, this.getOffsety() + this.getHalfCellSize() * (this.pos.r + 1) - this.halfStarSize, this.halfStarSize * 2, this.halfStarSize * 2);
        }
    }

    public void drawCursor(Graphics g) {
        g.setColor(this.getCursorColor());
        g.drawRect(this.getOffsetx() + (this.getCellSize() * this.getCellCursor().c() + this.getHalfCellSize()) / 2, this.getOffsety() + (this.getCellSize() * this.getCellCursor().r() + this.getHalfCellSize()) / 2, this.getHalfCellSize(), this.getHalfCellSize());
    }

    protected void leftPressed(Address pos) {
        Area oldArea = this.board.getArea(pos.r, pos.c);
        if (this.draggingArea == null) {
            this.draggingArea = new Area();
        }
        if (oldArea != null && oldArea != this.draggingArea) {
            this.board.removeAreaA(oldArea);
        }
        this.board.setArea(pos.r, pos.c, this.draggingArea);
        this.draggingArea.add(pos);
    }

    protected void rightPressed(Address pos) {
        Area oldArea = this.board.getArea(pos.r, pos.c);
        if (oldArea != null) {
            this.board.removeAreaA(oldArea);
        }
    }

    protected void leftDragged(Address pos) {
        this.leftPressed(pos);
    }

    protected void rightDragged(Address pos) {
        this.rightPressed(pos);
    }

    protected void leftDragFixed(Address dragEnd) {
        if (this.draggingArea == null) {
            return;
        }
        this.board.addAreaA(this.draggingArea);
        this.draggingArea = null;
    }

    protected void rightDragFixed(Address dragStart, Address dragEnd) {
        this.draggingArea = null;
    }

    protected void dragFailed() {
        if (this.draggingArea == null) {
            return;
        }
        this.board.addAreaA(this.draggingArea);
        this.draggingArea = null;
    }

    protected void numberEntered(Address p, int n) {
        if (this.isProblemEditMode() && (n == 2 || n == 1)) {
            this.board.setStar(p.r, p.c, n);
        }
    }

    protected void spaceEntered(Address p) {
        if (this.isProblemEditMode()) {
            this.board.setStar(p.r, p.c, 0);
        }
    }
}

