package pencilbox.common.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

import javax.swing.JPanel;

import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Direction;
import pencilbox.common.core.Size;


/**
 * yVpYt[[ÑplNX
 * ʃpỸplNX̃X[p[NXƂȂ
 * ̃pYŋʂŗp郁\bhLqĂ
 * epYŌŗL̑̓TuNXŋLq
 */

public class PanelBase extends JPanel implements Printable {

	private Size size;

	protected BufferedImage backgroundImage;
    protected BufferedImage originalImage;
    protected AffineTransform backgroundImageTransform = AffineTransform.getRotateInstance(Math.toRadians(0.0));
    protected boolean useBackgroundImage = false;

	private int cellSize = 26;
	private int halfCellSize = cellSize / 2;
	private int circleSize = 18;
	private int crossSize = 8; // БTCY
	private int smallCrossSize = 3; // БTCY
	private int offsetx = 26;
	private int offsety = 26;

	private Color backgroundColor = Color.WHITE;
	private Color borderColor = Color.BLACK;
	private Color gridColor = Color.BLACK;
	private Color numberColor = Color.BLACK;

	private Color cursorColor = new Color(0xFF0000);
	private Color answerCursorColor = new Color(0x0000FF);

	private Font indexFont = new Font("SansSerif", Font.ITALIC, 13);
	private Font numberFont = new Font("SansSerif", Font.PLAIN, 20);

	private int displayStyle = 0;
	private boolean showIndexMode = true;
	private boolean cursorOn = false;
	private CellCursor cellCursor;

	/**
	 * true Ŗ̓[hCfalse ŉ𓚓̓[h	 
	 */
	private boolean problemEditMode = false;

	/**
	 * plRXgN^
	 */
	public PanelBase() {
		setFocusable(true);
	}
	/**
	 * pl̏ݒs
	 * Board Ɗ֘At
	 * @param board Ֆ
	 */
	public void setup(BoardBase board) {
		size = board.getSize();
		updatePreferredSize();
		setBoard(board);
		cellCursor = createCursor();
	}
	/**
	 *  J[\𐶐
	 * @return J[\
	 */
	public CellCursor createCursor() {
		return new CellCursor();
	}
	/**
	 * ʃNX̃plɌʃNX̔Ֆʂݒ肷邽߂̃\bh
	 * eʃNXŃI[o[Ch
	 * @param board Ֆ
	 */
	protected void setBoard(BoardBase board) {
	}
	/**
	 * wi摜ݒ
	 * @param image
	 */
	public void setImage(BufferedImage image) {
		this.backgroundImage = image;
		this.originalImage = image;
		repaint();
	}
	/**
	 * \TCYύX
	 * @param cellSize }X̃TCY
	 */
	protected void setDisplaySize(int cellSize) {

		this.cellSize = cellSize;
		if (showIndexMode) {
			offsetx = cellSize;
			offsety = cellSize;
		}
		setHalfCellSize(cellSize / 2);
		circleSize = (int) (cellSize * 0.7);
		crossSize = (int) (cellSize * 0.3);
		smallCrossSize = (int) (cellSize * 0.15);
		numberFont = new Font("SansSerif", Font.PLAIN, cellSize * 4 / 5);
		indexFont = new Font("SansSerif", Font.ITALIC, cellSize / 2);
		//		if (size==14){
		//		}
		//		else if (size==20) {
		//		}
		//		else if (size==26) {
		//		}
		updatePreferredSize();
		repaint();
	}
	/**
	 * r\X^C擾
	 * @return ݂̔ԍ
	 */
	protected int getDisplayStyle() {
		return displayStyle;
	}
	/**
	 * r\X^Cݒ
	 * @param i ݒ肷ԍ
	 */
	protected void setDisplayStyle(int i) {
		displayStyle = i;
	}
	/**
	 * ݂̔Ֆʂ̏Ԃɍ킹āCsetPreferredSize() s
	 */
	protected void updatePreferredSize() {
		setPreferredSize(getBoardRegionSize());
		revalidate();
	}
	/**
	 * Panel̔Ֆʗ̈敔̃TCY擾
	 */
	public Dimension getBoardRegionSize() {
		return new Dimension(
				offsetx * 2 + cellSize * cols() + 1,
				offsety * 2 + cellSize * rows() + 1);
	}
	/**
	 * ҏW\[h̐ݒs
	 * @param problemEditMode The problemEditMode to set.
	 */
	public void setProblemEditMode(boolean problemEditMode) {
		this.problemEditMode = problemEditMode;
	}
	/**
	 * @return Returns the problemEditMode.
	 */
	public boolean isProblemEditMode() {
		return problemEditMode;
	}
	/**
	 * ݂̉]Ԃɉs擾
	 * @return pl̔Ֆʂ̍s 
	 */
	public int rows() {
		return size.getRows();
	}
	/**
	 * ݂̉]Ԃɉ񐔂擾
	 * @return pl̔Ֆʂ̗
	 */
	public int cols() {
		return size.getCols();
	}

	/*
	 * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
	 */
	protected void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D) g;
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
		drawPanel(g2);
	}
	/**
	 * pl`悷B
	 * ʕ\pCpC摜쐬pŋʂɎgpB
	 * X̃TuNXŎB
	 * @param g
	 */
	public void drawPanel(Graphics2D g) {
	}
	
	protected void drawBoard(Graphics2D g) {
	}

	/**
	 * Panel̗WsNZxWɕϊ
	 * @param c Panel̗W
	 * @return ϊ̃sNZW
	 */
	public final int toX(int c) {
		return offsetx + cellSize * c;
	}
	/**
	 * Panel̗WsNZyWɕϊ
	 * @param r Panel̍sW
	 * @return ϊ̃sNZW
	 */
	public final int toY(int r) {
		return offsety + cellSize * r;
	}

	/*
	 * Ֆʈꕔ`p\bhQ
	 */
	/**
	 * Ֆʂ̔wi backgraoundColor œhԂ
	 * @param g
	 */
	public void paintBackground(Graphics2D g) {
		if (useBackgroundImage && backgroundImage != null) {
			g.drawImage(backgroundImage, backgroundImageTransform, null);
		} else {
			g.setColor(backgroundColor);
			g.fillRect(offsetx, offsety, cellSize * cols(), cellSize * rows());
		}
	}
	/**
	 * Ֆʂ̊Og`
	 * @param g
	 */
	public void drawBorder(Graphics2D g) {
		g.setColor(borderColor);
//		g.drawRect(offsetx - 2, offsety - 2, cellSize * cols() + 4,	cellSize * rows() + 4);
		g.drawRect(offsetx - 1, offsety - 1, cellSize * cols() + 2,	cellSize * rows() + 2);
		g.drawRect(offsetx, offsety, cellSize * cols(), cellSize * rows());
	}
	/**
	 * r`
	 * @param g
	 */
	public void drawGrid(Graphics2D g) {
		g.setColor(gridColor);
		for (int r = 1; r < rows(); r++) {
			g.drawLine(toX(0), toY(r), toX(cols()), toY(r));
		}
		for (int c = 1; c < cols(); c++) {
			g.drawLine(toX(c), toY(0), toX(c), toY(rows()));
		}
	}
	/**
	 * Ֆʂ̏ƍ̒[ɍW`
	 * @param g
	 */
	public void drawIndex(Graphics2D g) {
		int firstIndex = 1;
		g.setFont(indexFont);
		g.setColor(numberColor);
		if (showIndexMode == false)
			return;
		for (int r = 0; r < rows(); r++) {
			placeIndexNumber(g, r, -1, r + firstIndex);
		}
		for (int c = 0; c < cols(); c++) {
			placeIndexNumber(g, -1, c, c + firstIndex);
		}
	}
	/**
	 * J[\`
	 * @param g
	 */
	public void drawCursor(Graphics2D g) {
		if (isProblemEditMode()) {
			g.setColor(cursorColor);
		} else if (cursorOn) {
			g.setColor(answerCursorColor);
		} else {
			return;
		}
		g.drawRect(toX(cellCursor.c()), toY(cellCursor.r()), cellSize, cellSize);
		g.drawRect(toX(cellCursor.c()) + 1,	toY(cellCursor.r()) + 1, cellSize - 2, cellSize - 2);
		g.drawRect(toX(cellCursor.c()) + 2,	toY(cellCursor.r()) + 2, cellSize - 4, cellSize - 4);
	}
	/*
	 * }``̂߂̃\bhQ
	 */
	/**
	 * ̍W܂͏̒[_ƂāCẐPӂ̒Ɠ̉܂͏c̐`
	 * @param g
	 * @param x    SxW
	 * @param y    SyW
	 * @param direction c Ȃ c̐C  Ȃ ̐ 
	 */
	public void drawLineSegment(Graphics g, int x, int y, int direction) {
		if (direction == Direction.HORIZ)
			g.fillRect(x, y - 1, cellSize + 1, 3);
		else if (direction == Direction.VERT)
			g.fillRect(x - 1, y, 3, cellSize + 1);
	}
	/**
	 * ̓_𒆐SɁC̑傫̃oc`
	 * @param g
	 * @param x    SxW
	 * @param y    SyW
	 * @param halfSize 傫iБj
	 */
	public void drawCross(Graphics g, int x, int y, int halfSize) {
		g.drawLine(x - halfSize, y - halfSize, x + halfSize, y + halfSize);
		g.drawLine(x - halfSize, y + halfSize, x + halfSize, y - halfSize);
	}
	/**
	 * ̍W𒆐SƂāCẐPӂ̒Ɠ̉܂͏c̐`
	 * @param g
	 * @param x
	 * @param y
	 * @param direction
	 */
	public void drawMidline(Graphics g, int x, int y, int direction) {
		int length = getHalfCellSize();
		if (direction == Direction.HORIZ)
			g.drawLine(x - length, y, x + length, y);
		else if (direction == Direction.VERT)
			g.drawLine(x, y - length, x, y + length);
	}
	/**
	 * ̍W𒆐SƂāCẐPӂ̒Ɠő3̉܂͏c̐`
	 * @param g
	 * @param x
	 * @param y
	 * @param direction
	 */
	public void drawMidline3(Graphics g, int x, int y, int direction) {
		int length = getHalfCellSize();
		if (direction == Direction.HORIZ) {
			g.drawLine(x - length, y - 1, x + length, y - 1);
			g.drawLine(x - length, y, x + length, y);
			g.drawLine(x - length, y + 1, x + length, y + 1);
		} else if (direction == Direction.VERT) {
			g.drawLine(x - 1, y - length, x - 1, y + length);
			g.drawLine(x, y - length, x, y + length);
			g.drawLine(x + 1, y - length, x + 1, y + length);
		}
	}

	/*
	 * }X̓e`悷邽߂̃\bhQ
	 * }X̍W^ƁC̃Z̓e`悷D
	 * ȉ̃\bhpӂĂ
	 * `
	 * hԂ
	 * `
	 * `
	 * ~`
	 * ܂͏c`
	 */
	/**
	 * }Xɕzu
	 * @param g
	 * @param r Ֆʏ̍sW
	 * @param c Ֆʏ̗W
	 * @param letter `
	 */
	public void placeLetter(Graphics2D g, int r, int c, char letter) {
		FontMetrics metrics = g.getFontMetrics();
		try {
			String string = Character.toString(letter);
			g.drawString(
				string,
				(toX(c)
					+ (cellSize - 1 - metrics.stringWidth(string)) / 2
					+ 1),
				(toY(r)
					+ (cellSize - 1 - metrics.getHeight()) / 2
					+ metrics.getAscent())
					+ 1);
		} catch (NumberFormatException e) {
			e.printStackTrace();
		}
	}
	/**
	 * }Xɐzu
	 * @param g
	 * @param r Ֆʏ̍sW
	 * @param c Ֆʏ̗W
	 * @param number `
	 */
	public void placeNumber(Graphics2D g, int r, int c, int number) {
		FontMetrics metrics = g.getFontMetrics();
		try {
			String numS = Integer.toString(number);
			g.drawString(
				numS,
				(toX(c)
					+ (cellSize - 1 - metrics.stringWidth(numS)) / 2
					+ 1),
				(toY(r)
					+ (cellSize - 1 - metrics.getHeight()) / 2
					+ metrics.getAscent())
					+ 1);
		} catch (NumberFormatException e) {
			e.printStackTrace();
		}
	}
	/**
	 * }Xɐzu
	 * @param g
	 * @param r Ֆʏ̍sW
	 * @param c Ֆʏ̗W
	 * @param number `
	 */
	public void placeIndexNumber(Graphics2D g, int r, int c, int number) {
		FontMetrics metrics = g.getFontMetrics();
		try {
			String numS = Integer.toString(number);
			g.drawString(
				numS,
				(toX(c)
					+ (cellSize - 1 - metrics.stringWidth(numS)) / 2
					+ 1),
				(toY(r)
					+ (cellSize - 1 - metrics.getHeight()) / 2
					+ metrics.getAscent())
					+ 1);
		} catch (NumberFormatException e) {
			e.printStackTrace();
		}
	}

	/**
	 * }XhԂ
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 */
	public void paintCell(Graphics2D g, int r, int c) {
		g.fillRect(
			toX(c) + 1,
			toY(r) + 1,
			cellSize - 1,
			cellSize - 1);
	}

	/**
	 * }XɁzu
	 * 傫̓NXŒ߂Wl
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 */
	public void placeCircle(Graphics2D g, int r, int c) {
		g.drawOval(
			toX(c) + (cellSize - circleSize) / 2,
			toY(r) + (cellSize - circleSize) / 2,
			circleSize,
			circleSize);
	}
	/**
	 * }XɁzu
	 * 傫Ŏw肷
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 * @param circleSize zu遛̒a
	 */
	public void placeCircle(Graphics2D g, int r, int c, int circleSize) {
		g.drawOval(
			toX(c) + (cellSize - circleSize) / 2,
			toY(r) + (cellSize - circleSize) / 2,
			circleSize,
			circleSize);
	}
	/**
	 * }XɁzu
	 * 傫̓Zɓڂ傫Ƃ
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 */
	public void placeLargeCircle(Graphics2D g, int r, int c) {
		placeCircle(g, r, c, cellSize - 2);
	}
	/**
	 * }Xɐ2́zu
	 * 傫̓NXŒ߂Wl
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 */
	public void placeBoldCircle(Graphics2D g, int r, int c) {
		int x = toX(c) + (cellSize - circleSize) / 2;
		int y = toY(r) + (cellSize - circleSize) / 2;
		g.drawOval(x, y, circleSize, circleSize);
		g.drawOval(x + 1, y + 1, circleSize - 2, circleSize - 2);
	}
	/**
	 * }Xɐ2́zu
	 * 傫Ŏw肷
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 * @param circleSize zu遛̒a
	 */
	public void placeBoldCircle(Graphics2D g, int r, int c, int circleSize) {
		int x = toX(c) + (cellSize - circleSize) / 2;
		int y = toY(r) + (cellSize - circleSize) / 2;
		g.drawOval(x, y, circleSize, circleSize);
		g.drawOval(x + 1, y + 1, circleSize - 2, circleSize - 2);
	}
	/**
	 * }XɓhԂzu
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 */
	public void placeFilledCircle(Graphics2D g, int r, int c) {
		g.fillOval(
			toX(c) + (cellSize - circleSize) / 2,
			toY(r) + (cellSize - circleSize) / 2,
			circleSize + 1,
			circleSize + 1);
	}
	/**
	 * }Xɓڂ傫̓hԂzu
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 */
	public void placeLargeFilledCircle(Graphics2D g, int r, int c) {
		placeFilledCircle(g, r, c, cellSize - 2);
	}
	/**
	 * }XɓhԂzu
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 * @param circleSize zu遜̒a
	 */
	public void placeFilledCircle(Graphics2D g, int r, int c, int circleSize) {
		g.fillOval(
			toX(c) + (cellSize - circleSize) / 2,
			toY(r) + (cellSize - circleSize) / 2,
			circleSize + 1,
			circleSize + 1);
	}
	/**
	 * }XɁ~zu
	 * @param g
	 * @param r ՖʍsW
	 * @param c ՖʗW
	 */
	public void placeCross(Graphics2D g, int r, int c) {
		drawCross(
			g,
			toX(c) + getHalfCellSize(),
			toY(r) + getHalfCellSize(),
			crossSize);
	}
	/**
	 * ӏɐzu
	 * @param g
	 * @param d
	 * @param r
	 * @param c
	 */
	public void placeSideLine(Graphics2D g, int d, int r, int c) {
		drawLineSegment(
			g,
			toX(c + (d ^ 1)),
			toY(r + d),
			d);
	}
	/**
	 * ӂƌzu
	 * @param g
	 * @param d
	 * @param r
	 * @param c
	 */
	public void placeTraversalLine(Graphics2D g, int d, int r, int c) {
		drawLineSegment(
			g,
			toX(c) + getHalfCellSize(),
			toY(r) + getHalfCellSize(),
			d ^ 1);
	}
	/**
	 * ӏɁ~zu
	 * @param g
	 * @param d
	 * @param r
	 * @param c
	 */
	public void placeSideCross(Graphics2D g, int d, int r, int c) {
		if (d == Direction.VERT)
			drawCross(
				g,
				toX(c + 1),
				toY(r) + getHalfCellSize(),
				smallCrossSize);
		else if (d == Direction.HORIZ)
			drawCross(
				g,
				toX(c) + getHalfCellSize(),
				toY(r + 1),
				smallCrossSize);
	}
	/**
	 * }X̒Sɉ܂͏c̐zu
	 * @param g
	 * @param r
	 * @param c
	 * @param dir
	 */
	public void placeMidline(Graphics2D g, int r, int c, int dir) {
		drawMidline(
			g,
			toX(c) + getHalfCellSize(),
			toY(r) + getHalfCellSize(),
			dir);
	}
	/**
	 * lpzu 
	 * @param g 
	 * @param r0 ՖʍsW
	 * @param c0 ՖʗW
	 * @param r1 ՖʍsW
	 * @param c1 ՖʗW
	 */
	public void placeSquare(Graphics2D g, int r0, int c0, int r1, int c1) {
		g.drawRect(
			toX((c0 < c1) ? c0 : c1) + 1,
			toY((r0 < r1) ? r0 : r1) + 1,
			cellSize * (((c0 < c1) ? c1-c0 : c0-c1) + 1) - 2,
			cellSize * (((r0 < r1) ? r1-r0 : r0-r1) + 1) - 2);
	}

	/* 
	 * Ֆʈp\bh
	 * @see java.awt.print.Printable#print(java.awt.Graphics, java.awt.print.PageFormat, int)
	 */
	public int print(Graphics g, PageFormat pf, int page)
		throws PrinterException {
		if (page >= 1)
			return Printable.NO_SUCH_PAGE;
		Graphics2D g2 = (Graphics2D) g;
		g2.translate(pf.getImageableX(), pf.getImageableY());
		// \\̈̍pW_ƂDcoreJAVA v.2 p.652
		g2.scale(0.7, 0.7); // ͏k 1pixel -> 0.7point
		//		  g2.draw(new Rectangle2D.Double(0, 0, pf.getImageableWidth(), pf.getImageableHeight()));
		drawPanel(g2);
		return Printable.PAGE_EXISTS;
	}
	/**
	 * @param cellSize The cellSize to set.
	 */
	public void setCellSize(int cellSize) {
		this.cellSize = cellSize;
	}
	/**
	 * @return Returns the cellSize.
	 */
	public int getCellSize() {
		return cellSize;
	}
	/**
	 * @param halfCellSize The halfCellSize to set.
	 */
	public void setHalfCellSize(int halfCellSize) {
		this.halfCellSize = halfCellSize;
	}
	/**
	 * @return Returns the halfCellSize.
	 */
	public int getHalfCellSize() {
		return halfCellSize;
	}
	/**
	 * @param circleSize The circleSize to set.
	 */
	public void setCircleSize(int circleSize) {
		this.circleSize = circleSize;
	}
	/**
	 * @return Returns the circleSize.
	 */
	public int getCircleSize() {
		return circleSize;
	}
	/**
	 * @param crossSize The crossSize to set.
	 */
	public void setCrossSize(int crossSize) {
		this.crossSize = crossSize;
	}
	/**
	 * @return Returns the crossSize.
	 */
	public int getCrossSize() {
		return crossSize;
	}
	/**
	 * @param smallCrossSize The smallCrossSize to set.
	 */
	public void setSmallCrossSize(int smallCrossSize) {
		this.smallCrossSize = smallCrossSize;
	}
	/**
	 * @return Returns the smallCrossSize.
	 */
	public int getSmallCrossSize() {
		return smallCrossSize;
	}
	/**
	 * @param offsetx The offsetx to set.
	 */
	public void setOffsetx(int offsetx) {
		this.offsetx = offsetx;
	}
	/**
	 * @return Returns the offsetx.
	 */
	public int getOffsetx() {
		return offsetx;
	}
	/**
	 * @param offsety The offsety to set.
	 */
	public void setOffsety(int offsety) {
		this.offsety = offsety;
	}
	/**
	 * @return Returns the offsety.
	 */
	public int getOffsety() {
		return offsety;
	}
	/**
	 * @param backgroundColor The backgroundColor to set.
	 */
	public void setBackgroundColor(Color backgroundColor) {
		this.backgroundColor = backgroundColor;
	}
	/**
	 * @return Returns the backgroundColor.
	 */
	public Color getBackgroundColor() {
		return backgroundColor;
	}
	/**
	 * @param borderColor The borderColor to set.
	 */
	public void setBorderColor(Color borderColor) {
		this.borderColor = borderColor;
	}
	/**
	 * @return Returns the borderColor.
	 */
	public Color getBorderColor() {
		return borderColor;
	}
	/**
	 * @param gridColor The gridColor to set.
	 */
	public void setGridColor(Color gridColor) {
		this.gridColor = gridColor;
	}
	/**
	 * @return Returns the gridColor.
	 */
	public Color getGridColor() {
		return gridColor;
	}
	/**
	 * @param numberColor The numberColor to set.
	 */
	public void setNumberColor(Color numberColor) {
		this.numberColor = numberColor;
	}
	/**
	 * @return Returns the numberColor.
	 */
	public Color getNumberColor() {
		return numberColor;
	}
	/**
	 * @param cursorColor The cursorColor to set.
	 */
	public void setCursorColor(Color cursorColor) {
		this.cursorColor = cursorColor;
	}
	/**
	 * @return Returns the cursorColor.
	 */
	public Color getCursorColor() {
		return cursorColor;
	}
	/**
	 * @param cursorOn The cursorOn to set.
	 */
	public void setCursorOn(boolean cursorOn) {
		this.cursorOn = cursorOn;
	}
	/**
	 * @return Returns the cursorOn.
	 */
	public boolean isCursorOn() {
		return cursorOn;
	}
	/**
	 * @param numberFont The numberFont to set.
	 */
	protected void setNumberFont(Font numberFont) {
		this.numberFont = numberFont;
	}
	/**
	 * @return Returns the numberFont.
	 */
	protected Font getNumberFont() {
		return numberFont;
	}
	/**
	 * @param cellCursor The cellCursor to set.
	 */
	protected void setCellCursor(CellCursor cellCursor) {
		this.cellCursor = cellCursor;
	}
	/**
	 * @return Returns the cellCursor.
	 */
	protected CellCursor getCellCursor() {
		return cellCursor;
	}
	/**
	 * @return the showIndex
	 */
	public boolean isShowIndexMode() {
		return showIndexMode;
	}
	/**
	 * @param showIndex the showIndex to set
	 */
	public void setShowIndexMode(boolean showIndex) {
		this.showIndexMode = showIndex;
	}

	/**
	 * @param b the showIndex to set
	 */
	public void changeShowIndexMode(boolean b) {
		this.showIndexMode = b;
		if (b == true) {
			setOffsetx(this.getCellSize());
			setOffsety(this.getCellSize());
		} else {
			setOffsetx(5);
			setOffsety(5);
		}
		updatePreferredSize();
	}
}

