package pencilbox.common.gui;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Direction;
import pencilbox.common.core.SideAddress;

/**
 * plɑ΂}EXCL[{[h̃CxgsNX
 */
public class PanelEventHandlerBase {

	private PanelBase panel;
	private BoardBase board;

	private KeyHandler keyHandler = new KeyHandler();
	private MouseHandler mouseHandler = new MouseHandler();
	private MouseHandlerEdge mouseHandlerEdge = new MouseHandlerEdge();

	private int maxInputNumber = 99;
	private int previousInput = 0;
	private int symmetricPlacementMode = 0;

	/**
	 * PanelEventHandler𐶐
	 */
	public PanelEventHandlerBase() {
	}

	public void setup(PanelBase panel, BoardBase board) {
		this.panel = panel;
		this.board = board;
		setBoard(board);
		panel.addKeyListener(keyHandler);
		panel.addMouseListener(mouseHandler);
		panel.addMouseMotionListener(mouseHandler);
		panel.addMouseListener(mouseHandlerEdge);
	}

	public void setup(BoardBase board) {
		this.board = board;
		setBoard(board);
		getCellCursor().resetPosition();
		resetPreviousInput();
	}

	/**
	 * ʃNX̃plɌʃNX̔Ֆʂݒ肷邽߂̃\bh
	 * eʃNXŃI[o[Ch
	 * @param board Ֆ
	 */
	protected void setBoard(BoardBase board) {
	}

	public PanelBase getPanel() {
		return panel;
	}

	/**
	 * @return the symmetricPlacementMode
	 */
	public boolean isSymmetricPlacementMode() {
		return symmetricPlacementMode == 1 ? true : false;
	}
	/**
	 * @param symmetricPlacementMode the symmetricPlacementMode to set
	 */
	public void setSymmetricPlacementMode(boolean symmetricPlacementMode) {
		this.symmetricPlacementMode = symmetricPlacementMode ? 1 : 0;
	}

	/**
	 * ͉\ȍő吔ݒ肷
	 * @param number ݒ肷鐔l
	 */
	protected void setMaxInputNumber(int number) {
		maxInputNumber = number;
	}
	/**
	 * ͐̈ꎞLNA
	 */
	public void resetPreviousInput() {
		previousInput = 0;
	}

	public int getCellSize() {
		return panel.getCellSize();
	}

	public int getHalfCellSize() {
		return panel.getHalfCellSize();
	}

	public int getOffsetx() {
		return panel.getOffsetx();
	}

	public int getOffsety() {
		return panel.getOffsety();
	}

	public boolean isProblemEditMode() {
		return panel.isProblemEditMode();
	}

	public void setProblemEditMode(boolean b) {
		panel.setProblemEditMode(b);
		resetPreviousInput();
	}

	public CellCursor getCellCursor() {
		return panel.getCellCursor();
	}

	public boolean isCursorOn() {
		return panel.isCursorOn();
	}

	public void repaint() {
		panel.repaint();
	}

	public boolean isOn(Address position) {
		return board.isOn(position);
	}

//	public boolean isOn(int r, int c, int adjustRow, int adjustCol) {
//		return board.isOn(r, c, adjustRow, adjustCol);
//	}

	public boolean isSideOn(SideAddress position) {
		return board.isSideOn(position);
	}

	/**
	 * J[\WՖʏɂ邩B
	 * ʏ #isOn(Address) ƓʂԂB
	 * SL, TS J[\̍WnقȂ^Cvł́CTuNXōĒ`B
	 * @param position J[\W
	 * @return J[\WՖʏɂ true
	 */
	public boolean isCursorOnBoard(Address position) {
		return board.isOn(position);
	}

	/**
	 * PanelxsNZWPanel̗}XWɕϊ
	 * @param x Panel̃sNZWx
	 * @return xPanelWɕϊl
	 */
	public final int toC(int x) {
		return (x + getCellSize() - getOffsetx()) / getCellSize() - 1;
	}
	/**
	 * Panel̂sNZWPanel̍s}XWɕϊ
	 * @param y Panel̃sNZWy
	 * @return yPanelWɕϊl
	 */
	public final int toR(int y) {
		return (y + getCellSize() - getOffsety()) / getCellSize() - 1;
	}

	/**
	 * _Ώ̈ʒu̍W擾B
	 * @param pos@W
	 * @return posƓ_Ώ̂Ȉʒu̍W
	 */
	public Address getSymmetricPosition(Address pos) {
		return new Address(board.rows()-1-pos.r(), board.cols()-1-pos.c());
	}

	/**
	 * L[Xi[
	 */
	public class KeyHandler implements KeyListener {

		public void keyPressed(KeyEvent e) {
			int keyCode = e.getKeyCode();
			switch (keyCode) {
			case KeyEvent.VK_SLASH:
			case KeyEvent.VK_DIVIDE:
				slashKeyEntered();
				break;
			case KeyEvent.VK_LEFT: // 0x25
				arrowKeyEntered(Direction.LT);
				break;
			case KeyEvent.VK_UP: // 0x26
				arrowKeyEntered(Direction.UP);
				break;
			case KeyEvent.VK_RIGHT: // 0x27
				arrowKeyEntered(Direction.RT);
				break;
			case KeyEvent.VK_DOWN: // 0x28
				arrowKeyEntered(Direction.DN);
				break;
			case KeyEvent.VK_SPACE:
			case KeyEvent.VK_PERIOD:
			case KeyEvent.VK_DECIMAL:
				spaceKeyEntered();
				break;
			case KeyEvent.VK_MINUS:
			case KeyEvent.VK_SUBTRACT:
				minusKeyEntered();
				break;
			case KeyEvent.VK_SEMICOLON:
			case KeyEvent.VK_ADD:
				break;
			case KeyEvent.VK_COLON:
			case KeyEvent.VK_MULTIPLY:
				break;
			case KeyEvent.VK_0:
			case KeyEvent.VK_NUMPAD0:
				numberKeyEntered(0);
				break;
			case KeyEvent.VK_1:
			case KeyEvent.VK_NUMPAD1:
				numberKeyEntered(1);
				break;
			case KeyEvent.VK_2:
			case KeyEvent.VK_NUMPAD2:
				numberKeyEntered(2);
				break;
			case KeyEvent.VK_3:
			case KeyEvent.VK_NUMPAD3:
				numberKeyEntered(3);
				break;
			case KeyEvent.VK_4:
			case KeyEvent.VK_NUMPAD4:
				numberKeyEntered(4);
				break;
			case KeyEvent.VK_5:
			case KeyEvent.VK_NUMPAD5:
				numberKeyEntered(5);
				break;
			case KeyEvent.VK_6:
			case KeyEvent.VK_NUMPAD6:
				numberKeyEntered(6);
				break;
			case KeyEvent.VK_7:
			case KeyEvent.VK_NUMPAD7:
				numberKeyEntered(7);
				break;
			case KeyEvent.VK_8:
			case KeyEvent.VK_NUMPAD8:
				numberKeyEntered(8);
				break;
			case KeyEvent.VK_9:
			case KeyEvent.VK_NUMPAD9:
				numberKeyEntered(9);
				break;
			}
			repaint();
		}

		public void keyTyped(KeyEvent e) {
		}

		public void keyReleased(KeyEvent e) {
		}
	}
	/**
	 * L[͂B ̕ɃJ[\ړB
	 */
	protected void arrowKeyEntered(int direction) {
		if (!isProblemEditMode() && !isCursorOn())
			return;
		Address pos = getCellCursor().getPosition();
		pos.move(direction);
		if (isCursorOnBoard(pos)) {
			getCellCursor().setPosition(pos);
			resetPreviousInput();
		}
	}
	/**
	 * L[͂B 
	 * 0-9 ̐L[͂ꂽƂɁC󋵂ɉ2̐ɂ numberEntered\bhɓn
	 */
	protected void numberKeyEntered(int number) {
		if (!isProblemEditMode() && !isCursorOn())
			return;
		Address pos = getCellCursor().getPosition();
		if (previousInput >= 1 && previousInput <= 9) {
			if (previousInput * 10 + number <= maxInputNumber) {
				number = previousInput * 10 + number;
			}
			if (number <= maxInputNumber) {
				numberEntered(pos, number);
				previousInput = 0;
			}
		} else {
			if (number <= maxInputNumber) {
				numberEntered(pos, number);
				previousInput = number;
			}
		}
	}
	/**
	 * ͂B
	 * eTuNXŎB
	 * @param pos ͂}X̍W
	 * @param num ͂
	 */
	protected void numberEntered(Address pos, int num) {
	}
	/**
	 * sIhL[̓͂B
	 * eTuNXŎB
	 * @param pos ̓}X̍W
	 */
	protected void spaceEntered(Address pos) {
	}

	protected void spaceKeyEntered() {
		Address pos = getCellCursor().getPosition();
		spaceEntered(pos);
	}

	/**
	 * }CiXL[̓͂B
	 * eTuNXŎB
	 * @param pos ̓}X̍W
	 */
	protected void minusEntered(Address pos) {
	}

	protected void minusKeyEntered() {
		Address pos = getCellCursor().getPosition();
		minusEntered(pos);
	}

	/**
	 * XbVL[̓͂B
	 * u̓[hvƁu𓚃[hv؂ւ
	 */
	protected void slashKeyEntered() {
		if (isProblemEditMode())
			board.initBoard();
		setProblemEditMode(!isProblemEditMode());
	}

	/**
	 * }EXXi[̋ʃX[p[NX
	 * }EXƂChbO܂ܐV}XɈړƂChbOIƂ̓`ĂB
	 */
	public class MouseHandler implements MouseListener, MouseMotionListener {

		private Address oldPos = new Address(-1, -1);
		private Address newPos = new Address(-1, -1);

		public void mousePressed(MouseEvent e) {

			newPos.set(toR(e.getY()), toC(e.getX()));
			if (!isOn(newPos))
				return;
			int modifier = e.getModifiers();
			if ((modifier & InputEvent.BUTTON1_MASK) != 0) {
				if ((e.getModifiersEx() & InputEvent.SHIFT_DOWN_MASK) != 0)
					leftPressedShift(newPos);
				else
					leftPressed(newPos);
			} else if ((modifier & InputEvent.BUTTON3_MASK) != 0) {
				rightPressed(newPos);
			}
			moveCursor(newPos);

			oldPos.set(newPos); // ݈ʒuXV
			repaint();
		}

		public void mouseDragged(MouseEvent e) {

			newPos.set(toR(e.getY()), toC(e.getX()));
			if (!isOn(newPos)) {
				oldPos.setNowhere();
				// ̕ȂƁCՊOoRhbOȂ ĂȂĂ
				return;
			}

			if (newPos.equals(oldPos))
				return; // }XɎ~܂Cxg͖
			// if (!newPos.isNextTo(oldPos)) return; // אڃ}XȊÕCxg͖
			// if (dragIneffective(oldPos, newPos)) return; // אڃ}XȊÕCxg͖

			if ((e.getModifiers() & InputEvent.BUTTON1_MASK) != 0) {
				leftDragged(oldPos, newPos);
			} else if ((e.getModifiers() & InputEvent.BUTTON3_MASK) != 0) {
				rightDragged(oldPos, newPos);
			}
			moveCursor(newPos);
			oldPos.set(newPos); // ݈ʒuXV
			repaint();
		}

		public void mouseReleased(MouseEvent e) {

			if (!isOn(oldPos)) {
				dragFailed();
				repaint();
				return;
			}
			if ((e.getModifiers() & InputEvent.BUTTON1_MASK) != 0) {
				leftDragFixed(oldPos);
			} else if ((e.getModifiers() & InputEvent.BUTTON3_MASK) != 0) {
				rightDragFixed(oldPos);
			}
			repaint();
		}

		public void mouseExited(MouseEvent e) {
		}

		public void mouseEntered(MouseEvent e) {
		}

		public void mouseClicked(MouseEvent e) {
			if (!isOn(newPos))
				return;
			int modifier = e.getModifiers();
			if ((modifier & InputEvent.BUTTON1_MASK) != 0) {
				if ((e.getModifiersEx() & InputEvent.SHIFT_DOWN_MASK) != 0)
					leftClickedShift(newPos);
				else
					leftClicked(newPos);
			} else if ((modifier & InputEvent.BUTTON3_MASK) != 0) {
				rightClicked(newPos);
			}
			repaint();
		}

		public void mouseMoved(MouseEvent e) {
			// movePos.set(toR(e.getY()), toC(e.getX()));
			// if (!isOn(movePos))
			// return;
			// mouseMovedTo(movePos);
			// repaint();
		}
	}

	/**
	 * {^ꂽƂɌĂ΂B
	 * TuNXőI[o[ChD
	 * @param position
	 */
	protected void leftPressed(Address position) {
	}

	protected void leftPressedShift(Address position) {
	}

	protected void leftClicked(Address position) {
	}

	protected void leftClickedShift(Address position) {
	}
	/**
	 * hbO܂܂V}XɈړƂɌĂ΂D
	 * KvɉăTuNXőI[o[ChD
	 * @param position
	 */
	protected void leftDragged(Address position) {
		// leftPressed(position);
	}

	protected void leftDragged(Address oldPos, Address position) {
		leftDragged(position);
	}

	/**
	 * }EX{^𗣂čhbOm肵ƂɌĂ΂B
	 * TuNXŃI[o[ChB
	 * @param dragEnd
	 */
	protected void leftDragFixed(Address dragEnd) {
	}
	/**
	 * E{^ꂽƂCEhbO܂܂V}XɈړƂɌĂ΂B
	 * TuNXőI[o[ChB
	 * @param position
	 */
	protected void rightPressed(Address position) {
	}

	protected void rightClicked(Address position) {
	}
	/**
	 * EhbO܂܂V}XɈړƂɌĂ΂B 
	 * TuNXőI[o[ChD
	 * @param position
	 */
	protected void rightDragged(Address position) {
		// rightPressed(position);
	}

	protected void rightDragged(Address oldPos, Address position) {
		rightDragged(position);
	}
	/**
	 * E}EX{^𗣂ĉEhbOm肵ƂɌĂ΂B
	 * TuNXŃI[o[ChB
	 * @param dragEnd
	 */
	protected void rightDragFixed(Address dragEnd) {
	}
	/**
	 * ՓŃhbOJnՊOŃhbOIƂɌĂ΂B
	 * KvɉTuNXŃhbǑnB
	 */
	protected void dragFailed() {
	}

	/**
	 * }EXŃJ[\ړB
	 *@param pos
	 */
	protected void moveCursor(Address position) {
		getCellCursor().setPosition(position);
		resetPreviousInput();
	}

	/**
	 * SL, MS p
	 * ӂ̑spYp̃}EXXi[̋ʃX[p[NXB
	 */
	public class MouseHandlerEdge implements MouseListener {

		private SideAddress position = new SideAddress();

		public void mousePressed(MouseEvent e) {
		}

		public void mouseReleased(MouseEvent e) {
		}

		public void mouseExited(MouseEvent e) {
		}

		public void mouseEntered(MouseEvent e) {
		}

		public void mouseClicked(MouseEvent e) {

			int x = e.getX();
			int y = e.getY();

			if ((((y - getOffsety()) - (x - getOffsetx()) + board.cols() * getCellSize() * 2) / getCellSize()
					+ ((y - getOffsety()) + (x - getOffsetx()))	/ getCellSize())
					% 2 == 0) {
				position.set(Direction.VERT, toR(y), toC(x - getHalfCellSize())); // c̕ӏ
			} else {
				position.set(Direction.HORIZ, toR(y - getHalfCellSize()), toC(x)); // ̕ӏ
			}
			if (!isSideOn(position))
				return;
			int modifier = e.getModifiers();
			if ((modifier & InputEvent.BUTTON1_MASK) != 0) {
				if ((e.getModifiersEx() & InputEvent.SHIFT_DOWN_MASK) != 0)
					leftClickedShiftEdge(position);
				else
					leftClickedEdge(position);
			} else if ((modifier & InputEvent.BUTTON3_MASK) != 0) {
				rightClickedEdge(position);
			}
			repaint();
		}
	}

	protected void leftClickedEdge(SideAddress position) {
	}

	protected void leftClickedShiftEdge(SideAddress position) {
	}

	protected void rightClickedEdge(SideAddress position) {
	}

}
