package pencilbox.bijutsukan;

import java.awt.Color;

import javax.swing.JMenuItem;

import pencilbox.common.gui.MenuBase;

/**
 * upفvj[NX
 */
public class Menu extends MenuBase {

	private JMenuItem bulbColorItem;
	private JMenuItem noBulbColorItem;
	private JMenuItem lluminatedCellColorItem;
	private JMenuItem wallColorItem;
	private JMenuItem numberColorItem;
	private JMenuItem indicateErrorItem;
	private JMenuItem paintIlluminatedCellItem;
	private JMenuItem showBeamItem;

	public Panel getPanel() {
		return (Panel) getPanelBase();
	}

	protected void buildEditMenu() {
		addSymmetricPlacementMenuItem();
		addTrimAnswerMenuItem();
		super.buildEditMenu();
	}

	protected void buildViewMenu() {
		buildMarkStyleMenu("ƖȂ̈(N)", 'N', new int[] {3, 4});
		super.buildViewMenu();
		wallColorItem = addColorMenuItem("}X");
		numberColorItem = addColorMenuItem("");
		bulbColorItem = addColorMenuItem("Ɩ");
		noBulbColorItem = addColorMenuItem("ƖȂ");
		lluminatedCellColorItem = addColorMenuItem("Ƃ炳ꂽ}X");
		addToViewMenu(indicateErrorItem = makeCheckBoxCommandMenuItem("ԂŎ(E)", 'E', false));
		addToViewMenu(paintIlluminatedCellItem = makeCheckBoxCommandMenuItem("Ƃ炳ꂽ}Xh(P)", 'P', true));
		addToViewMenu(showBeamItem = makeCheckBoxCommandMenuItem("\(B)", 'B', false));
	}

	public void executeCommand2(JMenuItem target) {
		if (target == indicateErrorItem) {
			getPanel().setIndicateErrorMode(target.isSelected());
		} else if (target == paintIlluminatedCellItem) {
			getPanel().setPaintIlluminatedCellMode(target.isSelected());
		} else if (target == showBeamItem) {
			getPanel().setShowBeamMode(target.isSelected());
		}
	}

	public Color getColor(JMenuItem target) {
		if (target == bulbColorItem)
			return getPanel().getBulbColor();
		else if (target == noBulbColorItem)
			return getPanel().getNoBulbColor();
		else if (target == lluminatedCellColorItem)
			return getPanel().getIlluminatedCellColor();
		else if (target == wallColorItem)
			return getPanel().getWallColor();
		else if (target == numberColorItem)
			return getPanel().getNumberColor();
		else
			return super.getColor(target);
		}

	public void setColor(JMenuItem target, Color color) {
		if (target == bulbColorItem)
			getPanel().setBulbColor(color);
		else if (target == noBulbColorItem)
			getPanel().setNoBulbColor(color);
		else if (target == lluminatedCellColorItem)
			getPanel().setIlluminatedCellColor(color);
		else if (target == wallColorItem)
			getPanel().setWallColor(color);
		else if (target == numberColorItem)
			getPanel().setNumberColor(color);
		else
			super.setColor(target, color);
	}

	public void updateCurrentMenuSelection() {
		super.updateCurrentMenuSelection();
		indicateErrorItem.setSelected(getPanel().isIndicateErrorMode());
		paintIlluminatedCellItem.setSelected(getPanel().isPaintIlluminatedCellMode());
		showBeamItem.setSelected(getPanel().isShowBeamMode());
	}

}
