/**
 * 
 */
package pencilbox.common.factory;

import pencilbox.common.core.Size;


/**
 * pY̎ނ\萔`NX
 * e萔ɂ́CtpbP[WƓ{^Cg`Ă
 */
public final class PencilType {
	
	/**
	 * pYނ̃Xg
	 */
	private static final PencilType[] pencilTypeList = new PencilType[] {
		new PencilType("kakuro",      "JbN",         12),
		new PencilType("kurodoko",    "}X͂ǂ",    9),
		new PencilType("shikaku",     "lpɐ؂",       10),
		new PencilType("sudoku",      "",              9),
		new PencilType("slitherlink", "XU[N",   11),
		new PencilType("tentaisho",   "ṼV[",       10),
		new PencilType("numberlink",  "io[N",   10),
		new PencilType("nurikabe",    "ʂ肩",         10),
		new PencilType("hakyukoka",   "gy",         10),
		new PencilType("hashi",       "",        9),
		new PencilType("bijutsukan",  "p",           10),
		new PencilType("hitori",      "ЂƂɂĂ",  8),
		new PencilType("fillomino",   "tBI~m",     10),
		new PencilType("heyawake",    "ւ킯",         10),
		new PencilType("masyu",       "܂",           10),
		new PencilType("yajilin",     "W",         10),
		new PencilType("lits",     "khsr",         10),
	};
	/**
	 * ݂PencilTypě擾
	 * @return PencilTypě
	 */
	public static int getNPencilType() {
		return pencilTypeList.length;
	}
	/**
	 * ԍɑΉPencilTypeCX^X擾
	 * @param i ԍ
	 * @return PencilTypeCX^X
	 */
	public static PencilType getPencilType(int i) {
		if (i >= 0 && i < pencilTypeList.length)
			return pencilTypeList[i];
//		O𓊂ׂ
		return null;
	}
	/**
	 * pbP[WΉPencilTypeCX^X擾
	 * @param name pacage̕
	 * @return PencilTypeCX^X
	 */
	public static PencilType getPencilType(String name) {
		for (int i = 0; i < pencilTypeList.length; i++) {
			if(pencilTypeList[i].getPencilName().equals(name))
				return pencilTypeList[i];
		}
//		O𓊂ׂ
		return null;
	}

	/**
	 * 
	 */
	private PencilType() {
	}
	/**
	 * @param pencilName
	 * @param title
	 * @param defaultSize
	 */
	private PencilType(String pencilName, String title, int defaultSize) {
		this.pencilName = pencilName;
		this.title = title;
		this.defaultSize = defaultSize;
	}
	/**
	 * @return Returns the pencilName.
	 */
	public String getPencilName() {
		return pencilName;
	}
	/**
	 * @return Returns the title.
	 */
	public String getTitle() {
		return title;
	}
	/**
	 * @return Returns the defaultSize.
	 */
	public Size getDefaultSize() {
		return new Size(defaultSize, defaultSize);
	}

	private String pencilName;
	private String title;
	private int defaultSize;
}
