package pencilbox.nurikabe;

import java.awt.Color;

import javax.swing.JMenuItem;

import pencilbox.common.gui.MenuBase;


/**
 * uʂ肩ׁvj[NX
 */
public class Menu extends MenuBase {
	
	private JMenuItem numberColorItem;
	private JMenuItem paintColorItem;
	private JMenuItem circleColorItem;
//	private JMenuItem indicateErrorItem;
	private JMenuItem countAreaSizeItem;
	private JMenuItem separateAreaColorItem;

	public Panel getPanel() {
		return (Panel) getPanelBase();
	}

	protected void buildEditMenu() {
		addSymmetricPlacementMenuItem();
		addTrimAnswerMenuItem();
		super.buildEditMenu();
	}

	protected void buildViewMenu() {
		addNoPaintMarkStyleMenu();
		super.buildViewMenu();
		numberColorItem = addColorMenuItem("");
		paintColorItem = addColorMenuItem("}X");
		circleColorItem = addColorMenuItem("}X");
//		addToViewMenu(indicateErrorItem = makeCheckBoxCommandMenuItem("ԂŎ(E)", 'E', false));
		addToViewMenu(separateAreaColorItem = makeCheckBoxCommandMenuItem("ǂ̐F(R)", 'R', false));
		addToViewMenu(countAreaSizeItem = makeCheckBoxCommandMenuItem("V}̃}X𐔂(C)",'C', false));
		addRenewColorMenuItem();	
	}

	public void executeCommand2(JMenuItem target) {
//		if (target == indicateErrorItem)
//			getPanel().setIndicateError(target.isSelected());
//		else
		if (target == countAreaSizeItem)
			getPanel().setCountAreaSizeMode(target.isSelected());
		else if (target == separateAreaColorItem)
			getPanel().setSeparateAreaColorMode(target.isSelected());
	}

	public Color getColor(JMenuItem target) {
		if (target == paintColorItem)
			return getPanel().getPaintColor();
		else if (target == circleColorItem)
			return getPanel().getCircleColor();
		else if (target == numberColorItem)
			return getPanel().getNumberColor();
		else
			return super.getColor(target);
	}

	public void setColor(JMenuItem target, Color color) {
		if (target == paintColorItem)
			getPanel().setPaintColor(color);
		else if (target == circleColorItem)
			getPanel().setCircleColor(color);
		else if (target == numberColorItem)
			getPanel().setNumberColor(color);
		else
			super.setColor(target, color);
	}

	public void updateCurrentMenuSelection() {
		super.updateCurrentMenuSelection();
//		indicateErrorItem.setSelected(getPanel().isIndicateError());
		separateAreaColorItem.setSelected(getPanel().isSeparateAreaColorMode());
		countAreaSizeItem.setSelected(getPanel().isCountAreaSizeMode());
	}

}
