package pencilbox.common.core;


/**
 * l̍W\NX
 */
public class Address implements Comparable<Address> {
	
	/**
	 *  ՊOW
	 */
	public static final Address NOWHERE = new Address(-1,-1);
	
	/**
	 *  sW
	 */
	private int r;
	/**
	 *  W
	 */
	private int c;
	
	/**
	 * RXgN^
	 */
	public Address(){
		this(0,0);
	}
	/**
	 * RXgN^C̍WƓWɐݒ
	 * @param pos ݒ肷W
	 */
	public Address(Address pos){
		this.r = pos.r;
		this.c = pos.c;
	}
	/**
	 * RXgN^C̍Wɐݒ
	 * @param r ݒ肷sW
	 * @param c ݒ肷W
	 */
	public Address(int r, int c){
		this.r = r;
		this.c = c;
	}
	/**
	 * 
	 */
	public static Address address(int r, int c){
		return new Address(r, c);
	}

	/**
	 * @return Returns the r.
	 */
	public int r() {
		return r;
	}
	/**
	 * @return Returns the c.
	 */
	public int c() {
		return c;
	}
	/**
	 * ̍Wɐݒ
	 * @param pos ݒ肷W
	 */
	public void set(Address pos){
		this.r = pos.r;
		this.c = pos.c;
	}
	/**
	 * ̍Wɐݒ
	 * @param r ݒ肷sW
	 * @param c ݒ肷W
	 */
	public void set(int r, int c){
		this.r = r;
		this.c = c;
	}
	/**
	 * ̍WƓr
	 * @param o rΏ
	 * @return ̍Wƈ̍W true
	 */
	public boolean equals(Object o) {
		if (!(o instanceof Address))
			return false;
		Address address = (Address)o;
		if (address.r == r && address.c == c)
			return true;
		else
			return false;
	}
	/**
	 * ̍WƓr
	 * @param rr rΏۂ̍sW
	 * @param cc rΏۂ̗W
	 * @return ̍Wƈ̍W true
	 */
	public boolean equals(int rr, int cc) {
		if (rr == r && cc == c)
			return true;
		else
			return false;
	}
	public int hashCode() {
		return r * 1000 + c;
	}
//	/**
//	 * ̍WƏ㉺EɗאڂĂ邩
//	 * @param address
//	 * @return אڂĂ true
//	 */
//	public boolean isNextTo(Address address) {
//		if ((address.r == r && (address.c == c-1 || address.c == c+1))
//			|| (address.c == c && (address.r == r-1 || address.r == r+1)))
//		return true;
//		else
//			return false;
//	}
//	/**
//	 * ̍WƓs܂͗
//	 * @param address r Address
//	 * @return ꒼Ȃ true
//	 */
//	public boolean isInLine(Address address) {
//		if ( address.r == r || address.c == c )
//			return true;
//		else
//			return false;
//	}
	/**
	 * ՊOWǂ
	 * @return WՊO_ł true
	 */
	public boolean isNowhere() {
		return (r==-1 && c==-1);
	}
	/**
	 * ՊOWɐݒ肷
	 */
	public void setNowhere() {
		r = -1;
		c = -1;
	}
	/**
	 * ׂ̃}XWɈړ
	 * @param direction ړ
	 */
	public void move(int direction) {
		switch (direction) {
			case Direction.UP:
				r--;
				break;
			case Direction.LT:
				c--;
				break;
			case Direction.DN:
				r++;
				break;
			case Direction.RT:
				c++;
				break;
			default:
				break;
			}
	}
	/** 
	 * ̒`
	 * sW r OC
	 * sW΁CW c OD
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Address o) {
		if (this.r < o.r) return -1;
		else if (this.r > o.r) return 1;
		else {
			if (this.c < o.c) return -1;
			else if (this.c > o.c) return 1;
			else return 0; 
		}
	}
	
	/**
	 * }X}Xւ̌擾
	 * @param pos0 n_}XW
	 * @param pos1 I_}XW
	 * @return n_I_ւ̌\萔ԂBɂȂꍇ-1ԂB
	 */
	public static int getDirectionTo(Address pos0, Address pos1) {
		int r0 = pos0.r();
		int r1 = pos1.r();
		int c0 = pos0.c();
		int c1 = pos1.c();
		int ret = -1;
		if (r0 == r1) {
			if (c0 < c1)
				ret = Direction.RT;
			else if (c0 > c1)
				ret = Direction.LT;
		} else if (c0 == c1) {
			if (r0 < r1)
				ret = Direction.DN;
			else if (r0 > r1)
				ret = Direction.UP;
		}
		return ret;
	}

	/**
	 * }Xւ̂擾
	 * @param pos I_}XW
	 * @return I_}Xւ̌\萔ԂBɂȂꍇ-1ԂB
	 */
	public int getDirectionTo(Address pos) {
		return Address.getDirectionTo(this, pos);
	}

	/**
	 * Zdirection ̃Z
	 */
	public static Address nextCell(Address p, int direction) {
		int r = p.r();
		int c = p.c();
		switch (direction) {
		case Direction.UP:
			return new Address(r-1,c);
		case Direction.LT:
			return new Address(r,c-1);
		case Direction.DN:
			return new Address(r+1,c);
		case Direction.RT:
			return new Address(r,c+1);
		default:
			return Address.NOWHERE;
		}
	}

	/*
	 * @see java.lang.Object#toString()
	 */
	public String toString(){
		return ""+'['+r+','+c+']';
	}
}
