/**
 * 
 */
package pencilbox.common.core;


/**
 * W]vZp⏕NX
 * }XSݒ肵ĉ]
 */
public class Rotator2 {
	
	/**
	 * ŗ^]ԍ́CՖʃTCY̏cɊY邩ۂ𓚂
	 * @param n@]ԍ
	 * @return cȂ true, ȂȂ false
	 */
	public static boolean isTransposed(int n) {
		switch (n) {
		case 0 :
		case 2 :
		case 5 :
		case 7 :
			return false;
		case 1 :
		case 3 :
		case 4 :
		case 6 :
			return true;
		default :
			return false;
		}
	}
	
	/**
	 * ]ϊ̌
	 * @param a@1߂̉]ԍ
	 * @param b@2߂̉]ԍ
	 * @return@]ԍ̐
	 */
	public static int combine(int a, int b) {
		int r = a;
		if (a >= 0 && a <= 3) {
			r = (b / 4) * 4  + (a + b) % 4;
		} else if (a >= 4 && a <= 7) {
			r = ((7-b) / 4) * 4  + (a + (8-b)) % 4;
		}
		return r;
	}
	
	/**
	 * ]E]ԍ
	 * 0@]Ȃ
	 * 1 90]
	 * 2@180]
	 * 3 270]
	 * 4 cƉ
	 * 5 90]ČcƉ
	 * 6 180]ČcƉ
	 * 7 270]ČcƉ
	 */
	private int rotation = 0;
//	private int rows; // ]S
//	private int cols; // ]S
	private int rows2; // ]S2{
	private int cols2; // ]S2{
	
	/**
	 * RXgN^
	 */
	public Rotator2() {
	}
	
	/**
	 * RXgN^
	 * @param rows s
	 * @param cols 
	 * @param rotation ]E]ԍ
	 */
	public Rotator2(int rows, int cols, int rotation) {
//		this.rows = rows;
//		this.cols = cols;
		this.rows2 = rows * 2;
		this.cols2 = cols * 2;
		this.rotation = rotation;
	}
	
	/**
	 * RXgN^
	 * @param center SW
	 * @param rotation ]E]ԍ
	 */
	public Rotator2(Address center, int rotation) {
		this(center.r(), center.c(), rotation);
	}
	
	/**
	 * Ԃݒ肷
	 * @param rows s
	 * @param cols 
	 * @param rotation ]E]ԍ
	 */
	public void setup(int rows, int cols, int rotation) {
//		this.rows = rows;
//		this.cols = cols;
		this.rows2 = rows * 2;
		this.cols2 = cols * 2;
		this.rotation = rotation;
	}

	/**
	 * @return Returns the rotation.
	 */
	public int getRotation() {
		return rotation;
	}
	
	/**
	 * ՖʃTCY̏c邩ǂ
	 * @return cȂ true
	 */
	public boolean isTransposed() {
		return isTransposed(rotation);
	}

	/**
	 * ϊWԂ
	 * @param pos
	 */
	public Address rotateAddress(Address pos) {
		Address dst = new Address();
		switch (rotation) {
			case 0 :
				dst.set(pos.r(), pos.c());
				break;
			case 1 :
				dst.set((rows2 + cols2)/2 - pos.c(), (cols2 - rows2)/2 + pos.r());
				break;
			case 2 :
				dst.set(rows2 - pos.r(), cols2 - pos.c());
				break;
			case 3 :
				dst.set((rows2 - cols2)/2 + pos.c(), (cols2 + rows2)/2 - pos.r());
				break;
			case 4 :
				dst.set((rows2 - cols2)/2 + pos.c(), (cols2 - rows2)/2 + pos.r());
				break;
			case 5 :
				dst.set(pos.r(), cols2 - pos.c());
				break;
			case 6 :
				dst.set((rows2 + cols2)/2 - pos.c(), (cols2 + rows2)/2 - pos.r());
				break;
			case 7 :
				dst.set(rows2 - pos.r(), pos.c());
				break;
		}
		return dst;
	}

	/**
	 * Տ̕pl̕ɕϊ
	 * @param direction ϊ̕\l
	 * @return ϊ̕\l
	 */
	public int rotateDirection(int direction) {
		switch (rotation) {
			case 0 :
			case 1 :
			case 2 :
			case 3 :
				direction = (direction + rotation) % 4;
				break;
			case 4 :
			case 5 :
			case 6 :
			case 7 :
				direction = (direction + rotation) % 4;
				direction = direction ^ 1;
				break;
		}
		return direction;
	}
	
}
