package pencilbox.slalom;

import java.util.LinkedList;
import java.util.List;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Direction;
import pencilbox.common.core.SideAddress;
import pencilbox.util.ArrayUtil;

/**
 * uX[vՖʃNX
 */
public class Board extends BoardBase {

	static final int HORIZ = Direction.HORIZ;
	static final int VERT = Direction.VERT;

	static final int UNKNOWN = 0;
	static final int LINE = 1;
	static final int NOLINE = -1;
	static final int BLANK = -3;
	static final int GOAL = -1;
	static final int OUTER = -9;
	static final int UNDECIDED_NUMBER = 0;
	static final int GATE_VERT = -5;
	static final int GATE_HORIZ = -4;

	private int[][] number;  // }X̏
	private int[][][] state; // ӂ̏
	private int[][] gateNumber;  // ̔ԍ
	private int nGate;  // ̐
	private Address goal;  // X^[g^S[n_̍WBP݂̂Ƃ

	private List<Link> linkList;
	private Link[][][] link;
	private Link initializingLink;

	protected void setup() {
		super.setup();
		number = new int[rows()][cols()];
		gateNumber = new int[rows()][cols()];
		ArrayUtil.initArrayInt2(number, BLANK);
		goal = new Address(-1, -1);
		state = new int[2][][];
		state[VERT] = new int[rows()][cols()-1];
		state[HORIZ] = new int[rows()-1][cols()];
		linkList = new LinkedList<Link>();
		link = new Link[2][][];
		link[VERT] = new Link[rows()][cols()-1];
		link[HORIZ] = new Link[rows()-1][cols()];
	}

	/**
	 * w肵}Xɐ}XC}XC}XC󔒃}X̏Ԃݒ肷
	 * S[͂PȉƂB
	 * @param r sW
	 * @param c W
	 * @param n ݒ肷
	 */
	public void setNumber(int r, int c, int n) {
		int n0 = number[r][c];
		if (n0 == Board.GOAL) {
			goal.setNowhere();
		}
		if (n == Board.GOAL) {
			if (goal.isNowhere()) {
			} else {
				number[goal.r()][goal.c()] = Board.BLANK;
			}
			goal.set(r, c);
		}
		number[r][c] = n;
	}

	public void setNumber(Address pos, int n) {
		setNumber(pos.r(), pos.c(), n);
	}
	/**
	 * w肵}X̏Ԃ擾
	 * @param r sW
	 * @param c W
	 */
	public int getNumber(int r, int c) {
		return number[r][c];
	}

	public int getNumber(Address pos) {
		return getNumber(pos.r(), pos.c());
	}

	/**
	 * }X
	 * @param r sW
	 * @param c W
	 * @return }Xł true
	 */
	public boolean isWall(int r, int c) {
		return number[r][c] >= 0 || number[r][c] == UNDECIDED_NUMBER;
	}

	public boolean isWall(Address pos) {
		return isWall(pos.r(), pos.c());
	}
	/**
	 * }X
	 * @param r sW
	 * @param c W
	 * @return }XC萔}Xł true
	 */
	public boolean isGate(int r, int c) {
		return number[r][c] == GATE_HORIZ || number[r][c] == GATE_VERT;
	}

	public boolean isGate(Address pos) {
		return isGate(pos.r(), pos.c());
	}
	/**
	 * W̗2}Xꂩ}Xǂ
	 * @param d
	 * @param r
	 * @param c
	 * @return W̗2}Xꂩ}Xł true
	 */
	public boolean hasWall(int d, int r, int c) {
		if (d == VERT)
			return isWall(r, c) || isWall(r, c+1);
		else if (d == HORIZ)
			return isWall(r, c) || isWall(r+1, c);
		return false;
	}

	public boolean hasWall(SideAddress pos) {
		return hasWall(pos.d(), pos.r(), pos.c());
	}
	/**
	 * @param p
	 * @return
	 */
	public int getGateNumber(Address p) {
		return gateNumber[p.r()][p.c()];
	}

	public int getGateNumber(int r, int c) {
		return gateNumber[r][c];
	}

	/**
	 * @param p
	 * @return
	 */
	public int setGateNumber(Address p, int n) {
		return gateNumber[p.r()][p.c()] = n;
	}

	public int setGateNumber(int r, int c, int n) {
		return gateNumber[r][c] = n;
	}
	/**
	 * @return the nGate
	 */
	public int getNGate() {
		return nGate;
	}

	/**
	 * @return the Goal
	 */
	public Address getGoal() {
		return goal;
	}

	/**
	 * ӏԂ̎擾
	 * @param d
	 * @param r
	 * @param c
	 * @return ӂ̏ԂԂ
	 */
	public int getState(int d, int r, int c) {
		if (isSideOn(d, r, c))
			return state[d][r][c];
		else
			return OUTER;
	}

	public int getState(SideAddress pos) {
		return getState(pos.d(), pos.r(), pos.c());
	}

	/**
	 * ӏԂ̎擾B}XƌōWw肷B
	 * @param pos
	 * @param d
	 * @return
	 */
	public int getStateJ(Address pos, int d) {
		return getState(SideAddress.get(pos, d));
	}

	/**
	 * ӏԂ̐ݒ
	 * @param d
	 * @param r
	 * @param c
	 * @param st
	 */
	public void setState(int d, int r, int c, int st) {
		if (isSideOn(d, r, c))
			state[d][r][c] = st;
	}

	public void setState(SideAddress pos, int st) {
		setState(pos.d(), pos.r(), pos.c(), st);
	}

	/**
	 * ӏԂ̐ݒB}XƌōWw肷B
	 * @param pos
	 * @param d
	 * @param st
	 */
	public void setStateJ(Address pos, int d, int st) {
		setState(SideAddress.get(pos, d), st);
	}

	public boolean isLine(int d, int r, int c) {
		if (!isSideOn(d, r, c))
			return false;
		return state[d][r][c] == LINE;
	}

	public Link getLink(int d, int r, int c) {
		if (isSideOn(d, r, c))
			return link[d][r][c];
		else
			return null;
	}

	public Link getLink(SideAddress pos) {
		return link[pos.d()][pos.r()][pos.c()];
	}
	/**
	 * ̃}X܂ Link Ԃ
	 */
	public Link getLink(int r, int c) {
		Link link;
		link = getLink(VERT, r, c - 1);
		if (link != null)
			return link;
		link = getLink(VERT, r, c);
		if (link != null)
			return link;
		link = getLink(HORIZ, r - 1, c);
		if (link != null)
			return link;
		link = getLink(HORIZ, r, c);
		if (link != null)
			return link;
		return null;
	}

	public void setLink(int d, int r, int c, Link l) {
		link[d][r][c] = l;
	}

	public void setLink(SideAddress pos, Link l) {
		link[pos.d()][pos.r()][pos.c()] = l;
	}
	/**
	 * }X㉺E4ɈĂ
	 * }X}X␔}XɕύXꂽꍇɐ邽߂Ɏgp
	 * @param pos }X̍W
	 */
	void eraseLinesAround(Address pos) {
		for (int d = 0; d <= 3; d++) {
			SideAddress side = SideAddress.get(pos, d);
			if (getState(side) == LINE || getState(side) == NOLINE) {
				changeStateA(side, UNKNOWN);
			}
		}
	}

	/**
	 * ӂ̏Ԃw肵ԂɕύX
	 * @param d c
	 * @param r sW
	 * @param c W
	 * @param st ύX̏
	 */
	public void changeState(int d, int r, int c, int st) {
		int previousState = getState(d, r, c);
		setState(d, r, c, st);
		if (previousState == LINE) {
			cutLink(d, r, c);
		}
		if (st == LINE) {
			connectLink(d, r, c);
		}
	}

	public void changeState(SideAddress pos, int st) {
		changeState(pos.d(), pos.r(), pos.c(), st);
	}

	/**
	 * ӂ̏Ԃw肵ԂɕύX
	 * AhDXi[ɕύXʒm
	 * @param pos ӍW
	 * @param st ύX̏
	 */
	public void changeStateA(SideAddress pos, int st) {
		fireUndoableEditUpdate(
			new UndoableEditEvent(this, new Step(pos.d(), pos.r(), pos.c(), getState(pos), st)));
		changeState(pos, st);
	}

	public void clearBoard() {
		super.clearBoard();
		ArrayUtil.initArrayInt3(state, UNKNOWN);
		initBoard();
	}

	public void trimAnswer() {
		for (int d = 0; d <= 1; d++) {
			for (int r = 0; r < rows(); r++) {
				for (int c = 0; c < cols(); c++) {
					if (getState(d, r, c) == NOLINE)
						setState(d, r, c, UNKNOWN);
				}
			}
		}
	}

	public void initBoard() {
		initGates();
		initLinks();
	}

	/**
	 * B ՖʑŜ̊Ƃ̔ԍݒ肷B
	 */
	void initGates() {
		nGate = 0;
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				setGateNumber(r, c, 0);
			}
		}
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				int n = getNumber(r, c);
				if (n == GOAL) {
					goal.set(r, c);
				} else if (n == GATE_HORIZ) {
					if (isOn(r, c-1) && getNumber(r, c-1) == GATE_HORIZ) {
					} else {
						nGate ++;
					}
				} else if (n == GATE_VERT) {
					if (isOn(r-1, c) && getNumber(r-1, c) == GATE_VERT) {
					} else {
						nGate ++;
					}
				}
			}
		}
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				int n = getNumber(r, c);
				if (n > 0) {
					initGateNumber(r, c, n);
				}
			}
		}
	}

	/**
	 * }X̔Α̍}XT
	 * @param p0 N_}X
	 * @param d 
	 * @return@̔Αɍ}X܂͊OȂ΂̍WCȊOnull
	 */
	Address getAnotherPole(Address p0, int d) {
		Address p = new Address(p0);
		int gateType = 0;
		if (d == Direction.UP || d == Direction.DN) {
			gateType = GATE_VERT;
		} else if (d == Direction.LT || d == Direction.RT) {
			gateType = GATE_HORIZ;
		}
		while (true) {
			p.move(d);
			if (isOn(p)) {
				if (isWall(p)) {
//					System.out.println(p.toString() + "[͍}X");
					return p;
				} else if (getNumber(p) == gateType) {
				} else {
//					System.out.println(p.toString() + "[͕ĂȂ");
					return null;
				}
			} else {
//				System.out.println(p.toString() + "[͊O");
				return p;
			}
		}
	}

	/**
	 * }XN_ɁCɏoĂɔԍݒ肷B
	 * @param r
	 * @param c
	 * @param d
	 * @param n
	 */
	private void setGateNumber(int r, int c, int d, int n) {
		Address p = new Address(r, c);
		int t = 0;
		if (d == 0 || d == 2)
			t = GATE_VERT;
		else
			t = GATE_HORIZ;
		p.set(r, c);
		while (true) {
			p.move(d);
			if (isOn(p) && getNumber(p) == t) {
				setGateNumber(p, n);
			} else {
				break;
			}
		}
	}
	/**
	 * ̔ԍ𒲂ׂB
	 * ̑猩̂͌߂ɂ̂ŁA}X猩B
	 * t̍}X㉺Eɗאڂ݂B
	 * ̔Αɓ̍}X΁C}X̐̔ԍB
	 * ̔ΑɈقȂ鐔̍}X΁C̔ԍ -1B
	 * }Xɗאڂ傪PŁC̔ԍ܂܂ĂȂ΁C}X̐̔ԍB
	 * @param r
	 * @param c
	 * @param n0 ̐Ƃ
	 */
	private void initGateNumber(int r, int c, int n0) {
		Address p = new Address(r, c);
		Address p1 = null;
//		System.out.println(p.toString() + "̍}XɂĒׂB");
		int d1 = -1; // Ί݂̍}X̌L^
		int ng = 0;  // 肵ԍL^
		int count = 0; // }X̂S̖̐𐔂
		for (int d = 0; d <= 3; d++) {
			int t = 0;
			if (d == 0 || d == 2)
				t = GATE_VERT;
			else
				t = GATE_HORIZ;
			p.set(r, c);
			p.move(d);
			if (isOn(p) && getNumber(p) == t) {
//				System.out.println(d + "̌ɖ傪");
				d1 = d;
				count++;
				p1 = getAnotherPole(p, d);
				if (p1 != null && isOn(p1)) {
					int n1 = getNumber(p1);
					if (n1 == n0) { // Ί݂̖Ɠԍ
						ng = n1;
						setGateNumber(r, c, d, n1);
//						System.out.println("Ί݂̐}X" + p1.toString() + "Ƃ̊Ԃ̖̔ԍ " + n1);
					} else if (n1 > 0 && n1 != n0) {
						ng = -1;
						setGateNumber(r, c, d, -1);
//						System.out.println("Ί݂̐}XقȂԍł邽߁C̔ԍ -1 ƂB");
					}
				} else {
//					System.out.println("Ί݂ɐ}XȂ");
				}
			}
		}
		if (count == 0) {
//			System.out.println("㉺ESɖ傪Ȃ ");
		} else if (count == 1) {
			if (ng == 0) {
				setGateNumber(r, c, d1, n0);
//				System.out.println("אڂ傪PȂ̂ŁC̖̔ԍ " + n0 + "Ɍ߂");
			} else if (ng == -1) {
//				System.out.println("אڂ傪PȂꍇłAقȂ鐔ɂ͂܂ꂽ̔ԍ-1ƂB ");
			} else if (ng > 0) {
//				System.out.println("אڂ傪PȂCς݁B");
			}
		} else if (count > 1) {
//			System.out.println("̖ɗאڂ̂Ŗ̔ԍ܂Ȃ");
		}
	}

	void initLinks() {
		Link.resetId();
		linkList.clear();
		ArrayUtil.initArrayObject2(link[0], null);
		ArrayUtil.initArrayObject2(link[1], null);
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				initLink(r, c);
			}
		}
	}

	/**
	 * }X܂ Link ̏
	 * link[][][] ͏Ă̂Ƃ
	 * @param r Link̋N_}X̍sW
	 * @param c Link̋N_}X̗W
	 */
	void initLink(int r, int c) {
		initializingLink = new Link();
		initLink1(VERT, r, c - 1);
		initLink1(VERT, r, c);
		initLink1(HORIZ, r - 1, c);
		initLink1(HORIZ, r, c);
		if (!initializingLink.isEmpty())
			linkList.add(initializingLink);
		// printLink(d,r,c);
	}

	private void initLink1(int d, int r, int c) {
		if (!isSideOn(d, r, c))
			return;
		if (!isLine(d, r, c))
			return;
		if (getLink(d, r, c) != null)
			return;
		initializingLink.add(d, r, c);
		setLink(d, r, c, initializingLink);
		if (d == VERT) {
			initLink1(VERT , r  , c-1);
			initLink1(VERT , r  , c+1);
			initLink1(HORIZ, r-1, c  );
			initLink1(HORIZ, r-1, c+1);
			initLink1(HORIZ, r  , c  );
			initLink1(HORIZ, r  , c+1);
		}
		if (d == HORIZ) {
			initLink1(HORIZ, r-1, c  );
			initLink1(HORIZ, r+1, c  );
			initLink1(VERT , r  , c-1);
			initLink1(VERT , r+1, c-1);
			initLink1(VERT , r  , c  );
			initLink1(VERT , r+1, c  );
		}
	}
	/**
	 * Link 
	 */	
	void connectLink(int d, int r, int c) {
		Link newLink = null;
		Link link1 = null;
		Link link2 = null;
		if (d==VERT) {
			link1 = getLink(r,c);
			link2 = getLink(r,c+1);
		} else if (d==HORIZ) {
			link1 = getLink(r,c);
			link2 = getLink(r+1,c);
		}
		if (link1==null && link2 == null) {
			newLink = new Link();
			linkList.add(newLink);
		} else if (link1==null && link2!=null) {
			newLink = link2;
		} else if (link1!=null && link2==null) {
			newLink = link1;
		} else if (link1==link2) {
			newLink = link1;
		} else {
			if (link1.size() >= link2.size()) {
				newLink = link1;
				newLink.addAll(link2);
				for(SideAddress joint : link2) {
					setLink(joint, newLink);
				}
				linkList.remove(link2);
			}
			else {
				newLink = link2;
				newLink.addAll(link1);
				for(SideAddress joint : link1) {
					setLink(joint, newLink);
				}
				linkList.remove(link1);
			}
		}
		newLink.add(d,r,c);
		setLink(d,r,c, newLink);
	}
	/**
	 * Link ؒf
	 */
	void cutLink(int d, int r, int c) {
		Link oldLink = getLink(d, r, c);
		Link longerLink = null;
		for (SideAddress joint : oldLink) {
			setLink(joint, null);
		}
		linkList.remove(oldLink);
		if (d==VERT) {
			initLink(r, c);
			longerLink = initializingLink;
			initLink(r, c+1);
			if (initializingLink.size() > longerLink.size())
				longerLink = initializingLink;
		} else if (d==HORIZ) {
			initLink(r, c);
			longerLink = initializingLink;
			initLink(r+1, c);
			if (initializingLink.size() > longerLink.size())
				longerLink = initializingLink;
		}
		longerLink.setId(oldLink.getId());
	}

	/**
	 * }X̏㉺E4̂CݐĂ鐔Ԃ
	 * @param r }X̍sW
	 * @param c }X̗W
	 * @return }X̏㉺EɈĂ̐
	 */
	public int countLine(int r, int c) {
		int no = 0;
		if (r < rows()-1 && isLine(HORIZ, r, c))
			no++;
		if (c < cols()-1 && isLine(VERT, r, c))
			no++;
		if (r > 0 && isLine(HORIZ, r-1, c))
			no++;
		if (c > 0 && isLine(VERT, r, c-1))
			no++;
		return no;
	}

	/**
	 * Ɋւ`FbN
	 * @return
	 */
	private int checkLinks() {
		int result = 0;
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				int l = countLine(r,c);
				if (l > 2) {
					result |= 1;
				} else if (l == 1) {
					result |= 2;
				}
			}
		}
		if (linkList.size() > 1)
			result |= 4;
		else if (linkList.size() == 0)
			result |= 8;
		return result;
	}

	/**
	 * ɂāAʉ߂Ă邩ǂ𒲂ׂB 
	 * ƂPӏ݂̂ŒꍇB
	 * Ȃꍇ͌B
	 * 񒼌ꍇ͌B
	 * @return 肪ΐCȂ0
	 */
	private int checkGates() {
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				if (isGate(r, c)) {
					int ret = checkGate1(r, c);
					if (ret == -1) {
						return 16;
					} else if (ret == 0) {
						return 32;
					} else if (ret > 1) {
						return 64;
					} else if (ret == -2) {
					}
				}
			}
		}
		return 0;
	}

	/**
	 * ̃}XɒڂāAʂ𒲂ׂB
	 * c̏[܂͉̍[̃}XɂĒׂB
	 * [܂͍[ȊÕ}X̏ꍇ͂łɒς݂̂͂B
	 * @param p ̃}X̍W
	 * @return ̒ʂĂ -1 , ς݂ -2, 0ȏ̐͐Ɍ񐔂ԂB
	 */
	private int checkGate1(int r, int c) {
		int count = 0;
		int gateType = getNumber(r, c);
		Address p = new Address(r, c);
//		System.out.println(p.toString() + "̖𒲂ׂB");
		int d = 0;
		if (gateType == Board.GATE_HORIZ) {
			d = Direction.RT;
			p.set(r, c-1);
		} else if (gateType == Board.GATE_VERT) {
			d = Direction.DN;
			p.set(r-1, c);
		}
		if (isOn(p) && getNumber(p) == gateType) {
			return -2; // ς݂̂͂
		}
		p.set(r, c);
		while (true) {
			int ret = checkGate2(p);
			if (ret == -1) {
//				System.out.println(p.toString() + "̈ʒu̖̒ʂB");
				return -1;
			} else if (ret == 1) {
				count ++;
			}
			p.move(d);
			if (isOn(p) && getNumber(p) == gateType) {
			} else {
				break;
			}
		}
//		System.out.println(count + "CB");
		return count;
	}

	/**
	 * ̃}XɒڂāAʂ𒲂ׂB
	 * ƕsɐĂΌCĂΐB
	 * @param p@̃}X̍W
	 * @return sĂ -1AĂ 1, ȊO 0
	 */
	private int checkGate2(Address p) {
		int type = getNumber(p);
		if (type == GATE_VERT) {
			if (getStateJ(p, Direction.UP) == LINE || getStateJ(p, Direction.DN) == LINE) {
//				System.out.println("Q[g" + p.toString() + "ƕsɑĂ");
				return -1;
			}
			if (getStateJ(p, Direction.LT) == LINE && getStateJ(p, Direction.RT) == LINE) {
//				System.out.println("Q[g" + p.toString() + "ƒĂ");
				return 1;
			}
		} else if (type == GATE_HORIZ) {
			if (getStateJ(p, Direction.LT) == LINE || getStateJ(p, Direction.RT) == LINE) {
//				System.out.println("Q[g" + p.toString() + "ƕsɑĂ");
				return -1;
			}
			if (getStateJ(p, Direction.UP) == LINE && getStateJ(p, Direction.DN) == LINE) {
//				System.out.println("Q[g" + p.toString() + "ƒĂ");
				return 1;
			}
		}
		return 0;
	}

	/**
	 * X^[gS[܂ł̖ʂԂǂ𒲂ׂB
	 * X^[gS[܂ł̌oHȂĂ邱Ƃ肷B
	 * ׂĂ̖𐳂ʉ߂Ă邱ƂOƂB
	 * S[ȂƂ́AԂǂ̂ݒׂB
	 * @return Œʉ߂Ă 0, Ăΐ
	 */
	private int checkRoute() {
		int[] gateNumber = new int[nGate]; // ʉ߂̔ԍL^B
		int k = 0;
		Address p0; // X^[g^S[n_
		if (goal.isNowhere()) {
			// S[Ȃꍇ́CԂ𐔂N_Ƃ邽߂̉̃S[ݒ肷B
			p0 = emporalGoal();
		} else {
			p0 = new Address(goal);
			if (getLink(p0.r(), p0.c()) == null) {
//				System.out.println("S[ʉ߂ĂȂB");
				return 512;
			}
		}
//		System.out.println("X^[g^S[n_ " + p0.toString());
		Address p = new Address(p0);
		int d = -1;
		while (true) {
			d = getLineDirection(p, d);
			p.move(d);
			if (isGate(p)) {
//				System.out.println("Q[g " + getGate(p).getNumber() + " ʉ");
				gateNumber[k] = getGateNumber(p);
				k++;
				if (k > nGate) { // ׂĂ̖𐳂ʉ߂Ă邱ƂOȂ΁A肦Ȃ
//					System.out.println("" + nGate + "̂" + k + "ӏ߂ʉ߂Bʉ߂傪");
					return 128;
				}
			}
			if (p.equals(p0)) {
//				System.out.println("S[B");
				break;
			}
		}
		if (k < nGate) { // ׂĂ̖𐳂ʉ߂Ă邱ƂOȂ΁A肦Ȃ
//			System.out.println("" + nGate + "̂" + k + "ӏʉ߂Bʉ߂傪Ȃ");
			return 128;
		}
//		for (k = 0; k < nGate; k++) {
//			System.out.print(gateNumber[k]);
//			System.out.print(' ');
//		}
//		System.out.println(" ̏Ԃɖʉ߂B");
		int gg = 1;
		// S[ݒ肳ĂȂƂ́AS[͉Ԗڂɒʉ߂Ă悢ƂɂB
		if (goal.isNowhere() && nGate >= 1) {
			gg = nGate;
		}
		for (int g = 0; g < gg; g++) {
			for (k = 0; k < nGate; k++) {
				if (gateNumber[k] > 0) { // ɔԍw肳ĂƂ
					if (gateNumber[k] != ((k + g) % nGate + 1)) {
						break;
					}
				}
			}
			if (k == nGate) {
//				System.out.println("̒ʉߏB");
				return 0;
			}
		}
		for (int g = 0; g < gg; g++) {
			for (k = 0; k < nGate; k++) {
				if (gateNumber[k] > 0) {
					if (gateNumber[k] != ((nGate - 1 - k + g) % nGate + 1)) {
						break;
					}
				}
			}
			if (k == nGate) {
//				System.out.println("̒ʉߏB");
				return 0;
			}
		}
//		System.out.println("̒ʉߏĂB");
		return 256;
	}

	/**
	 * S[ݒ肳ĂȂՖʂŁÃS[ݒ肷B
	 */
	private Address emporalGoal() {
		for (int r = 0; r < rows(); r++) {
			for (int c = 0; c < cols(); c++) {
				if (countLine(r, c) > 1) {
					return new Address(r, c);
				}
			}
		}
		return Address.NOWHERE;
	}

	/**
	 * ȊOŐ̉тĂЂƂԂB
	 * Nǂ̂ɗpB
	 * @param p
	 * @param direction
	 * @return
	 */
	private int getLineDirection(Address p, int direction) {
		if (getStateJ(p, Direction.UP) == LINE && direction != Direction.DN)
			return Direction.UP;
		if (getStateJ(p, Direction.LT) == LINE && direction != Direction.RT)
			return Direction.LT;
		if (getStateJ(p, Direction.DN) == LINE && direction != Direction.UP)
			return Direction.DN;
		if (getStateJ(p, Direction.RT) == LINE && direction != Direction.LT)
			return Direction.RT;
		return -1;
	}

	public int checkAnswerCode() {
		int result = 0;
		result |= checkLinks();
		result |= checkGates();
		if (result == 0) // [vƖ̒ʂƂ̂ݏԂ`FbNB
			result |= checkRoute();
		return result;
	}

	public String checkAnswerString() {
		int result = checkAnswerCode();
		if (result == 0)
			return COMPLETE_MESSAGE;
		StringBuffer message = new StringBuffer();
		if ((result & 1) == 1) // ܂͌Ă
			message.append(Messages.getString("Board.AnswerCheckMessage1")); //$NON-NLS-1$
		if ((result & 2) == 2) // ĂȂ\n
			message.append(Messages.getString("Board.AnswerCheckMessage2")); //$NON-NLS-1$
		if ((result & 4) == 4) // ̐\n
			message.append(Messages.getString("Board.AnswerCheckMessage3")); //$NON-NLS-1$
		if ((result & 8) == 8) // Ȃ\n
			message.append(Messages.getString("Board.AnswerCheckMessage4")); //$NON-NLS-1$
		if ((result & 16) == 16) // ̒ʂ̊ԈႢ\n
			message.append(Messages.getString("Board.AnswerCheckMessage5")); //$NON-NLS-1$
		if ((result & 32) == 32) // ʂĂȂ傪\n
			message.append(Messages.getString("Board.AnswerCheckMessage6")); //$NON-NLS-1$
		if ((result & 64) == 64) // ʂ傪\n
			message.append(Messages.getString("Board.AnswerCheckMessage7")); //$NON-NLS-1$
		if ((result & 256) == 256) // ʂ鏇ԂĂ\n
			message.append(Messages.getString("Board.AnswerCheckMessage8")); //$NON-NLS-1$
		if ((result & 512) == 512) // ʂĂȂ\n
			message.append(Messages.getString("Board.AnswerCheckMessage9")); //$NON-NLS-1$
		return message.toString();
	}

	/**
	 * P̑\NX
	 * UNDO, REDO ł̕ҏW̒PʂƂȂ
	 */
	class Step extends AbstractUndoableEdit {

		private int direction;
		private int row;
		private int col;
		private int before;
		private int after;
		/**
		 * RXgN^
		 * @param d c
		 * @param r ύXꂽ}X̍sW
		 * @param c ύXꂽ}X̗W
		 * @param b ύXȌ
		 * @param a ύX̏
		 */
		public Step(int d, int r, int c, int b, int a) {
			super();
			direction = d;
			row = r;
			col = c;
			before = b;
			after = a;
		}

		public void undo() throws CannotUndoException {
			super.undo();
			changeState(direction, row, col, before);
		}

		public void redo() throws CannotRedoException {
			super.redo();
			changeState(direction, row, col, after);
		}
	}
}
