package pencilbox.common.core;

public class SquareEditStep extends AbstractStep {
	
	public static final int ADDED = 1;
	public static final int REMOVED = 0;
	public static final int CHANGED = 2;
	
	private Address p0 = Address.NOWHERE;
	private Address p1 = Address.NOWHERE;
	private Address q0 = Address.NOWHERE;
	private Address q1 = Address.NOWHERE;
	private int operation;

	/**
	 * RXgN^
	 * @param sq ꂽ̈
	 * @param operation ̎ށFǉꂽ̂Cꂽ̂
	 */
	public SquareEditStep(Address p0, Address p1, int operation) {
		super();
		if (operation == ADDED) {
			this.q0 = p0;
			this.q1 = p1;
		} else if (operation == REMOVED) {
			this.p0 = p0;
			this.p1 = p1;
		}
		this.operation = operation;
	}

	/**
	 * RXgN^
	 * @param p0 ύXO̊p̍W
	 * @param p1 ύXO̊p̍W
	 * @param q0 ύX̊p̍W
	 * @param q1 ύX̊p̍W
	 * @param operation ̎ށFǉꂽ̂Cꂽ̂CύXꂽ̂
	 */
	public SquareEditStep(Address p0, Address p1, Address q0, Address q1, int operation) {
		super();
		this.p0 = p0;
		this.p1 = p1;
		this.q0 = q0;
		this.q1 = q1;
		this.operation = operation;
	}

	public Address getP0() {
		return p0;
	}

	public Address getP1() {
		return p1;
	}

	public Address getQ0() {
		return q0;
	}

	public Address getQ1() {
		return q1;
	}

	public int getOperation() {
		return operation;
	}
	
}
