package pencilbox.numberlink;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelEventHandlerBase;


/**
 * uio[Nv}EX^L[쏈NX
 */
public class PanelEventHandler extends PanelEventHandlerBase {

	private Board board;

	private int currentState = INITAL; // hbO̕ӂ̏Ԃ\
	private static final int INITAL  = -9;
	private static final int PRESSED = -19;

	/**
	 * 
	 */
	public PanelEventHandler() {
	}
	
	protected void setBoard(BoardBase aBoard) {
		board = (Board) aBoard;
	}
	
	/*
	 * uio[Nv}EX
	 */
	protected void leftPressed(Address pos) {
		currentState = PRESSED;
	}

	protected void leftDragged(Address dragStart, Address dragEnd) {
		changeLineState(dragStart, dragEnd, Board.LINE);
	}

	/*
	 * NbN}X̐nCCg PxNbNƃnCCg
	 */
	protected void leftReleased(Address pos) {
		if (currentState == PRESSED && isOn(pos)) {
			Link link = board.getLink(pos);
			int newNumber = 0;
			if (board.isNumber(pos))
				newNumber = board.getNumber(pos);
			else {
				if(link!=null)
					newNumber = link.getNumber();
			}
			if (newNumber == getSelectedNumber() && getSelectedLink() == link) {
				setSelectedLink(null);
				setSelectedNumber(0);
			} else {
				setSelectedLink(link);
				setSelectedNumber(newNumber);
			}
		}
		currentState = INITAL;
	}

	/**
	 * n_}XƏI_}X񂾐̏Ԃw̏ԂɕύX
	 * n_̕ӂ݂̌̏Ԃw̏Ԃł΁CɕύX
	 * @param pos0 n_}X̍W
	 * @param pos1 I_}X̍W
	 * @param st ύX̏
	 */
	private void changeLineState(Address pos0, Address pos1, int st) {
		int direction = pos0.getDirectionTo(pos1);
		if (direction < 0)
			return;
		SideAddress side = SideAddress.get(pos0, direction);
		if (currentState == PRESSED) {
			if (board.getState(side) == st) {
				currentState = Board.UNKNOWN;
			} else {
				currentState = st;
			}
		}
		for (Address p = pos0; !p.equals(pos1); p = p.nextCell(direction)) {
			side = SideAddress.get(p, direction);
			if (board.getState(side) != currentState)
				board.changeState(side, currentState);
		}
	}

	/*
	 * uio[NvL[
	 */
	protected void numberEntered(Address pos, int num) {
		if (isProblemEditMode()) {
			if (num > 0) {
				board.changeNumber(pos, num);
				if (isSymmetricPlacementMode()) {
					Address posS = getSymmetricPosition(pos);
					if (!board.isNumber(posS))
						board.changeNumber(posS, Board.UNDECIDED_NUMBER);
				}
			}
		}
	}

	protected void spaceEntered(Address pos) {
		if (isProblemEditMode()) {
			board.changeNumber(pos, Board.BLANK);
			if (isSymmetricPlacementMode()) {
				Address posS = getSymmetricPosition(pos);
				if (board.isNumber(posS))
					board.changeNumber(posS, Board.BLANK);
			}
		}
	}

	protected void minusEntered(Address pos) {
		if (isProblemEditMode()) {
			board.changeNumber(pos, Board.UNDECIDED_NUMBER);
			if (isSymmetricPlacementMode()) {
				Address posS = getSymmetricPosition(pos);
				if (!board.isNumber(posS))
					board.changeNumber(posS, Board.UNDECIDED_NUMBER);
			}
		}
	}

	private Link getSelectedLink() {
		return ((Panel) getPanel()).getSelectedLink();
	}

	private void setSelectedLink(Link l) {
		((Panel) getPanel()).setSelectedLink(l);
	}
	
	private int getSelectedNumber() {
		return ((Panel) getPanel()).getSelectedNumber();
	}
	
	private void setSelectedNumber(int n) {
		((Panel) getPanel()).setSelectedNumber(n);
	}

}
