/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shakashaka;

import pencilbox.common.core.Address;
import pencilbox.common.core.AreaBase;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.shakashaka.Board;

public class BoardCopier
extends BoardCopierBase {
    @Override
    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, AreaBase region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        for (Address s : region) {
            Address d = this.translateAndRotateAddress(s, from, to, rotation);
            if (!board.isOn(d)) continue;
            int st = srcBoard.getState(s);
            if (Board.isTriangle(st)) {
                st = BoardCopier.rotateDirection(st, rotation);
            }
            board.changeNumber(d, srcBoard.getNumber(s));
            board.changeState(d, st);
        }
    }

    @Override
    public void eraseRegion(BoardBase boardBase, AreaBase region) {
        Board board = (Board)boardBase;
        for (Address s : region) {
            board.changeState(s, 0);
            board.changeNumber(s, -1);
        }
    }

    public static int rotateDirection(int direction, int rotation) {
        switch (rotation) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                direction = (direction + rotation) % 4 + 4;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                direction = (direction + rotation) % 4 + 4;
                if ((direction & 1) != 1) break;
                direction ^= 2;
            }
        }
        return direction;
    }
}

