/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hashi;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.hashi.Bridge;
import pencilbox.hashi.BridgeEditStep;
import pencilbox.hashi.Pier;
import pencilbox.resource.Messages;

public class Board
extends BoardBase {
    static final int UNDECIDED_NUMBER = 9;
    static final int NO_NUMBER = 0;
    private Pier[][] pier;
    private Bridge[][] bridgeV;
    private Bridge[][] bridgeH;
    private int maxChain;
    static final String ERR_CROSS_BRIDGE = Messages.getString("hashi.AnswerCheckMessage1");
    static final String YET_MULTIPLE_LINE = Messages.getString("hashi.AnswerCheckMessage2");
    static final String ERR_WRONG_NUMBER = Messages.getString("hashi.AnswerCheckMessage3");

    @Override
    protected void setup() {
        super.setup();
        this.bridgeV = new Bridge[this.rows()][this.cols()];
        this.bridgeH = new Bridge[this.rows()][this.cols()];
        this.pier = new Pier[this.rows()][this.cols()];
        this.maxChain = 1;
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.isPier(p)) {
                this.getPier(p).clear();
            }
            ++n2;
        }
    }

    @Override
    public void initBoard() {
        this.initChain();
    }

    public void setNumber(int r, int c, int n) {
        this.setNumber(Address.address(r, c), n);
    }

    public void setNumber(Address p, int n) {
        if (n == 0) {
            if (this.isPier(p)) {
                this.removePier(p);
            }
        } else if (n >= 1 && n <= 8 || n == 9) {
            if (this.isPier(p)) {
                this.getPier(p).setNumber(n);
            } else {
                this.addPier(p, n);
            }
        }
    }

    public void changeNumber(Address p, int n) {
        int prev = this.getNumber(p);
        if (prev == n) {
            return;
        }
        this.setNumber(p, n);
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(p, prev, n));
        }
    }

    public int getNumber(int r, int c) {
        return this.getNumber(Address.address(r, c));
    }

    public int getNumber(Address p) {
        if (this.isPier(p)) {
            return this.getPier(p).getNumber();
        }
        return 0;
    }

    public boolean isPier(Address p) {
        return this.pier[p.r()][p.c()] != null;
    }

    public int getState(int r, int c) {
        Address p = Address.address(r, c);
        return this.getLine(p, 0) + (this.getLine(p, 1) << 2);
    }

    public void setState(int r, int c, int n) {
        Address p = Address.address(r, c);
        this.setLine(p, 0, n & 3);
        this.setLine(p, 1, n >> 2 & 3);
    }

    public void setState(Address pos, int n) {
        this.setState(pos.r(), pos.c(), n);
    }

    public int getLine(Address p, int d) {
        if (this.getBridge(p, d) != null) {
            return this.getBridge(p, d).getLine();
        }
        return 0;
    }

    public void setLine(Address p, int d, int n) {
        if (this.getBridge(p, d) != null) {
            this.getBridge(p, d).setLine(n);
        }
    }

    public boolean hasCrossedBridge(Address p) {
        int v = this.getLine(p, 0);
        int h = this.getLine(p, 1);
        return v > 0 && h > 0;
    }

    public Pier getPier(int r, int c) {
        return this.pier[r][c];
    }

    public Pier getPier(Address p) {
        return this.pier[p.r()][p.c()];
    }

    public Pier setPier(Address p, Pier pi) {
        Pier pier = pi;
        this.pier[p.r()][p.c()] = pier;
        return pier;
    }

    public Bridge getBridge(Address p, int dir) {
        if (dir == 1) {
            return this.bridgeH[p.r()][p.c()];
        }
        if (dir == 0) {
            return this.bridgeV[p.r()][p.c()];
        }
        return null;
    }

    void setBridge(Address pos0, int d, Bridge b) {
        Address pos = pos0;
        int dir = d & 1;
        while (!this.isPier(pos = pos.nextCell(d))) {
            if (dir == 1) {
                this.bridgeH[pos.r()][pos.c()] = b;
                continue;
            }
            if (dir != 0) continue;
            this.bridgeV[pos.r()][pos.c()] = b;
        }
    }

    public int getLineFromPier(Address p, int d) {
        if (this.isPier(p)) {
            return this.getPier(p).getLine(d);
        }
        return -1;
    }

    void addPier(Address p, int n) {
        Pier next;
        Address nextPos;
        Pier pi = new Pier(p, n);
        this.setPier(p, pi);
        int d = 0;
        while (d < 4) {
            nextPos = this.findPier(p, d);
            if (nextPos != Address.nowhere() && (next = this.getPier(nextPos)).getLine(d ^ 2) > 0) {
                this.changeLine(nextPos, d ^ 2, 0);
            }
            ++d;
        }
        d = 0;
        while (d < 4) {
            nextPos = this.findPier(p, d);
            if (nextPos != Address.nowhere()) {
                next = this.getPier(nextPos);
                next.setNextPier(d ^ 2, pi);
                pi.setNextPier(d, next);
                Bridge b = new Bridge(pi, next);
                next.setBridge(d ^ 2, b);
                pi.setBridge(d, b);
                this.setBridge(p, d, b);
            }
            ++d;
        }
    }

    void removePier(Address p) {
        Pier p2;
        Pier p1;
        Pier pi = this.getPier(p);
        int d = 0;
        while (d < 4) {
            if (this.getLineFromPier(p, d) > 0) {
                this.changeLine(p, d, 0);
            }
            ++d;
        }
        d = 0;
        while (d < 4) {
            p1 = pi.getNextPier(d);
            p2 = pi.getNextPier(d ^ 2);
            if (p1 != null) {
                if (p2 != null) {
                    p1.setNextPier(d ^ 2, p2);
                } else {
                    p1.setNextPier(d ^ 2, null);
                }
            }
            ++d;
        }
        d = 0;
        while (d < 2) {
            p1 = pi.getNextPier(d);
            p2 = pi.getNextPier(d ^ 2);
            if (p1 != null) {
                if (p2 != null) {
                    Bridge b = new Bridge(p1, p2);
                    this.setBridge(p2.getPos(), d, b);
                    p1.setBridge(d ^ 2, b);
                    p2.setBridge(d, b);
                } else {
                    this.setBridge(p, d, null);
                    p1.setBridge(d ^ 2, null);
                }
            } else if (p2 != null) {
                this.setBridge(p, d ^ 2, null);
                p2.setBridge(d, null);
            }
            ++d;
        }
        this.setPier(p, null);
    }

    int getMaxChain() {
        return this.maxChain;
    }

    Address findPier(Address p0, int direction) {
        Address p = Address.nextCell(p0, direction);
        while (this.isOn(p)) {
            if (this.isPier(p)) {
                return p;
            }
            p = p.nextCell(direction);
        }
        return Address.nowhere();
    }

    public void changeLine(Address p, int d, int n) {
        if (!this.isPier(p)) {
            return;
        }
        if (n < 0 || n > 2) {
            return;
        }
        Pier pi = this.getPier(p);
        Pier nextPier = pi.getNextPier(d);
        if (nextPier == null) {
            return;
        }
        int prev = pi.getLine(d);
        if (prev == n) {
            return;
        }
        pi.setLine(d, n);
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new BridgeEditStep(p, d, prev, n));
        }
        if (n == 0) {
            this.cutChain(pi, nextPier);
        }
        if (prev == 0) {
            this.connectChain(pi, nextPier);
        }
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof BridgeEditStep) {
            BridgeEditStep s = (BridgeEditStep)step;
            this.changeLine(s.getPos(), s.getDirection(), s.getBefore());
        } else if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeNumber(s.getPos(), s.getBefore());
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof BridgeEditStep) {
            BridgeEditStep s = (BridgeEditStep)step;
            this.changeLine(s.getPos(), s.getDirection(), s.getAfter());
        } else if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeNumber(s.getPos(), s.getAfter());
        }
    }

    void initChain() {
        Address p;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            if (this.isPier(p)) {
                this.getPier(p).setChain(0);
            }
            ++n2;
        }
        this.maxChain = 1;
        addressArray = this.cellAddrs();
        n = addressArray.length;
        n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            if (this.isPier(p)) {
                Pier pi = this.getPier(p);
                if (pi.totalLines() == 0) {
                    pi.setChain(0);
                } else if (pi.getChain() == 0) {
                    this.initChain1(pi, this.maxChain++);
                }
            }
            ++n2;
        }
    }

    void initChain1(Pier pi, int chain) {
        if (pi.getChain() == chain) {
            return;
        }
        pi.setChain(chain);
        int d = 0;
        while (d < 4) {
            if (pi.getLine(d) > 0) {
                this.initChain1(pi.getNextPier(d), chain);
            }
            ++d;
        }
    }

    void connectChain(Pier pierA, Pier pierB) {
        int a = pierA.getChain();
        int b = pierB.getChain();
        if (a == 0) {
            if (b == 0) {
                pierA.setChain(this.maxChain);
                pierB.setChain(this.maxChain);
                ++this.maxChain;
            } else if (b > 0) {
                pierA.setChain(b);
            }
        } else if (a > 0) {
            if (b == 0) {
                pierB.setChain(a);
            } else if (b > 0) {
                this.initChain1(pierB, a);
            }
        }
    }

    void cutChain(Pier pierA, Pier pierB) {
        int a = pierA.totalLines();
        int b = pierB.totalLines();
        if (a == 0) {
            pierA.setChain(0);
            if (b == 0) {
                pierB.setChain(0);
            }
        } else if (a > 0) {
            if (b == 0) {
                pierB.setChain(0);
            } else if (b > 0) {
                this.initChain1(pierB, this.maxChain++);
            }
        }
    }

    public int checkNumber(Address p) {
        Pier pi = this.getPier(p);
        int number = pi.getNumber();
        int bridges = pi.totalLines();
        if (number == 9) {
            return 0;
        }
        return number - bridges;
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        if (!this.checkCross()) {
            result |= 1;
        }
        if (!this.checkConnection()) {
            result |= 2;
        }
        if (!this.checkNumbers()) {
            result |= 4;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return BoardBase.COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(ERR_CROSS_BRIDGE);
        }
        if ((result & 2) == 2) {
            message.append(YET_MULTIPLE_LINE);
        }
        if ((result & 4) == 4) {
            message.append(ERR_WRONG_NUMBER);
        }
        return message.toString();
    }

    private boolean checkNumbers() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.isPier(p) && this.checkNumber(p) != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean checkConnection() {
        int n = 0;
        Address[] addressArray = this.cellAddrs();
        int n2 = addressArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Address p = addressArray[n3];
            if (this.isPier(p)) {
                int m = this.getPier(p).getChain();
                if (m == 0) {
                    return false;
                }
                if (n == 0) {
                    n = m;
                } else if (n != m) {
                    return false;
                }
            }
            ++n3;
        }
        return true;
    }

    private boolean checkCross() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.hasCrossedBridge(p)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

