/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.io;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.PencilBoxException;
import pencilbox.common.core.Problem;
import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.factory.PencilType;
import pencilbox.common.io.PclReaderBase;
import pencilbox.common.io.PclWriterBase;
import pencilbox.common.io.PzprReaderBase;
import pencilbox.common.io.PzprWriterBase;
import pencilbox.common.io.TxtReaderBase;
import pencilbox.common.io.TxtWriterBase;
import pencilbox.common.io.XmlReaderBase;
import pencilbox.common.io.XmlWriterBase;
import pencilbox.heyawake.HeyawakeReader;
import pencilbox.heyawake.HeyawakeWriter;

public class IOController {
    private PencilType pencilType;

    public static IOController getInstance(PencilType pencilType) {
        return new IOController(pencilType);
    }

    private IOController(PencilType pencilType) {
        this.pencilType = pencilType;
    }

    public Problem openFile(String string) throws PencilBoxException {
        File file = new File(string);
        if (file.isFile()) {
            return this.openFile(file);
        }
        InputStream in = null;
        try {
            in = new URL(string).openStream();
            if (in != null) {
                Problem problem = new Problem(this.createTxtReader().readProblem(new InputStreamReader(in)));
                return problem;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public Problem openFile(File file) throws PencilBoxException {
        Problem problem = null;
        BoardBase board = null;
        Reader in = null;
        DataFormat format = this.checkFileExt(file);
        try {
            try {
                if (format == DataFormat.TXT) {
                    in = new FileReader(file);
                    TxtReaderBase txtReader = this.createTxtReader();
                    board = txtReader.readProblem(in);
                    problem = new Problem(board);
                } else if (format == DataFormat.XML) {
                    XmlReaderBase xmlReader = this.createXmlReader();
                    problem = xmlReader.readProblem(file);
                } else if (format == DataFormat.PCL) {
                    PclReaderBase pclReader = this.createPclReader();
                    problem = pclReader.readProblem(file);
                }
            }
            catch (ParserConfigurationException e) {
                throw new PencilBoxException(e);
            }
            catch (SAXException e) {
                throw new PencilBoxException(e);
            }
            catch (IOException e) {
                throw new PencilBoxException(e);
            }
            catch (RuntimeException e) {
                throw new PencilBoxException(e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        problem.setFile(file);
        return problem;
    }

    public Problem importProblemData(String string, DataFormat format) throws PencilBoxException {
        Problem problem = null;
        BoardBase board = null;
        Reader in = null;
        try {
            try {
                if (format == DataFormat.KANPEN) {
                    int index = string.indexOf("?problem=");
                    if (index > 0) {
                        string = string.substring(index + 9);
                    } else if (index == -1) {
                        throw new PencilBoxException("input data does not contain \"?problem=\".");
                    }
                    in = new StringReader(string.replace('/', '\n').replace('_', ' '));
                    board = this.createTxtReader().readProblem(in);
                } else if (format == DataFormat.PZPRV3) {
                    int index = string.indexOf(63);
                    if (index > 0) {
                        string = string.substring(index);
                    } else if (index == -1) {
                        throw new PencilBoxException("input data does not contain \"?\".");
                    }
                    board = this.createPzprReader().readProblem(string.trim());
                } else if (format == DataFormat.HEYAWAKE) {
                    int index = string.indexOf("?problem=");
                    if (index > 0) {
                        string = string.substring(index + 9);
                    } else if (index == -1) {
                        throw new PencilBoxException("input data does not contain \"?problem=\".");
                    }
                    board = new HeyawakeReader().readProblem(string.trim());
                }
            }
            catch (IOException e) {
                throw new PencilBoxException(e);
            }
            catch (RuntimeException e) {
                throw new PencilBoxException(e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        problem = new Problem(board);
        problem.setFile(null);
        return problem;
    }

    public void saveFile(Problem problem, File file) throws PencilBoxException {
        PrintWriter out = null;
        DataFormat format = this.checkFileExt(file);
        try {
            try {
                if (format == DataFormat.TXT) {
                    TxtWriterBase txtWriter = this.createTxtWriter();
                    out = new PrintWriter(new FileWriter(file));
                    txtWriter.writeProblem(out, problem.getBoard());
                } else if (format == DataFormat.XML) {
                    XmlWriterBase xmlWriter = this.createXmlWriter();
                    xmlWriter.writeProblem(file, problem);
                } else if (format == DataFormat.PCL) {
                    PclWriterBase pclWriter = this.createPclWriter();
                    pclWriter.writeProblem(file, problem);
                }
            }
            catch (IOException e) {
                throw new PencilBoxException(e);
            }
            catch (TransformerException e) {
                throw new PencilBoxException(e);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        problem.setFile(file);
    }

    public String exportProblemData(BoardBase board, DataFormat format) throws PencilBoxClassException {
        String string = "";
        if (format == DataFormat.KANPEN) {
            TxtWriterBase txtWriter = this.createTxtWriter();
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            txtWriter.writeQuestion(out, board);
            out.close();
            String dataS = sw.toString().replace(System.getProperty("line.separator"), "/").replace(' ', '_');
            string = String.valueOf(this.kanpenUrl()) + this.pencilType.getPencilName() + ".html?problem=" + dataS;
        } else if (format == DataFormat.PZPRV3) {
            string = String.valueOf(this.pzprv3Url()) + this.createPzprWriter().writeQuestion(board);
        } else if (format == DataFormat.HEYAWAKE) {
            string = new HeyawakeWriter().writeQuestion(board);
        }
        return string;
    }

    public String pzprv3Url() {
        return "http://pzv.jp/p.html?";
    }

    public String kanpenUrl() {
        return "http://www.kanpen.net/";
    }

    private DataFormat checkFileExt(File file) {
        String filename = file.getName();
        int len = filename.length();
        if (len >= 4) {
            if (filename.substring(len - 4).equals(".pcl")) {
                return DataFormat.PCL;
            }
            if (filename.substring(len - 4).equals(".xml")) {
                return DataFormat.XML;
            }
        }
        return DataFormat.TXT;
    }

    public XmlReaderBase createXmlReader() throws PencilBoxClassException {
        XmlReaderBase xmlReader = (XmlReaderBase)ClassUtil.createInstance(this.pencilType, "XmlReader");
        xmlReader.setPuzzleType(this.pencilType.getPencilName());
        return xmlReader;
    }

    public XmlWriterBase createXmlWriter() throws PencilBoxClassException {
        XmlWriterBase xmlWriter = (XmlWriterBase)ClassUtil.createInstance(this.pencilType, "XmlWriter");
        xmlWriter.setPuzzleType(this.pencilType.getPencilName());
        return xmlWriter;
    }

    public PclReaderBase createPclReader() throws PencilBoxClassException {
        PclReaderBase pclReader = (PclReaderBase)ClassUtil.createInstance(this.pencilType, "PclReader");
        return pclReader;
    }

    public PclWriterBase createPclWriter() throws PencilBoxClassException {
        PclWriterBase pclWriter = (PclWriterBase)ClassUtil.createInstance(this.pencilType, "PclWriter");
        pclWriter.setPuzzleType(this.pencilType);
        return pclWriter;
    }

    public TxtReaderBase createTxtReader() throws PencilBoxClassException {
        TxtReaderBase txtReader = (TxtReaderBase)ClassUtil.createInstance(this.pencilType, "TxtReader");
        return txtReader;
    }

    public TxtWriterBase createTxtWriter() throws PencilBoxClassException {
        TxtWriterBase txtWriter = (TxtWriterBase)ClassUtil.createInstance(this.pencilType, "TxtWriter");
        return txtWriter;
    }

    public PzprReaderBase createPzprReader() throws PencilBoxClassException {
        PzprReaderBase pzprReader = (PzprReaderBase)ClassUtil.createInstance(this.pencilType, "PzprReader");
        return pzprReader;
    }

    public PzprWriterBase createPzprWriter() throws PencilBoxClassException {
        PzprWriterBase pzprWriter = (PzprWriterBase)ClassUtil.createInstance(this.pencilType, "PzprWriter");
        return pzprWriter;
    }

    public static enum DataFormat {
        TXT,
        XML,
        PCL,
        KANPEN,
        PZPRV3,
        HEYAWAKE;

    }
}

