/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.heyawake;

import pencilbox.common.core.Address;
import pencilbox.common.core.AreaBase;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator;
import pencilbox.heyawake.Board;
import pencilbox.heyawake.Square;

public class BoardCopier
extends BoardCopierBase {
    @Override
    public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
        Board s = (Board)src;
        Board d = (Board)dst;
        Rotator rotator = new Rotator(src.getSize(), n);
        rotator.rotateArrayInt2(s.getState(), d.getState());
        for (Square srcSquare : s.getSquareList()) {
            Address pos0 = rotator.rotateAddress(srcSquare.p0());
            Address pos1 = rotator.rotateAddress(srcSquare.p1());
            if (!d.isOn(pos0) || !d.isOn(pos1)) continue;
            Square dstSquare = new Square(pos0, pos1);
            d.addSquare(dstSquare);
            dstSquare.setNumber(srcSquare.getNumber());
        }
    }

    @Override
    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, AreaBase region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        for (Address s : region) {
            Address d1;
            Address d0;
            Square dstSquare;
            Square srcSquare = srcBoard.getSquare(s);
            if (srcSquare == null || !s.equals(srcSquare.p0()) || !region.containsAll(srcSquare.getCorners()) || !board.isOnAll((dstSquare = new Square(d0 = this.translateAndRotateAddress(srcSquare.p0(), from, to, rotation), d1 = this.translateAndRotateAddress(srcSquare.p1(), from, to, rotation))).getCorners())) continue;
            board.removeOverlappedSquares(dstSquare, null);
            board.addSquare(dstSquare);
            board.changeNumber(d0, srcSquare.getNumber());
        }
        for (Address s : region) {
            Address d = this.translateAndRotateAddress(s, from, to, rotation);
            if (!board.isOn(d)) continue;
            board.changeState(d, srcBoard.getState(s));
        }
    }

    @Override
    public void eraseRegion(BoardBase boardBase, AreaBase region) {
        Board board = (Board)boardBase;
        for (Address s : region) {
            board.changeState(s, 0);
        }
        for (Address s : region) {
            Square square = board.getSquare(s);
            if (square == null || !s.equals(square.p0()) || !region.containsAll(square.getCorners())) continue;
            board.changeNumber(square.p0(), -1);
            board.removeSquare(square);
        }
    }
}

