/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.nurikabe;

import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.nurikabe.Area;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int SPACE = -1;
    static final int WALL = -2;
    static final int UNKNOWN = 0;
    static final int UNDECIDED_NUMBER = -3;
    private int[][] state;
    private Area[][] area;
    private Area[][] whiteArea;
    private List<Area> wallAreaList;
    private List<Area> spaceAreaList;
    private Area initializingArea;

    @Override
    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.area = new Area[this.rows()][this.cols()];
        this.whiteArea = new Area[this.rows()][this.cols()];
        this.wallAreaList = new LinkedList<Area>();
        this.spaceAreaList = new LinkedList<Area>();
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (!this.isNumber(p)) {
                this.setState(p, 0);
            }
            ++n2;
        }
        this.initBoard();
    }

    @Override
    public void trimAnswer() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getState(p) == -1) {
                this.changeState(p, 0);
            }
            ++n2;
        }
        this.initBoard();
    }

    int[][] getState() {
        return this.state;
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public void setState(Address pos, int st) {
        this.setState(pos.r(), pos.c(), st);
    }

    public boolean isNumber(Address p) {
        return this.isOn(p) && (this.getState(p) > 0 || this.getState(p) == -3);
    }

    public boolean isWall(Address pos) {
        return this.isOn(pos) && this.getState(pos) == -2;
    }

    public int getSpaceOrWall(Address p) {
        int st = this.getState(p);
        if (st > 0) {
            return -1;
        }
        if (st == -3) {
            return -1;
        }
        return st;
    }

    public boolean isSpaceOrNumber(Address p) {
        if (this.isOn(p)) {
            int st = this.getState(p);
            return st > 0 || st == -1 || st == -3;
        }
        return false;
    }

    @Override
    public void initBoard() {
        this.initAreas();
    }

    public void initAreas() {
        ArrayUtil.initArrayObject2(this.area, null);
        this.wallAreaList.clear();
        this.spaceAreaList.clear();
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getState(p) != 0 && this.getArea(p) == null) {
                this.initArea(p);
            }
            ++n2;
        }
    }

    void initArea(Address p) {
        this.initializingArea = this.makeNewArea(p);
        this.initArea1(p);
    }

    private void initArea1(Address p) {
        if (!this.isOn(p)) {
            return;
        }
        if (this.getArea(p) == this.initializingArea) {
            return;
        }
        if (this.getSpaceOrWall(p) != this.initializingArea.getAreaType()) {
            return;
        }
        this.initializingArea.add(p);
        if (this.isNumber(p)) {
            this.initializingArea.addNumber(this.getState(p));
        }
        this.setArea(p, this.initializingArea);
        int d = 0;
        while (d < 4) {
            this.initArea1(p.nextCell(d));
            ++d;
        }
    }

    public Area getArea(Address p) {
        if (!this.isOn(p)) {
            return null;
        }
        return this.area[p.r()][p.c()];
    }

    public void setArea(Address p, Area a) {
        this.area[p.r()][p.c()] = a;
    }

    public void changeState(Address p, int st) {
        if (this.getState(p) == st) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(p, this.getState(p), st));
        }
        int prevSt = this.getSpaceOrWall(p);
        this.setState(p, st);
        int type = st > 0 ? -1 : st;
        if (prevSt != 0) {
            this.splitArea(p, prevSt);
        }
        if (st != 0) {
            this.mergeArea(p, type);
        }
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeState(s.getPos(), s.getBefore());
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeState(s.getPos(), s.getAfter());
        }
    }

    void mergeArea(Address p, int type) {
        Area a;
        Area mergedArea = null;
        int d = 0;
        while (d < 4) {
            a = this.getArea(p.nextCell(d));
            if (a != null && a.getAreaType() == type && (mergedArea == null || a.size() > mergedArea.size())) {
                mergedArea = a;
            }
            ++d;
        }
        if (mergedArea == null) {
            mergedArea = this.makeNewArea(p);
        }
        d = 0;
        while (d < 4) {
            a = this.getArea(p.nextCell(d));
            if (a != null && a != mergedArea && a.getAreaType() == type) {
                mergedArea.addAll(a);
                for (Address pos : a) {
                    this.setArea(pos, mergedArea);
                    if (!this.isNumber(pos)) continue;
                    mergedArea.addNumber(this.getState(pos));
                }
                this.removeAreaFromList(a);
            }
            ++d;
        }
        mergedArea.add(p);
        if (this.isNumber(p)) {
            mergedArea.addNumber(this.getState(p));
        }
        this.setArea(p, mergedArea);
    }

    void splitArea(Address p, int type) {
        Area oldArea = this.getArea(p);
        Area largerArea = null;
        this.removeAreaFromList(oldArea);
        for (Address p1 : oldArea) {
            this.setArea(p1, null);
        }
        int d = 0;
        while (d < 4) {
            Address p1 = Address.nextCell(p, d);
            if (this.isOn(p1) && this.getSpaceOrWall(p1) == type && this.getArea(p1) == null) {
                this.initArea(p1);
                if (largerArea == null || this.initializingArea.size() > largerArea.size()) {
                    largerArea = this.initializingArea;
                }
            }
            ++d;
        }
        if (largerArea != null) {
            largerArea.setId(oldArea.getId());
        }
    }

    private Area makeNewArea(Address p) {
        if (this.isWall(p)) {
            Area a = new Area(-2);
            this.wallAreaList.add(a);
            return a;
        }
        if (this.isSpaceOrNumber(p)) {
            Area a = new Area(-1);
            this.spaceAreaList.add(a);
            return a;
        }
        return null;
    }

    private void removeAreaFromList(Area a) {
        int type = a.getAreaType();
        if (type == -2) {
            this.wallAreaList.remove(a);
        } else if (type == -1) {
            this.spaceAreaList.remove(a);
        }
    }

    boolean is2x2Block(Address p) {
        if (this.isWall(p)) {
            int d = 0;
            while (d < 4) {
                Address p3;
                Address p2;
                Address p1 = Address.nextCell(p, d);
                if (this.isWall(p1) && this.isWall(p2 = Address.nextCell(p1, (d + 1) % 4)) && this.isWall(p3 = Address.nextCell(p2, (d + 2) % 4))) {
                    return true;
                }
                ++d;
            }
        }
        return false;
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.is2x2Block(p)) {
                result |= 0x40;
            }
            ++n2;
        }
        if (this.wallAreaList.size() > 1) {
            result |= 0x20;
        }
        return result |= this.checkWhiteAreas();
    }

    private int checkWhiteAreas() {
        ArrayUtil.initArrayObject2(this.whiteArea, null);
        int ret = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getState(p) != -2 && this.whiteArea[p.r()][p.c()] == null) {
                this.initializingArea = new Area(-1);
                this.initWhiteArea1(p);
                ret |= this.checkSpaceArea(this.initializingArea);
            }
            ++n2;
        }
        return ret;
    }

    private int checkSpaceArea(Area a) {
        int ret = 0;
        int number = a.getNumber();
        if (number == 0) {
            ret |= 0x10;
        } else if (number == Area.MULTIPLE_NUMBER) {
            ret |= 8;
        } else if (number != -3 && number > 0) {
            if (a.size() < number) {
                ret |= 4;
            } else if (a.size() > number) {
                ret |= 2;
            }
        }
        return ret;
    }

    private void initWhiteArea1(Address p) {
        if (!this.isOn(p)) {
            return;
        }
        if (this.whiteArea[p.r()][p.c()] == this.initializingArea) {
            return;
        }
        if (this.getState(p) == -2) {
            return;
        }
        this.initializingArea.add(p);
        if (this.isNumber(p)) {
            this.initializingArea.addNumber(this.getState(p));
        }
        this.whiteArea[p.r()][p.c()] = this.initializingArea;
        int d = 0;
        while (d < 4) {
            this.initWhiteArea1(p.nextCell(d));
            ++d;
        }
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        if (result == 1) {
            return Messages.getString("nurikabe.AnswerCheckMessage1");
        }
        StringBuffer message = new StringBuffer();
        if ((result & 2) == 2 || (result & 4) == 4) {
            message.append(Messages.getString("nurikabe.AnswerCheckMessage2"));
        }
        if ((result & 8) == 8) {
            message.append(Messages.getString("nurikabe.AnswerCheckMessage4"));
        }
        if ((result & 0x10) == 16) {
            message.append(Messages.getString("nurikabe.AnswerCheckMessage5"));
        }
        if ((result & 0x20) == 32) {
            message.append(Messages.getString("nurikabe.AnswerCheckMessage6"));
        }
        if ((result & 0x40) == 64) {
            message.append(Messages.getString("nurikabe.AnswerCheckMessage7"));
        }
        return message.toString();
    }
}

