/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import pencilbox.common.core.Address;
import pencilbox.common.core.AreaBase;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator;
import pencilbox.kakuro.Board;

public class BoardCopier
extends BoardCopierBase {
    @Override
    public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
        Address p;
        int c;
        Board s = (Board)src;
        Board d = (Board)dst;
        Rotator rotator2 = new Rotator(src.rows() - 1, src.cols() - 1, n);
        int sum = 0;
        int r = 1;
        while (r < src.rows()) {
            c = 1;
            while (c < src.cols()) {
                p = Address.address(r - 1, c - 1);
                p = rotator2.rotateAddress(p);
                if (d.isOn(p = Address.address(p.r() + 1, p.c() + 1))) {
                    sum = s.getNumber(r, c);
                    d.setNumber(p.r(), p.c(), sum);
                }
                ++c;
            }
            ++r;
        }
        r = 1;
        while (r < src.rows()) {
            c = 1;
            while (c < src.cols()) {
                p = Address.address(r - 1, c - 1);
                p = rotator2.rotateAddress(p);
                if (d.isOn(p = Address.address(p.r() + 1, p.c() + 1))) {
                    if (!s.isWall(r, c) && s.isWall(r - 1, c)) {
                        sum = s.getSumV(r - 1, c);
                        this.setSum(d, p.r(), p.c(), sum, 0, n);
                    }
                    if (!s.isWall(r, c) && s.isWall(r, c - 1)) {
                        sum = s.getSumH(r, c - 1);
                        this.setSum(d, p.r(), p.c(), sum, 1, n);
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    private void setSum(Board d, int r, int c, int sum, int dir, int rotation) {
        if (dir == 0 ^ Rotator.isTransposed(rotation)) {
            int rr = r;
            while (!d.isWall(rr, c)) {
                --rr;
            }
            d.setSumV(rr, c, sum);
        } else {
            int cc = c;
            while (!d.isWall(r, cc)) {
                --cc;
            }
            d.setSumH(r, cc, sum);
        }
    }

    @Override
    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, AreaBase region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        for (Address s : region) {
            Address d = this.translateAndRotateAddress(s, from, to, rotation);
            if (!board.isOn(d)) continue;
            if (srcBoard.isWall(s)) {
                int h = 0;
                int v = 0;
                if (rotation == 0 || rotation == 5) {
                    v = srcBoard.getSumV(s);
                } else if (rotation == 1 || rotation == 4) {
                    h = srcBoard.getSumV(s);
                }
                if (rotation == 0 || rotation == 7) {
                    h = srcBoard.getSumH(s);
                } else if (rotation == 3 || rotation == 4) {
                    v = srcBoard.getSumH(s);
                }
                board.changeWall(d, v | h << 8);
                continue;
            }
            if (d.r() <= 0 || d.c() <= 0) continue;
            board.changeAnswerNumber(d, srcBoard.getNumber(s));
        }
    }

    @Override
    public void eraseRegion(BoardBase boardBase, AreaBase region) {
        Board board = (Board)boardBase;
        for (Address s : region) {
            if (board.isWall(s)) {
                if (s.r() > 0 && s.c() > 0) {
                    board.changeWall(s, -2);
                    continue;
                }
                board.changeWall(s, 0);
                continue;
            }
            board.changeAnswerNumber(s, 0);
        }
    }
}

