/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.kakuro.Board;
import pencilbox.kakuro.KakuroCursor;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.setMaxInputNumber(9);
    }

    @Override
    protected int getMaxInputNumber() {
        if (this.isProblemEditMode()) {
            return 45;
        }
        return 9;
    }

    @Override
    protected void leftPressed(Address pos) {
        if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isWall(pos))) {
            int n = this.board.getNumber(pos);
            if (n >= this.board.getMaxNumber()) {
                this.board.changeAnswerNumber(pos, 0);
            } else if (n >= 0) {
                this.board.changeAnswerNumber(pos, n + 1);
            }
        }
    }

    @Override
    protected void rightPressed(Address pos) {
        if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isWall(pos))) {
            int n = this.board.getNumber(pos);
            if (n == 0) {
                this.board.changeAnswerNumber(pos, this.board.getMaxNumber());
            } else if (n > 0) {
                this.board.changeAnswerNumber(pos, n - 1);
            }
        }
    }

    @Override
    protected void arrowKeyEntered(int direction) {
        super.arrowKeyEntered(direction);
        if (direction == 1) {
            this.getKKCursor().setStair(1);
        } else if (direction == 0) {
            this.getKKCursor().setStair(0);
        }
    }

    @Override
    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            Address posS;
            if (this.getKKCursor().getStair() == 0) {
                this.board.changeSum(pos, 0, num);
            } else if (this.getKKCursor().getStair() == 1) {
                this.board.changeSum(pos, 1, num);
            }
            if (this.isSymmetricPlacementMode() && this.isOn(posS = this.getSymmetricPosition(pos)) && !this.board.isWall(posS)) {
                this.board.changeWall(posS, 0);
            }
        } else if (this.isCursorOn() && !this.board.isWall(pos)) {
            this.board.changeAnswerNumber(pos, num);
        }
    }

    @Override
    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            if (pos.r() == 0 || pos.c() == 0) {
                return;
            }
            this.board.changeWall(pos, -2);
            if (this.isSymmetricPlacementMode() && this.isOn(posS = this.getSymmetricPosition(pos)) && this.board.isWall(posS)) {
                this.board.changeWall(posS, -2);
            }
        } else if (this.isCursorOn() && !this.board.isWall(pos)) {
            this.board.changeAnswerNumber(pos, 0);
        }
    }

    @Override
    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            if (this.getKKCursor().getStair() == 0) {
                this.board.changeSum(pos, 0, 0);
            } else if (this.getKKCursor().getStair() == 1) {
                this.board.changeSum(pos, 1, 0);
            }
            if (this.isSymmetricPlacementMode() && this.isOn(posS = this.getSymmetricPosition(pos)) && !this.board.isWall(posS)) {
                this.board.changeWall(posS, 0);
            }
        }
    }

    KakuroCursor getKKCursor() {
        return (KakuroCursor)this.getCellCursor();
    }

    @Override
    public Address getSymmetricPosition(Address pos) {
        return Address.address(this.board.rows() - pos.r(), this.board.cols() - pos.c());
    }
}

