/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.tentaisho;

import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.AreaEditStep;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BorderEditStep;
import pencilbox.common.core.CellEditStep;
import pencilbox.common.core.SideAddress;
import pencilbox.resource.Messages;
import pencilbox.tentaisho.Area;
import pencilbox.tentaisho.StarAddress;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int NOSTAR = 0;
    static final int WHITESTAR = 1;
    static final int BLACKSTAR = 2;
    static final int LINE = 1;
    static final int NOLINE = 0;
    private int[][] star;
    private int[][][] edge;
    private Area[][] area;
    private List<Area> areaList;

    @Override
    protected void setup() {
        super.setup();
        this.star = new int[this.rows() * 2 - 1][this.cols() * 2 - 1];
        this.edge = new int[2][][];
        this.edge[0] = new int[this.rows()][this.cols() - 1];
        this.edge[1] = new int[this.rows() - 1][this.cols()];
        this.area = new Area[this.rows()][this.cols()];
        this.areaList = new LinkedList<Area>();
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        this.areaList.clear();
        ArrayUtil.initArrayObject2(this.area, null);
        SideAddress[] sideAddressArray = this.borderAddrs();
        int n = sideAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            SideAddress p = sideAddressArray[n2];
            this.setEdge(p, 0);
            ++n2;
        }
    }

    @Override
    public void trimAnswer() {
        SideAddress[] sideAddressArray = this.borderAddrs();
        int n = sideAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            SideAddress p = sideAddressArray[n2];
            if (this.getEdge(p) == 1) {
                this.changeEdge(p, 0);
            }
            ++n2;
        }
    }

    @Override
    public void initBoard() {
        this.initAreas();
    }

    public void initAreas() {
        for (Area a : this.areaList) {
            this.initArea(a);
        }
    }

    int[][] getStar() {
        return this.star;
    }

    public int getStar(int r, int c) {
        return this.star[r][c];
    }

    public int getStar(Address pos) {
        return this.getStar(pos.r(), pos.c());
    }

    public void setStar(int r, int c, int st) {
        this.star[r][c] = st;
    }

    public void setStar(Address pos, int st) {
        this.setStar(pos.r(), pos.c(), st);
    }

    public void changeStar(Address p, int st) {
        int prev = this.getStar(p);
        if (prev == st) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(p, prev, st));
        }
        this.setStar(p, st);
        Address p0 = this.starAddressToSuperAddress(p);
        if (this.getArea(p0) != null) {
            this.initArea(this.getArea(p0));
        }
    }

    private Address starAddressToSuperAddress(Address p) {
        return Address.address(p.r() / 2, p.c() / 2);
    }

    public boolean isOnStar(int r, int c) {
        return r >= 0 && r < this.rows() * 2 - 1 && c >= 0 && c < this.cols() * 2 - 1;
    }

    public boolean isOnStar(Address pos) {
        return this.isOnStar(pos.r(), pos.c());
    }

    public int getEdge(SideAddress p) {
        return this.edge[p.d()][p.r()][p.c()];
    }

    public void setEdge(SideAddress p, int i) {
        this.edge[p.d()][p.r()][p.c()] = i;
    }

    public Area getArea(int r, int c) {
        return this.area[r][c];
    }

    public Area getArea(Address pos) {
        return this.getArea(pos.r(), pos.c());
    }

    public void setArea(int r, int c, Area a) {
        this.area[r][c] = a;
    }

    public void setArea(Address pos, Area a) {
        this.setArea(pos.r(), pos.c(), a);
    }

    public void addArea(Area newArea) {
        for (Address pos : newArea) {
            this.setArea(pos, newArea);
        }
        this.areaList.add(newArea);
    }

    public void removeWholeArea(Area oldArea) {
        Address[] cells;
        Address[] addressArray = cells = oldArea.toArray(new Address[0]);
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            this.removeCellFromArea(p, oldArea);
            ++n2;
        }
    }

    public void changeEdge(SideAddress p, int st) {
        int prev = this.getEdge(p);
        if (prev == st) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new BorderEditStep(p, prev, st));
        }
        this.setEdge(p, st);
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof AreaEditStep) {
            AreaEditStep s = (AreaEditStep)step;
            if (s.getOperation() == 1) {
                this.removeCell(s.getPos());
            } else if (s.getOperation() == 0) {
                this.addCell(s.getPos(), s.getP0());
            }
        } else if (step instanceof BorderEditStep) {
            BorderEditStep s = (BorderEditStep)step;
            this.changeEdge(s.getPos(), s.getBefore());
        } else if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeStar(s.getPos(), s.getBefore());
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof AreaEditStep) {
            AreaEditStep s = (AreaEditStep)step;
            if (s.getOperation() == 1) {
                this.addCell(s.getPos(), s.getP0());
            } else if (s.getOperation() == 0) {
                this.removeCell(s.getPos());
            }
        } else if (step instanceof BorderEditStep) {
            BorderEditStep s = (BorderEditStep)step;
            this.changeEdge(s.getPos(), s.getAfter());
        } else if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeStar(s.getPos(), s.getAfter());
        }
    }

    void addCell(Address p, Address p0) {
        if (p0.equals(Address.NOWHERE)) {
            Area a = new Area();
            this.addCellToArea(p, a);
        } else {
            Area a = this.getArea(p0);
            if (a != null) {
                this.addCellToArea(p, a);
            }
        }
    }

    void removeCell(Address p) {
        Area a = this.getArea(p);
        if (a != null) {
            this.removeCellFromArea(p, a);
        }
    }

    public void addCellToArea(Address p, Area a) {
        if (this.isRecordUndo()) {
            Address p0 = Address.NOWHERE;
            if (a.size() > 0) {
                p0 = a.getTopCell(Address.NOWHERE);
            }
            this.fireUndoableEditUpdate(new AreaEditStep(p, p0, 1));
        }
        if (a.isEmpty()) {
            this.areaList.add(a);
        }
        this.setArea(p, a);
        a.add(p);
        this.initArea(a);
    }

    public void removeCellFromArea(Address p, Area a) {
        if (this.isRecordUndo()) {
            Address p0 = Address.NOWHERE;
            if (a.size() > 1) {
                p0 = a.getTopCell(p);
            }
            this.fireUndoableEditUpdate(new AreaEditStep(p, p0, 0));
        }
        this.setArea(p, null);
        a.remove(p);
        if (a.isEmpty()) {
            this.areaList.remove(a);
        } else {
            this.initArea(a);
        }
    }

    void initArea(Area newArea) {
        int nStar = 0;
        StarAddress starPos = StarAddress.NOWHERE;
        for (Address pos : newArea) {
            int i = 2 * pos.r() - 1;
            while (i <= 2 * pos.r() + 1) {
                int j = 2 * pos.c() - 1;
                while (j <= 2 * pos.c() + 1) {
                    if (this.isOnStar(i, j) && this.getStar(i, j) > 0) {
                        if (nStar == 0) {
                            nStar = this.getStar(i, j);
                            starPos = StarAddress.address(i, j);
                        } else if (!(nStar != 1 && nStar != 2 || starPos.equals(i, j))) {
                            nStar = -1;
                            starPos = StarAddress.NOWHERE;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        newArea.setStarType(nStar);
        newArea.setStarPos(starPos);
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        for (Area a : this.areaList) {
            if (a.isPointSymmetry()) continue;
            result |= 1;
        }
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getArea(p) == null) {
                result |= 2;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("tentaisho.AnswerCheckMessage1"));
        } else if ((result & 2) == 2) {
            message.append(Messages.getString("tentaisho.AnswerCheckMessage2"));
        }
        return message.toString();
    }

    List<Area> getAreaList() {
        return this.areaList;
    }

    Area[][] getArea() {
        return this.area;
    }
}

