/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kurodoko;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.common.core.Direction;
import pencilbox.kurodoko.Number;
import pencilbox.resource.Messages;

public class Board
extends BoardBase {
    static final int HORIZ = 1;
    static final int VERT = 0;
    static final int WHITE = -1;
    static final int BLACK = -2;
    static final int UNKNOWN = 0;
    static final int OUT = -3;
    static int UNDECIDED_NUMBER = -4;
    private int[][] state;
    private int[][] chain;
    private int maxChain;
    private Number[][] number;
    private int[] adjacentChain = new int[4];
    static final String ERR_CONTINUOUS_BLACK = Messages.getString("kurodoko.AnswerCheckMessage1");
    static final String ERR_DIVIDED_BOARD = Messages.getString("kurodoko.AnswerCheckMessage2");
    static final String ERR_SMALL_SIZE = Messages.getString("kurodoko.AnswerCheckMessage3");
    static final String YET_LARGE_SIZE = Messages.getString("kurodoko.AnswerCheckMessage4");

    @Override
    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.chain = new int[this.rows()][this.cols()];
        this.number = new Number[this.rows()][this.cols()];
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (!this.isNumber(p)) {
                this.setState(p, 0);
            }
            ++n2;
        }
        this.initBoard();
    }

    @Override
    public void trimAnswer() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getState(p) == -1) {
                this.changeState(p, 0);
            }
            ++n2;
        }
        this.initNumber();
    }

    int[][] getState() {
        return this.state;
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public void setState(Address pos, int st) {
        this.setState(pos.r(), pos.c(), st);
    }

    public boolean isNumber(Address pos) {
        int n = this.getState(pos);
        return n > 0 || n == UNDECIDED_NUMBER;
    }

    public boolean isBlack(Address p) {
        return this.isOn(p) && this.getState(p) == -2;
    }

    public boolean isWhiteOrNumber(Address p) {
        int n = this.getState(p);
        return n == -1 || n > 0 || n == UNDECIDED_NUMBER;
    }

    @Override
    public void initBoard() {
        this.initChain();
        this.initNumber();
    }

    void initNumber() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.isNumber(p)) {
                this.setNumber(p, new Number(this.getState(p)));
                this.initNumber(p);
            } else {
                this.setNumber(p, null);
            }
            ++n2;
        }
    }

    void initNumber(Address p0) {
        Address p;
        int n = 1;
        int d = 0;
        while (d < 4) {
            p = p0;
            while (this.isOn(p) && !this.isBlack(p)) {
                if (!this.isOn(p = p.nextCell(d)) || this.isBlack(p)) break;
                ++n;
            }
            ++d;
        }
        this.getNumber(p0).setNSpace(n);
        n = 1;
        d = 0;
        while (d < 4) {
            p = p0;
            while (this.isOn(p = p.nextCell(d)) && this.isWhiteOrNumber(p)) {
                ++n;
            }
            ++d;
        }
        this.getNumber(p0).setNWhite(n);
    }

    public Number getNumber(Address p) {
        return this.number[p.r()][p.c()];
    }

    public void setNumber(Address p, Number n) {
        this.number[p.r()][p.c()] = n;
    }

    int getChain(Address p) {
        return this.chain[p.r()][p.c()];
    }

    void setChain(Address p, int n) {
        this.chain[p.r()][p.c()] = n;
    }

    public void changeState(Address p, int st) {
        int prev = this.getState(p);
        if (st == prev) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(p, prev, st));
        }
        this.setState(p, st);
        if (st == -2) {
            this.connectChain(p);
        } else if (prev == -2) {
            this.cutChain(p);
        }
        if (st > 0 || st == UNDECIDED_NUMBER) {
            this.setNumber(p, new Number(st));
            this.initNumber(p);
        } else if (prev > 0 || prev == UNDECIDED_NUMBER) {
            this.setNumber(p, null);
        }
        if (st == -2 || prev == -2) {
            this.updateSpace(p);
        }
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeState(s.getPos(), s.getBefore());
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeState(s.getPos(), s.getAfter());
        }
    }

    boolean isBlock(Address p) {
        int d = 0;
        while (d < 4) {
            if (this.isBlack(Address.nextCell(p, d))) {
                return true;
            }
            ++d;
        }
        return false;
    }

    void initChain() {
        Address p;
        this.maxChain = 1;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            this.setChain(p, 0);
            ++n2;
        }
        addressArray = this.cellAddrs();
        n = addressArray.length;
        n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            if (this.isOnPeriphery(p) && this.isBlack(p) && this.getChain(p) == 0 && this.initChain1(p, -1, 1) == -1) {
                this.updateChain(p, -1);
            }
            ++n2;
        }
        addressArray = this.cellAddrs();
        n = addressArray.length;
        n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            if (!this.isOnPeriphery(p) && this.isBlack(p) && this.getChain(p) == 0 && this.initChain1(p, -1, ++this.maxChain) == -1) {
                this.updateChain(p, -1);
            }
            ++n2;
        }
    }

    int initChain1(Address p, int d, int n) {
        if (n == 1 && d != -1 && this.isOnPeriphery(p)) {
            return -1;
        }
        if (n >= 0 && this.isOnPeriphery(p)) {
            this.setChain(p, 1);
        } else {
            this.setChain(p, n);
        }
        int[] nArray = Direction.DIAGONAL4;
        int n2 = Direction.DIAGONAL4.length;
        int n3 = 0;
        while (n3 < n2) {
            int dd = nArray[n3];
            Address pp = Address.nextCell(p, dd);
            if (dd != (d ^ 2) && this.isBlack(pp)) {
                if (this.getChain(pp) == n) {
                    return -1;
                }
                if (this.initChain1(pp, dd, n) == -1) {
                    return -1;
                }
            }
            ++n3;
        }
        return n;
    }

    void connectChain(Address p) {
        int[] adjacent = this.adjacentChain;
        int k = 0;
        int newChain = Integer.MAX_VALUE;
        if (this.isOnPeriphery(p)) {
            newChain = 1;
        }
        int[] nArray = Direction.DIAGONAL4;
        int n = Direction.DIAGONAL4.length;
        int n2 = 0;
        while (n2 < n) {
            int dd = nArray[n2];
            Address pp = Address.nextCell(p, dd);
            if (this.isBlack(pp)) {
                int c1 = this.getChain(pp);
                if (this.isOnPeriphery(p) && c1 == 1) {
                    newChain = -1;
                }
                adjacent[k] = c1;
                int l = 0;
                while (l < k) {
                    if (adjacent[k] == adjacent[l]) {
                        newChain = -1;
                    }
                    ++l;
                }
                ++k;
                if (c1 < newChain) {
                    newChain = c1;
                }
            }
            ++n2;
        }
        if (newChain == Integer.MAX_VALUE) {
            this.setChain(p, ++this.maxChain);
        } else {
            this.updateChain(p, newChain);
        }
    }

    void cutChain(Address p) {
        this.initChain();
    }

    void updateChain(Address p, int n) {
        this.setChain(p, n);
        int[] nArray = Direction.DIAGONAL4;
        int n2 = Direction.DIAGONAL4.length;
        int n3 = 0;
        while (n3 < n2) {
            int dd = nArray[n3];
            Address pp = Address.nextCell(p, dd);
            if (this.isBlack(pp) && this.getChain(pp) != n) {
                this.updateChain(pp, n);
            }
            ++n3;
        }
    }

    void updateSpace(Address p0) {
        int d = 0;
        while (d < 4) {
            Address p = p0;
            while (this.isOn(p = Address.nextCell(p, d)) && !this.isBlack(p)) {
                if (!this.isNumber(p)) continue;
                this.initNumber(p);
            }
            ++d;
        }
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.isBlack(p)) {
                if (this.isBlock(p)) {
                    result |= 1;
                }
                if (this.getChain(p) == -1) {
                    result |= 2;
                }
            }
            if (this.getState(p) > 0) {
                int remainder = this.getNumber(p).getNSpace() - this.getNumber(p).getNumber();
                if (remainder < 0) {
                    result |= 4;
                } else if (remainder > 0) {
                    result |= 8;
                }
            }
            ++n2;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return BoardBase.COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(ERR_CONTINUOUS_BLACK);
        }
        if ((result & 2) == 2) {
            message.append(ERR_DIVIDED_BOARD);
        }
        if ((result & 4) == 4) {
            message.append(ERR_SMALL_SIZE);
        }
        if ((result & 8) == 8) {
            message.append(YET_LARGE_SIZE);
        }
        return message.toString();
    }
}

