/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kurodoko;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.kurodoko.Board;

public class Panel
extends PanelBase {
    private Board board;

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setMarkStyle(3);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.drawCells(g);
        this.drawGrid(g);
        this.drawBoardBorder(g);
    }

    private void drawCells(Graphics2D g) {
        g.setFont(this.getNumberFont());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int st = this.board.getState(p);
            if (st == -2) {
                this.paintCell1(g, p);
            } else if (st == -1) {
                g.setColor(this.getCircleColor());
                this.placeMark(g, p);
            } else if (st > 0 || st == Board.UNDECIDED_NUMBER) {
                this.placeNumber1(g, p, st);
            }
            ++n2;
        }
    }

    private void paintCell1(Graphics2D g, Address p) {
        g.setColor(this.getPaintColor());
        if (this.isIndicateErrorMode() && (this.board.isBlock(p) || this.board.getChain(p) < 0)) {
            g.setColor(this.getErrorColor());
        }
        this.paintCell(g, p);
    }

    private void placeNumber1(Graphics2D g, Address p, int num) {
        if (this.getMarkStyle() == 5) {
            g.setColor(this.getCircleColor());
            this.paintCell(g, p);
        }
        g.setColor(this.getNumberColor());
        this.placeCircle(g, p, this.getCellSize() - 2);
        if (num > 0) {
            int nSpace;
            if (this.isIndicateErrorMode() && (nSpace = this.board.getNumber(p).getNSpace()) != num) {
                g.setColor(this.getErrorColor());
            }
            this.placeNumber(g, p, num);
        }
    }
}

