/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slalom;

import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BorderEditStep;
import pencilbox.common.core.CellEditStep;
import pencilbox.common.core.SideAddress;
import pencilbox.resource.Messages;
import pencilbox.slalom.Link;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int UNKNOWN = 0;
    static final int LINE = 1;
    static final int NOLINE = -1;
    static final int BLANK = -3;
    static final int GOAL = -1;
    static final int OUTER = -9;
    static final int UNDECIDED_NUMBER = 0;
    static final int GATE_VERT = -5;
    static final int GATE_HORIZ = -4;
    private int[][] number;
    private int[][][] state;
    private int[][] gateNumber;
    private int nGate;
    private Address goal;
    private List<Link> linkList;
    private Link[][][] link;
    private Link initializingLink;

    @Override
    protected void setup() {
        super.setup();
        this.number = new int[this.rows()][this.cols()];
        this.gateNumber = new int[this.rows()][this.cols()];
        ArrayUtil.initArrayInt2(this.number, -3);
        this.goal = Address.nowhere();
        this.state = new int[2][][];
        this.state[0] = new int[this.rows()][this.cols() - 1];
        this.state[1] = new int[this.rows() - 1][this.cols()];
        this.linkList = new LinkedList<Link>();
        this.link = new Link[2][][];
        this.link[0] = new Link[this.rows()][this.cols() - 1];
        this.link[1] = new Link[this.rows() - 1][this.cols()];
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public boolean isWall(Address p) {
        return this.getNumber(p) >= 0 || this.getNumber(p) == 0;
    }

    public boolean isGate(int r, int c) {
        return this.number[r][c] == -4 || this.number[r][c] == -5;
    }

    public boolean isGate(Address pos) {
        return this.isGate(pos.r(), pos.c());
    }

    public boolean hasWall(SideAddress p) {
        return this.isWall(SideAddress.nextCellFromBorder(p, 0)) || this.isWall(SideAddress.nextCellFromBorder(p, 1));
    }

    public int getGateNumber(Address p) {
        return this.gateNumber[p.r()][p.c()];
    }

    public int getGateNumber(int r, int c) {
        return this.gateNumber[r][c];
    }

    public int setGateNumber(Address p, int n) {
        int n2 = n;
        this.gateNumber[p.r()][p.c()] = n2;
        return n2;
    }

    public int setGateNumber(int r, int c, int n) {
        int n2 = n;
        this.gateNumber[r][c] = n2;
        return n2;
    }

    public int getNGate() {
        return this.nGate;
    }

    public Address getGoal() {
        return this.goal;
    }

    public int getState(int d, int r, int c) {
        if (this.isSideOn(d, r, c)) {
            return this.state[d][r][c];
        }
        return -9;
    }

    public int getState(SideAddress pos) {
        return this.getState(pos.d(), pos.r(), pos.c());
    }

    public void setState(int d, int r, int c, int st) {
        if (this.isSideOn(d, r, c)) {
            this.state[d][r][c] = st;
        }
    }

    public void setState(SideAddress pos, int st) {
        this.setState(pos.d(), pos.r(), pos.c(), st);
    }

    public Link getLink(SideAddress pos) {
        if (this.isSideOn(pos)) {
            return this.link[pos.d()][pos.r()][pos.c()];
        }
        return null;
    }

    public Link getLink(Address p) {
        int d = 0;
        while (d < 4) {
            Link link = this.getLink(SideAddress.get(p, d));
            if (link != null) {
                return link;
            }
            ++d;
        }
        return null;
    }

    public void setLink(SideAddress pos, Link l) {
        this.link[pos.d()][pos.r()][pos.c()] = l;
    }

    public void changeNumber(Address p, int st) {
        int prev = this.getNumber(p);
        if (prev == st) {
            return;
        }
        if (prev == -1) {
            this.goal = Address.nowhere();
        }
        if (st == -1) {
            if (!this.goal.isNowhere()) {
                this.changeNumber(this.goal, -3);
            }
            this.goal = p;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(p, prev, st));
        }
        this.setNumber(p, st);
    }

    void eraseLinesAround(Address pos) {
        int d = 0;
        while (d <= 3) {
            SideAddress side = SideAddress.get(pos, d);
            if (this.getState(side) == 1 || this.getState(side) == -1) {
                this.changeState(side, 0);
            }
            ++d;
        }
    }

    public void changeState(SideAddress p, int st) {
        int prev = this.getState(p);
        if (st == prev) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new BorderEditStep(p, prev, st));
        }
        this.setState(p, st);
        if (prev == 1) {
            this.cutLink(p);
        }
        if (st == 1) {
            this.connectLink(p);
        }
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof BorderEditStep) {
            BorderEditStep s = (BorderEditStep)step;
            this.changeState(s.getPos(), s.getBefore());
        } else if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeNumber(s.getPos(), s.getBefore());
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof BorderEditStep) {
            BorderEditStep s = (BorderEditStep)step;
            this.changeState(s.getPos(), s.getAfter());
        } else if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            this.changeNumber(s.getPos(), s.getAfter());
        }
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        ArrayUtil.initArrayInt3(this.state, 0);
        this.initBoard();
    }

    @Override
    public void trimAnswer() {
        SideAddress[] sideAddressArray = this.borderAddrs();
        int n = sideAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            SideAddress p = sideAddressArray[n2];
            if (this.getState(p) == -1) {
                this.changeState(p, 0);
            }
            ++n2;
        }
    }

    @Override
    public void initBoard() {
        this.initGates();
        this.initLinks();
    }

    void initGates() {
        int n;
        Address p;
        this.nGate = 0;
        Address[] addressArray = this.cellAddrs();
        int n2 = addressArray.length;
        int n3 = 0;
        while (n3 < n2) {
            p = addressArray[n3];
            this.setGateNumber(p, 0);
            ++n3;
        }
        addressArray = this.cellAddrs();
        n2 = addressArray.length;
        n3 = 0;
        while (n3 < n2) {
            Address p1;
            p = addressArray[n3];
            n = this.getNumber(p);
            if (n == -1) {
                this.goal = p;
            } else if (n == -4) {
                p1 = Address.nextCell(p, 1);
                if (!this.isOn(p1) || this.getNumber(p1) != -4) {
                    ++this.nGate;
                }
            } else if (!(n != -5 || this.isOn(p1 = Address.nextCell(p, 0)) && this.getNumber(p1) == -5)) {
                ++this.nGate;
            }
            ++n3;
        }
        addressArray = this.cellAddrs();
        n2 = addressArray.length;
        n3 = 0;
        while (n3 < n2) {
            p = addressArray[n3];
            n = this.getNumber(p);
            if (n > 0) {
                this.initGateNumber(p, n);
            }
            ++n3;
        }
    }

    Address getAnotherPole(Address p0, int d) {
        Address p = p0;
        int gateType = 0;
        if (d == 0 || d == 2) {
            gateType = -5;
        } else if (d == 1 || d == 3) {
            gateType = -4;
        }
        while (this.isOn(p = Address.nextCell(p, d))) {
            if (this.isWall(p)) {
                return p;
            }
            if (this.getNumber(p) == gateType) continue;
            return null;
        }
        return p;
    }

    private void setGateNumber(Address p0, int d, int n) {
        int t = 0;
        t = d == 0 || d == 2 ? -5 : -4;
        Address p = p0;
        while (this.isOn(p = p.nextCell(d)) && this.getNumber(p) == t) {
            this.setGateNumber(p, n);
        }
    }

    private void initGateNumber(Address p0, int n0) {
        Address p = p0;
        Address p1 = null;
        int d1 = -1;
        int ng = 0;
        int count = 0;
        int d = 0;
        while (d <= 3) {
            int t = 0;
            t = d == 0 || d == 2 ? -5 : -4;
            p = p0;
            if (this.isOn(p = p.nextCell(d)) && this.getNumber(p) == t) {
                d1 = d;
                ++count;
                p1 = this.getAnotherPole(p, d);
                if (p1 != null && this.isOn(p1)) {
                    int n1 = this.getNumber(p1);
                    if (n1 == n0) {
                        ng = n1;
                        this.setGateNumber(p0, d, n1);
                    } else if (n1 > 0 && n1 != n0) {
                        ng = -1;
                        this.setGateNumber(p0, d, -1);
                    }
                }
            }
            ++d;
        }
        if (count != 0 && count == 1) {
            if (ng == 0) {
                this.setGateNumber(p0, d1, n0);
            } else if (ng != -1) {
                // empty if block
            }
        }
    }

    void initLinks() {
        Link.resetId();
        this.linkList.clear();
        ArrayUtil.initArrayObject2(this.link[0], null);
        ArrayUtil.initArrayObject2(this.link[1], null);
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            this.initLink(p);
            ++n2;
        }
    }

    void initLink(Address p) {
        this.initializingLink = new Link();
        int d = 0;
        while (d < 4) {
            this.initLink1(SideAddress.get(p, d));
            ++d;
        }
        if (!this.initializingLink.isEmpty()) {
            this.linkList.add(this.initializingLink);
        }
    }

    private void initLink1(SideAddress p) {
        if (!this.isSideOn(p)) {
            return;
        }
        if (this.getState(p) != 1) {
            return;
        }
        if (this.getLink(p) != null) {
            return;
        }
        this.initializingLink.add(p);
        this.setLink(p, this.initializingLink);
        int d = 0;
        while (d < 6) {
            this.initLink1(SideAddress.nextBorder(p, d));
            ++d;
        }
    }

    void connectLink(SideAddress p) {
        Link link;
        Link newLink = new Link();
        int d = 0;
        while (d < 2) {
            link = this.getLink(SideAddress.nextCellFromBorder(p, d));
            if (link != null && link.size() > newLink.size()) {
                newLink = link;
            }
            ++d;
        }
        if (newLink.isEmpty()) {
            this.linkList.add(newLink);
        }
        d = 0;
        while (d < 2) {
            link = this.getLink(SideAddress.nextCellFromBorder(p, d));
            if (link != null && link != newLink) {
                for (SideAddress b : link) {
                    this.setLink(b, newLink);
                    newLink.add(b);
                }
                this.linkList.remove(link);
            }
            ++d;
        }
        newLink.add(p);
        this.setLink(p, newLink);
    }

    void cutLink(SideAddress p) {
        Link oldLink = this.getLink(p);
        Link longerLink = new Link();
        for (SideAddress b : oldLink) {
            this.setLink(b, null);
        }
        this.linkList.remove(oldLink);
        int d = 0;
        while (d < 2) {
            Address p1 = SideAddress.nextCellFromBorder(p, d);
            this.initLink(p1);
            if (this.initializingLink.size() > longerLink.size()) {
                longerLink = this.initializingLink;
            }
            ++d;
        }
        longerLink.setId(oldLink.getId());
    }

    public int countLine(Address p) {
        int no = 0;
        int d = 0;
        while (d < 4) {
            SideAddress b = SideAddress.get(p, d);
            if (this.getState(b) == 1) {
                ++no;
            }
            ++d;
        }
        return no;
    }

    private int checkLinks() {
        int result = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int l = this.countLine(p);
            if (l > 2) {
                result |= 1;
            } else if (l == 1) {
                result |= 2;
            }
            ++n2;
        }
        if (this.linkList.size() > 1) {
            result |= 4;
        } else if (this.linkList.size() == 0) {
            result |= 8;
        }
        return result;
    }

    private int checkGates() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.isGate(p)) {
                int ret = this.checkGate1(p);
                if (ret == -1) {
                    return 16;
                }
                if (ret == 0) {
                    return 32;
                }
                if (ret > 1) {
                    return 64;
                }
            }
            ++n2;
        }
        return 0;
    }

    private int checkGate1(Address p0) {
        int gateType = this.getNumber(p0);
        int d = 0;
        if (gateType == -4) {
            d = 3;
        } else if (gateType == -5) {
            d = 2;
        }
        Address p2 = Address.nextCell(p0, d ^ 2);
        if (this.isOn(p2) && this.getNumber(p2) == gateType) {
            return -2;
        }
        int count = 0;
        Address p = p0;
        do {
            int ret;
            if ((ret = this.checkGate2(p)) == -1) {
                return -1;
            }
            if (ret != 1) continue;
            ++count;
        } while (this.isOn(p = p.nextCell(d)) && this.getNumber(p) == gateType);
        return count;
    }

    private int checkGate2(Address p) {
        int type = this.getNumber(p);
        int[] st4 = new int[4];
        int d = 0;
        while (d < 4) {
            st4[d] = this.getState(SideAddress.get(p, d));
            ++d;
        }
        if (type == -5) {
            if (st4[0] == 1 || st4[2] == 1) {
                return -1;
            }
            if (st4[1] == 1 && st4[3] == 1) {
                return 1;
            }
        } else if (type == -4) {
            if (st4[1] == 1 || st4[3] == 1) {
                return -1;
            }
            if (st4[0] == 1 && st4[2] == 1) {
                return 1;
            }
        }
        return 0;
    }

    private int checkRoute() {
        Address p0;
        int[] gateNumber = new int[this.nGate];
        int k = 0;
        if (this.goal.isNowhere()) {
            p0 = this.\uff54emporalGoal();
        } else {
            p0 = this.goal;
            if (this.getLink(p0) == null) {
                System.out.println("\u30b4\u30fc\u30eb\u3092\u901a\u904e\u3057\u3066\u3044\u306a\u3044\u3002");
                return 512;
            }
        }
        System.out.println("\u30b9\u30bf\u30fc\u30c8\uff0f\u30b4\u30fc\u30eb\u5730\u70b9\u306f " + p0.toString());
        Address p = p0;
        int d = -1;
        do {
            if (!this.isGate(p = Address.nextCell(p, d = this.getLineDirection(p, d)))) continue;
            System.out.println("\u30b2\u30fc\u30c8 " + this.getGateNumber(p) + " \u901a\u904e");
            gateNumber[k] = this.getGateNumber(p);
            if (++k <= this.nGate) continue;
            System.out.println("\u9580" + this.nGate + "\u306e\u3046\u3061" + k + "\u7b87\u6240\u3081\u3092\u901a\u904e\u3057\u305f\u3002\u901a\u904e\u3057\u305f\u9580\u304c\u591a\u3059\u304e\u308b");
            return 128;
        } while (!p.equals(p0));
        System.out.println("\u30b4\u30fc\u30eb\u5230\u9054");
        if (k < this.nGate) {
            System.out.println("\u9580" + this.nGate + "\u306e\u3046\u3061" + k + "\u7b87\u6240\u901a\u904e\u3057\u305f\u3002\u901a\u904e\u3057\u305f\u9580\u304c\u5c11\u306a\u3059\u304e\u308b");
            return 128;
        }
        k = 0;
        while (k < this.nGate) {
            System.out.print(gateNumber[k]);
            System.out.print(' ');
            ++k;
        }
        System.out.println(" \u306e\u9806\u756a\u306b\u9580\u3092\u901a\u904e\u3057\u305f\u3002");
        int gg = 1;
        if (this.goal.isNowhere() && this.nGate >= 1) {
            gg = this.nGate;
        }
        int g = 0;
        while (g < gg) {
            k = 0;
            while (k < this.nGate) {
                if (gateNumber[k] > 0 && gateNumber[k] != (k + g) % this.nGate + 1) break;
                ++k;
            }
            if (k == this.nGate) {
                System.out.println("\u9580\u306e\u901a\u904e\u9806\u304c\u6b63\u3057\u3044\u3002");
                return 0;
            }
            ++g;
        }
        g = 0;
        while (g < gg) {
            k = 0;
            while (k < this.nGate) {
                if (gateNumber[k] > 0 && gateNumber[k] != (this.nGate - 1 - k + g) % this.nGate + 1) break;
                ++k;
            }
            if (k == this.nGate) {
                System.out.println("\u9580\u306e\u901a\u904e\u9806\u304c\u6b63\u3057\u3044\u3002");
                return 0;
            }
            ++g;
        }
        System.out.println("\u9580\u306e\u901a\u904e\u9806\u304c\u8aa4\u3063\u3066\u3044\u308b\u3002");
        return 256;
    }

    private Address \uff54emporalGoal() {
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.countLine(p) > 1) {
                return p;
            }
            ++n2;
        }
        return Address.NOWHERE;
    }

    private int getLineDirection(Address p, int direction) {
        int d = 0;
        while (d < 4) {
            if (this.getState(SideAddress.get(p, d)) == 1 && direction != (d ^ 2)) {
                return d;
            }
            ++d;
        }
        return -1;
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        result |= this.checkLinks();
        if ((result |= this.checkGates()) == 0) {
            result |= this.checkRoute();
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("slalom.AnswerCheckMessage1"));
        }
        if ((result & 2) == 2) {
            message.append(Messages.getString("slalom.AnswerCheckMessage2"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("slalom.AnswerCheckMessage3"));
        }
        if ((result & 8) == 8) {
            message.append(Messages.getString("slalom.AnswerCheckMessage4"));
        }
        if ((result & 0x10) == 16) {
            message.append(Messages.getString("slalom.AnswerCheckMessage5"));
        }
        if ((result & 0x20) == 32) {
            message.append(Messages.getString("slalom.AnswerCheckMessage6"));
        }
        if ((result & 0x40) == 64) {
            message.append(Messages.getString("slalom.AnswerCheckMessage7"));
        }
        if ((result & 0x100) == 256) {
            message.append(Messages.getString("slalom.AnswerCheckMessage8"));
        }
        if ((result & 0x200) == 512) {
            message.append(Messages.getString("slalom.AnswerCheckMessage9"));
        }
        return message.toString();
    }
}

