/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.satogaeri;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.AreaEditStep;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.common.core.Direction;
import pencilbox.resource.Messages;
import pencilbox.satogaeri.Area;

public class Board
extends BoardBase {
    static final int BLANK = -1;
    static final int UNDETERMINED = -2;
    static final int OUTER = -9;
    private List<Area> areaList;
    private int[] number;
    private Area[] area;
    private int[] route;
    public static final int NOROUTE = -1;
    public static final int UP = 0;
    public static final int LT = 1;
    public static final int DN = 2;
    public static final int RT = 3;
    public static final int END = 8;

    @Override
    protected void setup() {
        super.setup();
        this.number = new int[this.rows() * this.cols()];
        this.area = new Area[this.rows() * this.cols()];
        this.areaList = new LinkedList<Area>();
        Arrays.fill(this.number, -1);
        this.route = new int[this.rows() * this.cols()];
        Arrays.fill(this.route, -1);
    }

    @Override
    public void clearBoard() {
        Arrays.fill(this.route, -1);
        this.initBoard();
    }

    public int getNumber(int r, int c) {
        return this.getNumber(this.cell(r, c));
    }

    public int getNumber(Address pos) {
        return this.getNumber(this.cell(pos));
    }

    private int getNumber(int i) {
        if (this.isOn(i)) {
            return this.number[i];
        }
        return -9;
    }

    public boolean hasNumber(Address pos) {
        return this.getNumber(pos) != -1;
    }

    public void setNumber(int r, int c, int n) {
        this.setNumber(this.cell(r, c), n);
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(this.cell(pos), n);
    }

    public void setNumber(int i, int n) {
        if (this.isOn(i)) {
            this.number[i] = n;
        }
    }

    public int getRoute(Address pos) {
        if (this.isOn(pos)) {
            return this.route[this.cell(pos)];
        }
        return -9;
    }

    public void setRoute(Address pos, int b) {
        if (this.isOn(pos)) {
            this.route[this.cell((Address)pos)] = b;
        }
    }

    public Area getArea(int r, int c) {
        return this.area[this.cell(r, c)];
    }

    public Area getArea(Address pos) {
        return this.area[this.cell(pos)];
    }

    public void setArea(int r, int c, Area a) {
        this.area[this.cell((int)r, (int)c)] = a;
    }

    public void setArea(Address pos, Area a) {
        this.area[this.cell((Address)pos)] = a;
    }

    public boolean isError(Address p) {
        return false;
    }

    public int getIncomingDirection(Address p0) {
        int ret = 8;
        Address p = p0;
        int[] nArray = Direction.UP_LT_DN_RT;
        int n = Direction.UP_LT_DN_RT.length;
        int n2 = 0;
        while (n2 < n) {
            int d = nArray[n2];
            p = Address.nextCell(p0, d ^ 2);
            if (this.getRoute(p) == d && ret == 8) {
                ret = d;
            }
            ++n2;
        }
        return ret;
    }

    public void changeFixedNumber(Address p, int n) {
        int prev = this.getNumber(p);
        if (n == prev) {
            return;
        }
        if (this.getRoute(p) != -1) {
            this.eraseRoute(p);
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.FIXED, p, prev, n));
        }
        this.setNumber(p, n);
    }

    public void changeRoute(Address p, int st) {
        int prev = this.getRoute(p);
        if (st == prev) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.STATE, p, prev, st));
        }
        if (st >= 0 && st <= 3) {
            Address q = p.nextCell(st);
            if (this.getRoute(q) == -1) {
                this.setRoute(p, st);
            } else {
                this.setRoute(p, -1);
            }
            this.setRoute(q, 8);
        } else if (st == 8) {
            if (prev >= 0 && prev <= 3) {
                Address q = p.nextCell(prev);
                this.setRoute(q, -1);
                this.setRoute(p, 8);
            } else {
                this.setRoute(p, 8);
            }
        } else if (st == -1) {
            this.setRoute(p, -1);
        }
    }

    public void goBackRoute(Address p, int st) {
        int prev = this.getRoute(p);
        if (st == prev) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.STATE, p, prev, st));
        }
        if (prev >= 0 && prev <= 3) {
            Address q = p.nextCell(prev);
            this.setRoute(q, -1);
            this.setRoute(p, 8);
        }
    }

    public void eraseRoute(Address p0) {
        ArrayList<Address> routeCells = this.getCellsOfWholeRoute(p0);
        int i = routeCells.size() - 1;
        while (i >= 0) {
            Address p = routeCells.get(i);
            int s = this.getRoute(p);
            if (i >= 0) {
                this.changeRoute(p, 8);
            }
            if (i == 0) {
                this.changeRoute(p, -1);
            }
            --i;
        }
    }

    public ArrayList<Address> getCellsOfWholeRoute(Address p0) {
        int d;
        ArrayList<Address> routeArea = new ArrayList<Address>();
        Address p = p0;
        int s = this.getRoute(p);
        if (s == -1) {
            return routeArea;
        }
        while (true) {
            s = this.getRoute(p);
            d = this.getIncomingDirection(p);
            if (d != 0 && d != 1 && d != 2 && d != 3) break;
            p = Address.nextCell(p, d ^ 2);
        }
        if (d == 8 || d == -1) {
            // empty if block
        }
        while ((s = this.getRoute(p)) == 0 || s == 1 || s == 2 || s == 3) {
            routeArea.add(p);
            p = Address.nextCell(p, s);
        }
        if (s == 8) {
            routeArea.add(p);
        } else if (s == -1) {
            // empty if block
        }
        return routeArea;
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (s.getType() == AbstractStep.EditType.STATE) {
                Address p = s.getPos();
                this.setRoute(p, 8);
                int prev = s.getBefore();
                int st = s.getAfter();
                if (st >= 0 && st <= 3) {
                    Address q = p.nextCell(st);
                    this.setRoute(q, -1);
                    this.setRoute(p, prev);
                } else if (st == 8) {
                    if (prev >= 0 && prev <= 3) {
                        Address q = p.nextCell(prev);
                        this.setRoute(q, 8);
                        this.setRoute(p, prev);
                    } else {
                        this.setRoute(p, prev);
                    }
                } else if (st == -1) {
                    this.setRoute(p, prev);
                }
            } else if (s.getType() == AbstractStep.EditType.FIXED) {
                this.changeFixedNumber(s.getPos(), s.getBefore());
            }
        } else if (step instanceof AreaEditStep) {
            AreaEditStep s = (AreaEditStep)step;
            if (s.getOperation() == 1) {
                this.removeCell(s.getPos());
            } else if (s.getOperation() == 0) {
                this.addCell(s.getP0(), s.getPos());
            }
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (s.getType() == AbstractStep.EditType.STATE) {
                Address p = s.getPos();
                int prev = s.getBefore();
                int st = s.getAfter();
                if (st >= 0 && st <= 3) {
                    Address q = p.nextCell(st);
                    this.setRoute(p, st);
                    this.setRoute(q, 8);
                } else if (st == 8) {
                    if (prev >= 0 && prev <= 3) {
                        Address q = p.nextCell(prev);
                        this.setRoute(q, -1);
                    }
                    this.setRoute(p, 8);
                } else if (st == -1) {
                    this.setRoute(p, -1);
                }
            } else if (s.getType() == AbstractStep.EditType.FIXED) {
                this.changeFixedNumber(s.getPos(), s.getAfter());
            }
        } else if (step instanceof AreaEditStep) {
            AreaEditStep s = (AreaEditStep)step;
            if (s.getOperation() == 1) {
                this.addCell(s.getP0(), s.getPos());
            } else if (s.getOperation() == 0) {
                this.removeCell(s.getPos());
            }
        }
    }

    void addCell(Address p0, Address p) {
        if (Address.NOWHERE.equals(p0)) {
            Area a = new Area();
            this.addCellToArea(p, a);
        } else {
            Area a = this.getArea(p0);
            if (a != null) {
                this.addCellToArea(p, a);
            }
        }
    }

    void removeCell(Address p) {
        Area a = this.getArea(p);
        if (a != null) {
            this.removeCellFromArea(p, a);
        }
    }

    public void addCellToArea(Address p, Area a) {
        if (this.isRecordUndo()) {
            Address p0 = Address.NOWHERE;
            if (a.size() > 0) {
                p0 = a.getTopCell(Address.NOWHERE);
            }
            this.fireUndoableEditUpdate(new AreaEditStep(p, p0, 1));
        }
        if (a.isEmpty()) {
            this.areaList.add(a);
        }
        this.setArea(p, a);
        a.add(p);
    }

    public void removeCellFromArea(Address p, Area a) {
        if (this.isRecordUndo()) {
            Address p0 = Address.NOWHERE;
            if (a.size() > 1) {
                p0 = a.getTopCell(p);
            }
            this.fireUndoableEditUpdate(new AreaEditStep(p, p0, 0));
        }
        this.setArea(p, null);
        a.remove(p);
        if (a.isEmpty()) {
            this.areaList.remove(a);
        }
    }

    public void addArea(Area newArea) {
        for (Address p : newArea) {
            this.setArea(p, newArea);
        }
        this.areaList.add(newArea);
    }

    public void addWholeArea(Area newArea) {
        Address[] cells;
        Address[] addressArray = cells = newArea.toArray(new Address[0]);
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            this.addCellToArea(p, newArea);
            ++n2;
        }
    }

    public void removeWholeArea(Area oldArea) {
        Address[] cells;
        Address[] addressArray = cells = oldArea.toArray(new Address[0]);
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            this.removeCellFromArea(p, oldArea);
            ++n2;
        }
    }

    List<Area> getAreaList() {
        return this.areaList;
    }

    @Override
    public void initBoard() {
    }

    public int countRouteLength(Address p0) {
        int ret = -1;
        Address p = p0;
        int s = this.getRoute(p);
        if (s == -1) {
            return 0;
        }
        while (true) {
            ++ret;
            s = this.getRoute(p);
            if (s != 0 && s != 1 && s != 2 && s != 3) break;
            p = Address.nextCell(p, s);
        }
        if (s == 8 || s == -1) {
            // empty if block
        }
        return ret;
    }

    public int checkNumbers() {
        int ret = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getNumber(p) >= 0 && this.checkNumber(p) != 0 && ++ret > 0) {
                return ret;
            }
            ++n2;
        }
        return ret;
    }

    public int checkNumber(Address p) {
        int length = this.countRouteLength(p);
        int num = this.getNumber(p);
        return num - length;
    }

    public int checkAreas() {
        int ret = 0;
        for (Area a : this.getAreaList()) {
            int chk = this.checkArea(a, true);
            if (chk == 1 || ++ret <= 0) continue;
            return ret;
        }
        return ret;
    }

    public int checkArea(Area a, boolean noBall) {
        int nBall = 0;
        for (Address p : a) {
            if (this.getRoute(p) != 8 && (!noBall || !this.hasNumber(p) || this.getRoute(p) != -1) || ++nBall <= 1) continue;
            return nBall;
        }
        return nBall;
    }

    public int countAreasAndNumbers() {
        int nArea = this.areaList.size();
        int nNumber = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.hasNumber(p)) {
                ++nNumber;
            }
            ++n2;
        }
        return nNumber - nArea;
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        if (this.areaList.size() == 0) {
            result |= 1;
        }
        if (this.countAreasAndNumbers() != 0) {
            result |= 2;
        }
        if (this.checkNumbers() > 0) {
            result |= 4;
        }
        if (this.checkAreas() > 0) {
            result |= 8;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("satogaeri.AnswerCheckMessage1"));
        }
        if ((result & 2) == 2) {
            message.append(Messages.getString("satogaeri.AnswerCheckMessage2"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("satogaeri.AnswerCheckMessage3"));
        }
        if ((result & 8) == 8) {
            message.append(Messages.getString("satogaeri.AnswerCheckMessage4"));
        }
        return message.toString();
    }

    public Address i2a(int i) {
        return Address.address(i / this.cols(), i % this.cols());
    }

    public int a2i(Address a) {
        return this.cell(a.r(), a.c());
    }

    public boolean isOn(int p) {
        return p >= 0 && p < this.rows() * this.cols();
    }

    public int cell(Address p) {
        return this.cell(p.r(), p.c());
    }

    public int cell(int r, int c) {
        if (r < 0 || c < 0 || r >= this.rows() || c >= this.cols()) {
            return -1;
        }
        return r * this.cols() + c;
    }
}

