/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.satogaeri;

import java.util.Arrays;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.io.XmlReaderBase;
import pencilbox.satogaeri.Area;
import pencilbox.satogaeri.Board;

public class XmlReader
extends XmlReaderBase {
    private Board board;
    private Area[] areas;

    @Override
    protected BoardBase makeBoard() {
        this.board = new Board();
        return this.board;
    }

    @Override
    protected void start() {
        if (this.node == "areas") {
            int nArea = Integer.parseInt(this.attributes.getValue("N"));
            this.areas = new Area[nArea];
            int i = 0;
            while (i < nArea) {
                this.areas[i] = new Area();
                ++i;
            }
        }
    }

    @Override
    protected void setBN(int r, int c, int n) {
        this.areas[n].add(r, c);
        this.board.setArea(r, c, this.areas[n]);
    }

    @Override
    protected void onNumber() {
        int r = Integer.parseInt(this.attributes.getValue("r")) - 1;
        int c = Integer.parseInt(this.attributes.getValue("c")) - 1;
        int n = Integer.parseInt(this.attributes.getValue("n"));
        if (n == -2) {
            this.board.setNumber(r, c, -2);
        } else {
            this.board.setNumber(r, c, n);
        }
    }

    @Override
    protected void onBoardEnd() {
        super.onBoardEnd();
        this.board.getAreaList().addAll(Arrays.asList(this.areas));
    }

    @Override
    protected void setAN(int r, int c, int t) {
        if (t != -1) {
            this.board.setRoute(Address.address(r, c), t);
        }
    }
}

