#
# FS having unimplemented api
#
use strict;

use Test::More tests => 12;

use Fuse::Filesys::Virtual;

my $test = TestFS->new;
my $fs = Fuse::Filesys::Virtual->new($test, {debug => 0});

ok($fs->getattr("/a") < 0);
ok($fs->getdir("/a") < 0);
ok($fs->mknod("/a") < 0);
ok($fs->unlink("/a") < 0);
ok($fs->mkdir("/a") < 0);
ok($fs->rmdir("/a") < 0);
ok($fs->rename("/a", "/b") < 0);
ok($fs->truncate("/b") < 0);
ok($fs->utime("/b", 1, 2) < 0);
# ok($fs->open("/b", O_TRUNC) < 0);
ok(1);
ok($fs->write("/a", "xyz", 0) < 0);
ok($fs->read("/a", 1, 2) < 0);

$fs->release("/a");
$fs->release("/b");


#################################################
#
# Test FS
#
#################################################

package TestFS;

use base qw(Filesys::Virtual);

sub new {
    my $class = shift;
    bless {}, $class;
}
