#!/usr/bin/perl
#
# make ppm directory contains ppd and tar.gz of blib
#
use strict;
use File::Copy;

system("nmake");
system("nmake ppd");

use lib 'blib/lib';
use lib 'blib/arch';

use Win32::Dokan;

my $package = "Win32::Dokan";

my $ver_var = "\$${package}::VERSION";
my $ver = eval "$ver_var";
die $@ if ($@);

my ($v1, $v2, $v3, $v4) = map { $_ + 0 } split(/[._]/, $ver);
$v1 ||= 0;
$v2 ||= 0;
$v3 ||= 0;
$v4 ||= 0;

my $filename_base = $package;
$filename_base =~ s/::/-/g;

my $tar_gz = "${filename_base}-${ver}.tar.gz";
my $ppd = "${filename_base}.ppd";

rename $ppd, "$ppd.org" or die "cannot rename $ppd to $ppd.org $!";
open(my $org, "< $ppd.org") or die "cannot open $ppd.org $!";
open(my $fix, "> $ppd") or die "cannot create $ppd: $!";

while(<$org>) {
    s/(NAME="$filename_base" VERSION=)".*"/$1"$v1,$v2,$v3,$v4"/;
    s/CODEBASE HREF=""/CODEBASE HREF="$tar_gz"/;

    print $fix $_;
}

close($fix);
close($org);

system("tar", "zcf", $tar_gz, "blib");

my $ppm_dir = "${filename_base}-${ver}-ppm";

-d $ppm_dir || mkdir $ppm_dir or die "$ppm_dir: $!";

move($ppd, $ppm_dir);
move($tar_gz, $ppm_dir);
